// I5Cm4SHKT26Uy4r3QrCk9mjCHzYZuc5cyTcD4DYIKzje8jgPd0bD+bK3Vny4jgHqDDK/PN8ezvQAC0zcQNvMo4GDAeiSGZaH4MOA/k56MueqXq4qxqrB7/U+SEBy4dlSfVK7V3pLq0aHo1DpA28DJhn0WkyLXlJ3t09OTLHt29aEuYNsc3IgA3HOFxVa8ZOmVWqQvYiKkW5qN12wbebCLcqOt6G3eXs1EkULyfFCFVYfIhIYVH4yeCLkRpVqEtYnE034M3UUHWscx6Op4HwIs4MeGl5j7yGqjQI2jzUUz0YigPx+DhktWusU+rp0UHyOouYn8MojwqZOIMXyilS6dA==
/**

** Copyright (C) 2000-2010 Opera Software AS.  All rights reserved.

**

** This file is part of the Opera web browser.

**

** This script patches sites to work better with Opera

** For more information see http://www.opera.com/docs/browserjs/

**

** If you have comments on these patches (for example if you are the webmaster

** and want to inform us about a fixed site that no longer needs patching) please

** report issues through the bug tracking system

** https://bugs.opera.com/

**

** DO NOT EDIT THIS FILE! It will not be used by Opera if edited.

**/

// Generic fixes (mostly)

(function(opera){

	if(!opera || (opera&&opera._browserjsran))return;

	opera._browserjsran=true;

	var bjsversion=' Opera Desktop 10.00 core , May 28, 2010 ';

	// variables and utility functions

	var navRestore = {}; // keep original navigator.* values

	var shouldRestore = false;

	var hostname = location.hostname; // caching some strings for performance

	var href = location.href;

	var pathname=location.pathname;

	var fixed = false; // magic fixes need only run once

	if(!opera.postError)opera.postError=function(){}; // handling versions w/o error console

	// Storing function references

	var postError = opera.postError,

	call = Function.prototype.call,

	indexOf=String.prototype.indexOf,

	lastIndexOf=String.prototype.lastIndexOf,

	replace=String.prototype.replace,

	match=String.prototype.match,

	toLowerCase=String.prototype.toLowerCase,

	getAttribute=Element.prototype.getAttribute,

	setAttribute=Element.prototype.setAttribute,

	insertBefore=Node.prototype.insertBefore,

	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,

	defineMagicVariable=opera.defineMagicVariable,

	defineMagicFunction=opera.defineMagicFunction,

	version=opera.version,

	getElementById=Document.prototype.getElementById,

	appendChild=Node.prototype.appendChild,

	removeChild=Node.prototype.removeChild,

	replaceChild=Node.prototype.replaceChild,

	evaluate=Document.prototype.evaluate,

	getElementsByTagName=Document.prototype.getElementsByTagName,

	createElement=Document.prototype.createElement,

	createEvent=Document.prototype.createEvent,

	dispatchEvent=Document.prototype.dispatchEvent,

	initEvent=Event.prototype.initEvent,

	createTextNode=Document.prototype.createTextNode,

	stopPropagation=Event.prototype.stopPropagation,

	preventDefault=Event.prototype.preventDefault,

	getComputedStyle=window.getComputedStyle,

	slice=Array.prototype.slice,

	shift=Array.prototype.shift,

	setTimeout=window.setTimeout,

	removeAttribute=Element.prototype.removeAttribute,

	addEventListener=Document.prototype.addEventListener,

	isNaN=window.isNaN,

	RegExp=window.RegExp,

	unescape=window.unescape,

	func_toString=Function.prototype.toString,

	parseFloat=window.parseFloat,

	random=Math.random;

	var opera_version = parseFloat.call(window,opera.version());

	var tinyMCEVersionInfo={};



	// Utility functions

	function addCssToDocument(cssText, doc, mediaType){

		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;

		doc = doc||document;

		mediaType = mediaType||'';

		addCssToDocument.styleObj=addCssToDocument.styleObj||{};

		var styles = addCssToDocument.styleObj[mediaType];

		if(!styles){

			var head = getElementsByTagName.call(doc, "head")[0];

			if( !head ){

				var docEl = getElementsByTagName.call(doc, "html")[0];

				if(!docEl){

					// :S this shouldn't happen - see if document hasn't loaded

					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',

					function(){ addCssToDocument(cssText, doc); },false);

					return;

				}

				head = createElement.call(doc, "head");

				if(head) insertBefore.call(docEl, head,docEl.firstChild);

				else head = docEl;

			}

			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");

			setAttribute.call(styles, "type","text/css");

			if(mediaType)setAttribute.call(styles, "media", mediaType);

			appendChild.call(styles, createTextNode.call(doc,' '));

			appendChild.call(head, styles)

		}

		styles.firstChild.nodeValue += cssText+"\n";

		return true;

	}


	function addPreprocessHandler( search, replacement, onceonly, conditional ){

		// adding event handler for script pre-processing if required

		opera.addEventListener('BeforeScript', 

			function(e){ 

				indexOf.call=replace.call=removeEventListener.call=call; /* also needs anything used inside conditional! */

				if( conditional && ! conditional(e.element) ){return;}

				e.element.text=replace.call( e.element.text, search, replacement );

				if(onceonly){

					removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);

				}

			}

		, false);

	}


function avoidDocumentWriteAbuse(contentRegexp){

	var dw=document.write;

	contentRegexp = contentRegexp || /(^<img .*?width=("|)1("|)\s+height=("|)1("|)\s+border=("|)0("|)\s+alt="".*?>$|^\[object Object\]$)/i;

	document.write=function( s ){

		if( String(s).match( contentRegexp ) ){

			opera.postError('Warning: scripts on '+window.location+' were changed by the s_code patch. See browser.js for details.');

		}else{//opera.postError(arguments);

			dw.apply(document, arguments);

		}

	};

}
function avoidMagicBodyCreation(){

	document.createElement=(function(createElement){

		var tmpDoc = document.implementation.createDocument('http://www.w3.org/1999/xhtml/', 'html', null);

		return function(tagName){

			if( ! document.body ){

				return createElement.call( tmpDoc, tagName );

			}else{

				document.createElement=createElement; // this hack is not necessary anymore

				return createElement.call(this, tagName);

			}

		}

	})(document.createElement);

}
function emulateIECapturingEvents(){

	// An implementation of IE5 mouse event capturing

	var capturingEventsTable =

			{'mousedown':'',

			'mouseup':'',

			'mousemove':'',

			'click':'',

			'dblclick':'',

			'mouseover':'',

			'mouseout':'',

			'contextmenu':''};

	var loseCaptureEventsTable =

			{'contextmenu':''};

	var capturingEl = null;

	var capturingContainer;

	var cachedSelection;

	var cachedSelectionCollapsed;

	var loseCaptureEl;



	HTMLElement.prototype.setCapture = function(isCapturingContainer) {

		if (capturingEl && capturingEl != this) {

			capturingEl.releaseCapture();

		}

		capturingEl = this;

		var sel = window.getSelection();

		cachedSelection = sel.rangeCount?sel.getRangeAt(0):null;

		cachedSelectionCollapsed = !(cachedSelection && !cachedSelection.collapsed);

		loseCaptureEl = null;

		capturingContainer = (isCapturingContainer !== false); // defaults to true

	};



	HTMLElement.prototype.releaseCapture = function() {

		if (capturingEl != this) return;

		capturingEl = null;

		if (cachedSelection) {

			var sel = window.getSelection();

			sel.removeAllRanges();

			sel.addRange(cachedSelection);

			cachedSelection = null;

		} else {

			document.execCommand('unselect', null, true);

		}



		var loseCaptureEvent;

		try {

			loseCaptureEvent = document.createEvent('CustomEvent'); // DOM 3

		} catch(e) {

			loseCaptureEvent = document.createEvent('Event');

		}

		loseCaptureEvent.initEvent(

				'losecapture', // type

				false,         // bubbles

				false          // cancellable

		);

		this.dispatchEvent(loseCaptureEvent);

	};



	document.releaseCapture = function() {

		if (!capturingEl) return;

		capturingEl.releaseCapture();

	};

	var ignoreEvent;

	var mouseDownEl;

	function capturingListener(evt) {

		if (!capturingEl) return;

		if (ignoreEvent == evt) return;

		if (parseFloat(opera.version(), 10) >= 9.5 && evt.type != 'mousemove' && evt.type != 'mouseout') {

			document.execCommand('unselect', null, true);

		}

		if (mouseDownEl && evt.type == 'click' && mouseDownEl.contains(evt.target)) {

			mouseDownEl = null;

			evt.stopPropagation();

			evt.preventDefault();

			return;

		}

		var currentCapturingEl = capturingEl;

		var originalEvent = evt;

		var originalTarget = originalEvent.target;

		if (typeof(loseCaptureEventsTable[originalEvent.type])!='undefined') {

			loseCaptureEl = currentCapturingEl;

		}

		if (!capturingContainer &&

				originalTarget != currentCapturingEl &&

				currentCapturingEl.contains(originalTarget))

		{

			return;

		}

		var fakeEvent = document.createEvent('MouseEvent');

		fakeEvent.initMouseEvent(

				originalEvent.type,

				originalEvent.bubbles,

				originalEvent.cancelable,

				window,

				originalEvent.detail,

				originalEvent.screenX,

				originalEvent.screenY,

				originalEvent.clientX,

				originalEvent.clientY,

				originalEvent.ctrlKey,

				originalEvent.altKey,

				originalEvent.shiftKey,

				originalEvent.metaKey,

				originalEvent.button,

				originalEvent.relatedTarget

		);

		ignoreEvent = fakeEvent;

		if (fakeEvent.__defineGetter__) fakeEvent.__defineGetter__('srcElement', function() {

			return originalTarget;

		});

		var retVal = currentCapturingEl.dispatchEvent(fakeEvent);

		if (currentCapturingEl != loseCaptureEl) {

			originalEvent.stopPropagation();

			if (!retVal) {

				originalEvent.preventDefault();

			}

		}



		if (originalEvent.type == 'mousedown') {

			mouseDownEl = originalTarget;

		} else if (originalEvent.type == 'mouseup') {

			if (!currentCapturingEl.contains(originalTarget) || currentCapturingEl.contains(mouseDownEl) ||

					(mouseDownEl && !mouseDownEl.contains(originalTarget))) {

				fakeEvent = document.createEvent('MouseEvent');

				fakeEvent.initMouseEvent(

						'click',

						originalEvent.bubbles,

						originalEvent.cancelable,

						window,

						originalEvent.detail,

						originalEvent.screenX,

						originalEvent.screenY,

						originalEvent.clientX,

						originalEvent.clientY,

						originalEvent.ctrlKey,

						originalEvent.altKey,

						originalEvent.shiftKey,

						originalEvent.metaKey,

						originalEvent.button,

						originalEvent.relatedTarget

				);

				if (fakeEvent.__defineGetter__) fakeEvent.__defineGetter__('srcElement', function() {

					return originalTarget;

				});

				ignoreEvent = fakeEvent;

				currentCapturingEl.dispatchEvent(fakeEvent);

			}

			if (!currentCapturingEl.contains(mouseDownEl)) {

				mouseDownEl = null;

			}

		}

		ignoreEvent = null;

	}

	var loseCaptureAfterEvent = function(evt) {

		if (!loseCaptureEl) return;

		loseCaptureEl.releaseCapture();

		loseCaptureEl = null;

	};



	for(var event in capturingEventsTable ){

		window.addEventListener(event, capturingListener, true);

	}

	for(var event in loseCaptureEventsTable ){

		window.addEventListener(event, loseCaptureAfterEvent, false);

	}



	if(document.selection)document.selection.empty = function() {

		if (!capturingEl) return document.execCommand('unselect', null, true);

		cachedSelection = null;

	};

	var getCommonAncestor = function(a, b) {

		var range = document.createRange();

		try {

			range.setStart(a, 0);

			range.setEnd(b, 0);

			return range.commonAncestorContainer;

		} catch(e) {

			return document;

		}

	};

	window.addEventListener('mouseover', function(originalEvent) {

		if (capturingEl) return;

		var fakeEvent = document.createEvent('MouseEvent');

		fakeEvent.initMouseEvent(

			'mouseenter',

			originalEvent.bubbles,

			originalEvent.cancelable,

			window,

			originalEvent.detail,

			originalEvent.screenX,

			originalEvent.screenY,

			originalEvent.clientX,

			originalEvent.clientY,

			originalEvent.ctrlKey,

			originalEvent.altKey,

			originalEvent.shiftKey,

			originalEvent.metaKey,

			originalEvent.button,

			originalEvent.relatedTarget

		);

		var commonAncestor = getCommonAncestor(originalEvent.target, originalEvent.relatedTarget);

		var listener = function(evt) {

			if (evt == fakeEvent) {

				commonAncestor.removeEventListener('mouseenter', arguments.callee, false);

				evt.stopPropagation();

			}

		};

		commonAncestor.addEventListener('mouseenter', listener, false);

		originalEvent.target.dispatchEvent(fakeEvent);

		commonAncestor.removeEventListener('mouseenter', listener, false);

	}, false);

	window.addEventListener('mouseout', function(originalEvent) {

		if (capturingEl) return;

		var fakeEvent = document.createEvent('MouseEvent');

		fakeEvent.initMouseEvent(

			'mouseleave',

			originalEvent.bubbles,

			originalEvent.cancelable,

			window,

			originalEvent.detail,

			originalEvent.screenX,

			originalEvent.screenY,

			originalEvent.clientX,

			originalEvent.clientY,

			originalEvent.ctrlKey,

			originalEvent.altKey,

			originalEvent.shiftKey,

			originalEvent.metaKey,

			originalEvent.button,

			originalEvent.relatedTarget

		);

		var commonAncestor = getCommonAncestor(originalEvent.target, originalEvent.relatedTarget);

		var listener = function(evt) {

			if (evt == fakeEvent) {

				commonAncestor.removeEventListener('mouseleave', arguments.callee, false);

				evt.stopPropagation();

			}

		};

		commonAncestor.addEventListener('mouseleave', listener, false);

		originalEvent.target.dispatchEvent(fakeEvent);

		commonAncestor.removeEventListener('mouseleave', listener, false);

	}, false);

}
	function fakeCSSFilters(){ // faking support for some of the common filters so that using them won't stop the script

		var filterObj={apply:function(){}, play:function(){}, Apply:function(){}, Play:function(){}}; // some of the common functions

		HTMLElement.prototype.filters=[ filterObj, filterObj, filterObj ]; // fake three applied filters with play and apply functions

		HTMLElement.prototype.filters['blendTrans']=filterObj; // we also fake a named blendTrans filter

	}


function fakeOncontextmenu( useAltClick, clickAndHold ){



	if ( 'oncontextmenu' in document.createElement('foo') )

		//contextmenu supported - nothing to do

		return;

		

	function cloneObject(src,dest){

		dest=dest||{};

		for(var prop in src)

			dest[prop]=src[prop];

		return dest;

	};

	function prepareContextMenuEvent(e,node){

		var ev = cloneObject(e);

		ev.currentTarget=node;

		ev.type='contextmenu';

		ev.returnValue=true;

		ev.cancelBubble=false;

		ev.preventDefault=function(ev){this.returnValue=false;}

		ev.stopPropagation=function(ev){this.cancelBubble=false;}

		return ev;

	}

	function ctxClickHandler(e){

		var node = e.target, foundAnything = false;

		do{

			if( typeof node.oncontextmenu == 'function' ){

				var ev = prepareContextMenuEvent(e,node)

				try{

					node.oncontextmenu(ev);

					if(!ev.returnValue)

						e.preventDefault();

					if(ev.cancelBubble){

						e.stopPropagation();

						return true;

					}

				}catch(ex){

					setTimeout(function(){throw ex;},1);

				}

				foundAnything = true;

			}else if( node.getAttribute && (js = node.getAttribute('oncontextmenu')) ){

				var ev = prepareContextMenuEvent(e,node)

				try{

					var retVal = eval('(function(){'+js+';}).call(node,ev);')||ev.returnValue ;

					if(!retVal && (retVal!==undefined))

						e.preventDefault();

					if(ev.cancelBubble){

						e.stopPropagation();

						return true;

					}

				}catch(ex){

					setTimeout(function(){throw ex;},1);

				}

				foundAnything = true;

			}

		}while(node=node.parentNode);

		return foundAnything;

	}

	function dispatchCtxMenuEvent(e){

		var doc = e.target.ownerDocument||(e.view?e.view.document:null)||e.target;

		var newEv = doc.createEvent('MouseEvent');

		newEv.initMouseEvent('contextmenu', true, true, doc.defaultView, e.detail,

			e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey,

			e.shiftKey, e.metaKey, 2, e.relatedTarget);

		if(newEv.__defineGetter__){

			newEv.__defineGetter__('offsetX', function(){return this.clientX;});

			newEv.__defineGetter__('offsetY', function(){return this.clientY;});

		}



		e.target.dispatchEvent(newEv);

	};

	

	var isRightClick = false;

	addEventListener('mousedown',function(e){

		if( e && e.button == 2 ){

			isRightClick = true;

			setTimeout(function(){isRightClick=false;},1000);

		}

	},true);

	addEventListener('mouseup',function(e){

		//right-click doesn't fire click event. Only mouseup

		if( e && e.button == 2 && isRightClick){

			dispatchCtxMenuEvent(e);

		}

		clearCtxTimeout();

	},true);

	addEventListener('contextmenu',function(e){

		ctxClickHandler(e);

	},true);

	if(useAltClick)

		addEventListener('click',function(e){

			if( e && e.button == 0 && e.altKey ){

				dispatchCtxMenuEvent(e);

			}

		},true);



			

	var eventCopy, ctxMenuTimeout;

	var pixelThreshold = 3;

	var msecCtxValue = clickAndHold;

	

	function clearCtxTimeout(){

		clearTimeout(ctxMenuTimeout);

		ctxMenuTimeout = eventCopy = null;

	}

	

	if( clickAndHold && typeof clickAndHold == 'number' ){

		addEventListener('mousedown',function(e){

			if(e && e.button!=2){

				eventCopy = cloneObject(e);

				eventCopy.preventDefault = function(){};

				eventCopy.stopPropagation = function(){};

				ctxMenuTimeout = setTimeout(function(){if(eventCopy)dispatchCtxMenuEvent(eventCopy);},msecCtxValue);

			}

		},true);

		

		addEventListener('mousemove',function(e){

			if( ctxMenuTimeout && eventCopy && e )

				if( Math.abs(e.clientX-eventCopy.clientX) > pixelThreshold ||

					Math.abs(e.clientY-eventCopy.clientY) > pixelThreshold ){

					clearCtxTimeout();

				}

		},true);

	}

	

};


	function fixCoolmenus(name){

		if(fixed){return;}fixed=true;

		defineMagicVariable.call=call;

		// Version 4 is Opera 7 - compatible and does user agent sniffing

		navRestore['userAgent'] = navigator.userAgent;

		navigator.userAgent +=' msie 6';

		shouldRestore = true;

		defineMagicVariable.call(opera, 'bw', function(o){

			// we need to override yet some more browser detection, and disable CSS filters

			// usedom must be 0 to make frameset menus work

			o.filter=o.op7=o.op=o.usedom=o.ns6=0;

			o.ie=o.ie6=1;

			return o}, function(o){return o});

		addPreprocessHandler(  'this.win.document.body.appendChild(oNS)',  'try{this.win.document.body.appendChild(oNS)}catch(e){oNS=this.win.document.body.appendChild(this.win.document.importNode(oNS, true))}' );

		addPreprocessHandler(  'oNS.appendChild(oNS2)',  'try{oNS.appendChild(oNS2);}catch(e){oNS2=oNS.appendChild(oNS.document.importNode(oNS2, true));}' );

	}


	function fixHVMenu(name){

		if(fixed){return;}fixed=true;

		defineMagicVariable.call=match.call=call;

		// fix by changing Opera from an unsupported browser to a supported browser

		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp

		defineMagicVariable.call(opera, 'PosStrt', function(){ return true }, null);

		defineMagicVariable.call(opera, 'NavYes', function(){ return true }, null);

		defineMagicVariable.call(opera, 'DomNav', function(){ return true }, null);

		// if Opera >= 9.5, load events are sent to document and not to body - make sure script doesn't set body.onload

		defineMagicVariable.call(opera, 'Trigger', function(){ return window; }, null);

		// Tell the script that CSS filters are not supported.

		defineMagicVariable.call(opera, 'Fltr', function(){ return false; }, function(){ return });

		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above

		if(  match.call(name, /var\.js$/) || match.call(name, /compact\.js$/) ){

			navRestore['userAgent'] = navigator.userAgent;

			navigator.userAgent+=' opera 7'; 

			shouldRestore = true;

		}

	}
	function fixHierMenus(){

		if(fixed){return;}fixed=true;

		defineMagicVariable.call=call;

	      // HM_IsMenu must be true to make the menu appear

	      // HM_BrowserString should be DOM to make the right library load

		defineMagicVariable.call(opera, 'HM_IsMenu', function(){ return true}, function(){ return true });

		if(!document.all)defineMagicVariable.call(opera, 'HM_IE', function(){ return true}, function(){ return true });

		defineMagicVariable.call(opera, 'HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });

		if(HTMLBodyElement.prototype.__defineGetter__)HTMLBodyElement.prototype.__defineGetter__('clientHeight', function(){return this.ownerDocument.documentElement.clientHeight;}); // PATCH-33

	}


function fixIFrameSSIscriptII(name, iFrameId){

	if(typeof name==='string'&&!arguments.callee.name)opera.defineMagicFunction(name, function (a,b,frameid){

		frameid = frameid|| iFrameId;

		var currentfr=document.getElementById(frameid);

		if (currentfr){

			currentfr.height = currentfr.contentDocument.documentElement.scrollHeight;

			if(!arguments.callee._listenerAdded){

				currentfr.addEventListener("load", arguments.callee, false);

				arguments.callee._listenerAdded=true;

			}

		}

	});

	fixIFrameSSIscriptII[name]=1;//remember that we fixed this already

}
function fixLiknoAllWebMenus(ev){

	indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=appendChild.call=createElement.call=preventDefault.call=replace.call=call;

	if(fixed)return; fixed=true;

	if( indexOf.call(ev.element.text, 'AllWebMenus Libraries Version # ' )>-1 ){

		// AWM loads different libraries based on numbers - number 2 is Gecko-compat

		// some outdated Opera-libraries are now broken due to bug fixes and such.

		var awmVersion = parseInt(match.call(ev.element.text, /AllWebMenus Libraries Version # (\d*)/)[1]);

		if( awmVersion <=531  ){ // likely to old to work..

			defineMagicVariable.call(opera,   'scriptNo', function(){return 2}, null);

			defineMagicVariable.call(opera,   'awmBefore7', function(){return false}, function(){return false} );

			preventDefault.call(ev); // don't run this script

			var script = appendChild.call(document.body, createElement.call(document, 'script')); // create another one..

			script.src = replace.call(ev.element.src, /awmlib\d*\.js/, 'awmlib2.js'); // and load a more suitable version

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');

		}

		removeEventListener.call(opera, 'BeforeScript', arguments.callee, false );

	}

}
	function fixMilonicMenu(name){ 	// gotcha: must be called with script.src as argument

		if(fixed){return;}fixed=true;

		defineMagicVariable.call=defineMagicFunction.call=addEventListener.call=call;

	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)

		defineMagicVariable.call(opera, 'opera', function(){ return false }, function(){});

		defineMagicVariable.call(opera, 'opra', function(){ return false }, function(){});

		// ie55 true will use IFRAME shims

		defineMagicVariable.call(opera, 'ie55', function(){ return false }, function(){ });

		// identifying as Opera will cause "dom" variable to be false in some versions

		defineMagicVariable.call(opera,  'dom' , function(){ return true }, function(){});

		// fixForm function will hide page content

		defineMagicFunction.call(opera,  'fixForm' , function(){});

		// Menu does not work on Mac if it detects platform

		defineMagicVariable.call(opera, 'mac', function(){ return false }, function(){ });

		// bug 330958

		if(!window.scrollX){

			opera.defineMagicVariable('scrollY', function(){ return document.body.scrollTop;}, null);

			opera.defineMagicVariable('scrollX', function(){ return document.body.scrollLeft;}, null);

		}

	}


function fixOpenCube(name){// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument

	if(fixed)return;

	match.call=addEventListener.call=defineMagicVariable.call=indexOf.call=call;

	// OpenCube menu

	window.vxml = window.vxml||{}; // to fix semi-opera-detection

	//Some versions try to call a function q99 which is only defined in the Opera library

	addEventListener.call(window, 'load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);

	// fake some support for the menu version that tries to use CSS filters in spite of magic var below

	fakeCSSFilters();

	// We'll overrule their sniffing and find the correct library for Opera

	if(indexOf.call(navigator.appVersion, 'Mac')!=-1){

		// They don't seem to like Macs.. see 356184

		navigator.appVersion = replace.call( navigator.appVersion, 'Mac', 'M A C' );

		addEventListener.call(opera, 'AfterExternalScript', function(){

			replace.call = removeEventListener.call = call;

			navigator.appVersion = replace.call( navigator.appVersion, 'M A C', 'Mac' );

			removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);

		}, false);

		// some variables are uninitialized

		q20=q21=[];

	}

	if(match.call(name, /dqm_script\d*\.js$/)){

		defineMagicVariable.call(opera, 'brn', function(val){ return 'ie' }, function(val){ return 'ie' });

		defineMagicVariable.call(opera, 'ie6', function(val){ return true }, function(val){ return true });

		// prevent the menu from trying to use CSS filters

		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);

		if(document.evaluate){ // we have an event transparency problem on some sites, see for example bug 239622

			addEventListener.call(window, 'load', function(){

				var nodes=document.evaluate( '//a/child::img[substring(@id, 0, 4)=\'qmim\']', document.body,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null ),node;

				while( node=nodes.iterateNext()){

					node.parentElement.parentElement.replaceChild(node, node.parentElement );

				};

			}, false);

		}

		fixed=true;

		return true;

	}else if(indexOf.call(name, 'dqm_loader.js')>-1){

		defineMagicVariable.call(opera, 'brn', function(val){ return 'opera7' }, function(val){return 'opera7'});

		// prevent the menu from trying to use CSS filters

		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);

		fixed=true;

		return true;

	}else if(indexOf.call(name, 'dnm_script.js')>-1){ // very old version.. 153257

		defineMagicVariable.call(opera, 'ie5', function(val){ return true }, function(val){ return true });

		defineMagicVariable.call(opera, 'ns5', function(val){ return true }, function(val){ return true });

	}

}


	function fixSoThinkMenus(){

		if(fixed){return;}fixed=true;

		defineMagicVariable.call=addEventListener.call=call;

		defineMagicVariable.call(opera, 'nOP',function(){return false;},null);

		defineMagicVariable.call(opera, 'nIE',function(){return false;},null);

		defineMagicVariable.call(opera, 'nNN6',function(){return true;},null);

		addEventListener.call(window, 'load', function(e){ if(window.st_onload)st_onload(e); }, false );//PATCH-55

	}


	function fixTransmenus(){

		// Fixing bugs in menu script from http://www.youngpup.net/2004/transmenus/ 

		// Credits xErath and Andrew Gregory

		opera.addEventListener('BeforeScript', function(ev) {

			indexOf.call=replace.call=removeEventListener.call=call;

			var js = ev.element.text;

			if (indexOf.call(js, "TransMenu")!=-1) {

				js = replace.call(js, /return\s+r(\b)/,"return true$1");

				js = replace.call(js, /mac/g,"xpto");

				js = replace.call(js, "el.scrollLeft", "0");

				js = replace.call(js, "el.scrollTop", "0");

				ev.element.text = js;

				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);

			}

		}, false);

	}


	function fixUDM(name){

		if(fixed){return;}fixed=true;

		defineMagicVariable.call=call;

		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..

		defineMagicVariable.call(opera, 'op5',function () { return 0; },null);

		defineMagicVariable.call(opera, 'ns6',function () { return 1; },null);



		// certain versions break if insertRule throws exceptions. Also see bug 242411.

		// Better fake missing support for DOM2Style then..

		defineMagicVariable.call(opera, 'um', function(o){ o.ss=false; return o; }, null);

    }


function ignoreCancellationOfCertainKeyEvents(type, list){

	opera.addEventListener( 'BeforeEventListener.'+type, function(e){

		preventDefault.call=call;

		if( e.event.keyCode in list ){

			preventDefault.call(e);

		}

	},false );

}
function ignoreRequiredAttributes(){

	document.addEventListener('invalid', function(e){

		if( e.target.validity.valueMissing){

			e.target.removeAttribute('required');

			e.preventDefault();

			opera.postError('Warning: overriding built-in "required" attribute validation on page. See browser.js for details.');

		}

	},true);

}
function removeClosingHTMLComments(){

    opera.addEventListener( 'BeforeScript', function(e){ replace.call=call; e.element.text=replace.call( e.element.text, /\r\n\s*-->\s*\r\n/, '' ); }, false );

}


function sendOperaEvent(name, target){

	initEvent.call=createEvent.call=dispatchEvent.call=call;

	var evt=createEvent.call(document, 'Event');

	initEvent.call(evt, name, false, false);

	evt.element=target;

	dispatchEvent.call(opera, evt);

}
function setTinyMCEVersion(e){

	if(tinyMCEVersionInfo.majorVersion)return; // already found it

	indexOf.call=match.call=call;

	// look at source code

	if( e && indexOf.call(e.element.text, 'majorVersion' )>-1  ){

		if(match.call(e.element.text, /majorVersion\s*[:=]+\s*["']?(\d)/)){ tinyMCEVersionInfo.majorVersion=RegExp.$1; }

		if(match.call(e.element.text, /minorVersion\s*[:=]+\s*["']?(\d(\.\d|))/)){ tinyMCEVersionInfo.minorVersion=RegExp.$1; }

	}

	// if an instance has already been created, we can read version info from it...

	var tinyInstance='tinyMCE' in window?window.tinyMCE : 'tinymce' in window ? window.tinymce : 'tiny_mce' in window ?  window.tiny_mce : null;

	if(tinyInstance&&tinyInstance.majorVersion)tinyMCEVersionInfo={ majorVersion:tinyInstance.majorVersion, minorVersion:tinyInstance.minorVersion };

}


function solveEventOrderBugs(){

	var delayedMouseMoveEvents=[];

	var delayedMouseOutEvents=[];

	var delayedMouseOutTimeout=null;

	var lastMouseTarget=null;

	opera.addEventListener('BeforeEventListener.mouseover', function(e){

		lastMouseTarget=e.event.target;

		if( delayedMouseOutEvents.length ){

			fireDelayedEvents(delayedMouseOutEvents);

			clearTimeout(delayedMouseOutTimeout);

		}

	},false);



	opera.addEventListener('BeforeEventListener.mousemove', function(e){

		if(e.event.__opFakeEvent)return;

		if( lastMouseTarget!=e.event.target ){

			delayedMouseMoveEvents.push(e.event);

			e.preventDefault();

		}else if( delayedMouseOutEvents.length && delayedMouseOutEvents[0].relatedTarget!=e.event.target ){

			fireDelayedEvents(delayedMouseOutEvents);

			clearTimeout(delayedMouseOutTimeout);

		}

		lastMouseTarget=e.event.target;

	},false);

	opera.addEventListener( 'AfterEventListener.mouseover', fireDelayedEvents ,false);

	opera.addEventListener( 'BeforeEventListener.mouseout', function(e){

		if(e.event.__opFakeEvent)return;

		if( delayedMouseMoveEvents[0] ){

			delayedMouseOutEvents.push(e.event);

			e.preventDefault();

			e.event.cancelBubble=true;

			clearTimeout(delayedMouseOutTimeout);

			delayedMouseOutTimeout=setTimeout( function(){fireDelayedEvents(delayedMouseOutEvents);}, 650 );

		}

	} ,false);

	function fireDelayedEvents(evts){

		evts=evts&&evts.shift?evts:delayedMouseMoveEvents;

		var ev;

		while(ev=evts.shift()){

			ev.__opFakeEvent=true;

			ev.cancelBubble=false;

			ev.target.dispatchEvent(ev);

		}

	}

};




	// Sending an extra onreadystatechange causes some ad scripts to eat memory
// The required attribute does not take the value false according to WebForms2 - remove "required=false" from form elements
// The constructor property of DOM nodes should not be Object
// Constructor property of event should be Event interface
// lines reversed on enter by workaround against old Opera bug
// no code in TinyMCE 2.x HTML source editor because it expects a different order of load events
// Generic JS library patches
// Prevent unsolicited access to Java's deploymenttoolkit
// PDF security patch
// Generic patch to support window.scrollX, window.scrollY
// Asia-region Generic Patches
			// PATCH-177, Sending an extra onreadystatechange causes some ad scripts to eat memory
	opera.addEventListener( 'BeforeEventListener.readystatechange', function(e){

		var element=e.event.target;

		preventDefault.call=random.call=postError.call=call;

		var elId=element.sourceIndex;

		if(!elId)element.__operaReadyStateFakeID__=elId=element.__operaReadyStateFakeID__||random.call(Math);

		if( element.readyState == 'loaded' && element.tagName == 'SCRIPT' ){

			if( e.listener['__operaReadyStateAlreadyCalled'+elId+'__'] ) {

				preventDefault.call(e);

				postError.call(opera, 'Opera applied workaround against double readystate events. See browser.js for details');

			} else {

				e.listener['__operaReadyStateAlreadyCalled'+elId+'__']  = true;

			}

		}

	}, false);
			// 305669, The required attribute does not take the value false according to WebForms2 - remove "required=false" from form elements
	window.addEventListener('load', function(){

		try{var obj = document.evaluate( '//input[translate(@required, "FALSE", "false")="false"]', document.documentElement, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null ), el, i=0 ;

		while(el=obj.snapshotItem(i)){el.removeAttribute('required');i++;}}catch(e){}

	}, false);
			// CORE-17333, The constructor property of DOM nodes should not be Object
	Element.prototype.constructor=Element;
			// CORE-17460, Constructor property of event should be Event interface
	Event.prototype.constructor=Event;
			// DSK-223254, lines reversed on enter by workaround against old Opera bug
	opera.addEventListener('bjsOnTinyMCEScript', function(e){

		if(tinyMCEVersionInfo.majorVersion<3 || ( tinyMCEVersionInfo.majorVersion==3 && (parseInt(tinyMCEVersionInfo.minorVersion)==0 || tinyMCEVersionInfo.minorVersion=='X' /*X: see CORE-15898*/ ))){

			e.element.text = e.element.text.replace( /if\s*\((tinyMCE\.|)isOpera\)\s*\{(\s*(\w{1,}\.normalize\(\);|)\s*\w{1,}\.insertNode\(\s*\w{1,}\s*\);)/g , 'if(false){$2' );

			e.element.text = e.element.text.replace( /if\([\w\.]+\)\{(\w+)\.insertNode\((\w+)\);\1\.insertNode\((\w+)\)\}else\{\1\.insertNode\(\3\);\1.insertNode\(\2\)/g , function(str){ return str.replace( /if\([\w\.]\)/, 'if(false)' ) } ); // PATCH-248

		}

	}, false);

	
			// DSK-199930, no code in TinyMCE 2.x HTML source editor because it expects a different order of load events
	opera.addEventListener('bjsOnTinyMCEScript', function(e){

		if( e.element.src.indexOf('popup')>-1 && ( (tinyMCEVersionInfo&&tinyMCEVersionInfo.majorVersion<3&&tinyMCEVersionInfo.minorVersion<1.3)||!tinyMCEVersionInfo.majorVersion) ){

			var name=tinyMCEVersionInfo.minorVersion==0?'TinyMCEPopup':'TinyMCE_Popup';//sigh..

			opera.defineMagicVariable(name, function(o){

				o.prototype.resizeToInnerSize=function(){};

				o.prototype.executeOnLoad=function(str){eval(str);}

				return o;

			}, null);

		}

	}, false);

	
			// PATCH-139, Generic JS library patches
	// Use an event listener to detect specific scripts

	opera.addEventListener( 'BeforeExternalScript', function(ev){

		match.call=replace.call=indexOf.call=toLowerCase.call=postError.call=addEventListener.call=removeEventListener.call=version.call=parseFloat.call=call;

		

		var name=ev.element.src; 

		if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..

		name=toLowerCase.call(name );// toLowerCase fixes sangjatten.se

	      if ( indexOf.call(name, 'dqm_')>-1 || indexOf.call(name, 'dnm_')>-1 || indexOf.call(name, 'cbrowser_opera.js')>-1 ){ 

			// OpenCube menu

			if(fixOpenCube(name)){

				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (OpenCube fix). See browser.js for details.');

			}

			return;

	      }else if(  indexOf.call(name, 'hm_loader')>-1  ){ 

			// HierMenus menu

			// If we apply this fix to version 6.x the menu breaks.

			// HM support recommends checking that HM_BrowserVersion is not defined

			addEventListener.call(opera, 'BeforeScript', function(ev){ 

				match.call=removeEventListener.call=postError.call=call;

				if( ev.element.text && ! match.call(ev.element.text, /hm_browserversion/i) ){

					fixHierMenus(name);

					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HierMenus fix). See browser.js for details.');

				}

				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);

			}, false);

			return;

	      }else if(  indexOf.call(name, 'mmenu')>-1 || indexOf.call(name, 'milonic')>-1  ){ 

			// Milonic menu

			fixMilonicMenu(name);

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Milonic fix). See browser.js for details.');

			return;

		

	      }else if(  match.call(name, /menu\d*_(com|build|var|program|compact)\.js$/)   ){ 

			// HV menu

			fixHVMenu(name);

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HVMenu fix). See browser.js for details.');

			return;

	      }else if(  match.call(name, /coolmenus\d?.js$/)   ){ 

			// coolmenus menu

			fixCoolmenus(name);

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Coolmenus fix). See browser.js for details.');

			return;

	      }else if(  match.call(name, /udm[_-]/)  || (  match.call(name, /(sniffer|control)\.js$/)   )    ){ 

			// UDM menu

			addEventListener.call(opera, 'BeforeScript', function(ev){

				match.call=postError.call=call;

				if( match.call(name, /udm[_-]/)  || indexOf.call(ev.element.text, 'UDM')>-1 || indexOf.call(ev.element.text, 'um.ov=um.ov.split(/opera[\\/ ]7./);um.ov=um.pi(um.ov[1].charAt(0));')>-1 ){

					fixUDM(name);

					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (UDM fix). See browser.js for details.');

				}

			}, false);

			return;

	      }else if(  indexOf.call(name, 'dynapi/api/browser.js')>-1  || indexOf.call(name, 'dynlayer.js')>-1  ){

			navRestore['appName'] = navigator.appName;

			navigator.appName = 'Microsoft Internet Explorer';

			shouldRestore = true;

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DynAPI fix). See browser.js for details.');

		}else if(  match.call(name, /stm(\d+|_menu).js$/)  ){

			fixSoThinkMenus();

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SoThink fix). See browser.js for details.');

		}else if( indexOf.call(name, 'transmenu')>-1 ){

			fixTransmenus();

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Transmenu fix). See browser.js for details.');

		}else if( indexOf.call(name, 'xaramenu')>-1 ){

			addPreprocessHandler( new RegExp('if\\(navigator.userAgent.indexOf\\(\'Opera\'\\)!=-1\\)\\s*NS4=1;', ''), 'if(navigator.userAgent.indexOf(\'Opera\')!=-1){IE5=1;NS6=0;}');

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Xaramenu fix). See browser.js for details.');

		}else if( parseFloat.call(window, version.call())<9.5 && indexOf.call(name, '/novell/webaccess/images/msglist.js')>-1){ // Bug 92454, workaround for NWA

			defineMagicFunction.call(opera, 'fixContentHeight',

				function(oF, oT){

					document.documentElement.clientHeight=window.innerHeight;

					oF.apply(oT, slice.call(arguments, 2));

			});

			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Height function fix). See browser.js for details');

		}else if( indexOf.call(name, 'awmlib')>-1 ){

				opera.addEventListener('BeforeScript', fixLiknoAllWebMenus, false);

		}else if( indexOf.call( name, 'tiny_mce' )>-1 && 'designMode' in document && !fixed){

				postError.call(opera, 'TinyMCE detected. Various fixes applied. See browser.js for details');

				addEventListener.call(opera, 'BeforeScript', function(e){

					indexOf.call=removeEventListener.call=call;

					if( indexOf.call(e.element.src, 'tiny_mce'>-1) ){

						setTinyMCEVersion(e);

						sendOperaEvent( 'bjsOnTinyMCEScript', e.element );

					}

				}, false);

				addEventListener.call(opera, 'BeforeEvent.load', function(e){

					match.call=call;

					if( match.call(e.event.target.tagName, /iframe/i) && ( match.call(e.event.target.name, /^mce_editor_\d/ ) || match.call(e.event.target.id, /^mce_editor_\d/ ))){

						setTinyMCEVersion();

						sendOperaEvent('bjsOnTinyMCEInstance', e.event.target);

					}

				}, false);

				fixed=true;

		}else if(indexOf.call(name, 'dev.virtualearth.net/mapcontrol/mapcontrol.ashx')>-1 && window.SVGDocument){

			navRestore.userAgent = navigator.userAgent;

			navigator.userAgent+='KHTML';//356736

			shouldRestore=true;

		}else if(indexOf.call(name,'s_code')>-1||indexOf.call(name,'omniture')>-1){//PATCH-59

			avoidDocumentWriteAbuse();

		}else if(indexOf.call(name,'setdomain.js')>-1){//PATCH-128

			navRestore.userAgent = navigator.userAgent;

			navigator.userAgent+=' Gecko';

			shouldRestore=true;

		}

		if( typeof window._jive_plain_quote_text!='undefined' ){ // Jive forum embeds TinyMCE, possibly outdated versions - PATCH-248

			opera.addEventListener('BeforeScript', function(e){

				indexOf.call=removeEventListener=call;

				if(indexOf.call(e.element.text, 'tinymce=')>-1){

					setTinyMCEVersion(e);

					sendOperaEvent( 'bjsOnTinyMCEScript', e.element );

					removeEventListener.call(opera, 'BeforeScript',arguments.callee,false);

				}

			}, false);

		}

		// Creating event handler to restore any changed navigator properties

		if( shouldRestore ){

			addEventListener.call(opera, 'AfterExternalScript', 

				function(ev){

					removeEventListener.call=call;

					var prop;

					for(prop in navRestore) navigator[prop]=navRestore[prop];

					removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);

				}

			, false);

		}

	}, false);
			// PATCH-230, Prevent unsolicited access to Java's deploymenttoolkit
	HTMLObjectElement.prototype.__defineGetter__('launch', function(){} );

	HTMLObjectElement.prototype.__defineGetter__('installJRE', function(){} );

	HTMLEmbedElement.prototype.__defineGetter__('launch', function(){} );

	HTMLEmbedElement.prototype.__defineGetter__('installJRE', function(){} );
			// 246299, PDF security patch
	opera.addEventListener('BeforeJavaScriptURL', function( e ){

		unescape.call=toLowerCase.call=indexOf.call=preventDefault.call=call;

		var pathname=unescape.call(self, toLowerCase.call(self.location.pathname));

		var hash=unescape.call(self, toLowerCase.call(self.location.hash));

		if( /*indexOf.call(pathname, '.pdf')>-1 &&*/ hash  &&  indexOf.call(hash, 'javascript:')>-1   ) preventDefault.call(e);

	}, false);
			// CORE-3776, Generic patch to support window.scrollX, window.scrollY
	if(typeof window.scrollX=='undefined')opera.defineMagicVariable('scrollX',function(){ return window.pageXOffset;},null);

	if(typeof window.scrollY=='undefined')opera.defineMagicVariable('scrollY',function(){ return window.pageYOffset;},null);
			// PATCH-138, Asia-region Generic Patches
	opera.addEventListener('BeforeExternalScript',function(ev){

		var name=ev.element.src; 

		if(!name){return;}

		if((name.indexOf('http://api.e-map.ne.jp/jsapi.cgi')!=-1)&&(name.indexOf('zdccommon.js')!=-1)){

			// Zenrin Datacom E-Map API, PATCH-115

			Event.prototype.__defineGetter__('layerX',function(){ return this.offsetX; });

			Event.prototype.__defineGetter__('layerY',function(){ return this.offsetY; });

			

		}else if((name.indexOf('expapi/authentication')!=-1)||(name.indexOf('rosen/authentication')!=-1)){

			// Rosenzu ASP Map Service map, PATCH-122

			opera.defineMagicFunction('_ch',function(){return true;});

		}else if((name.indexOf('expapi/suggest')!=-1)||(name.indexOf('rosen/suggest')!=-1)){

			// Rosenzu ASP Map Service suggestions, PATCH-122

			opera.defineMagicFunction('checkBrowser',function(){return true;});

		}else if(name.indexOf('http://ebook.webcatalog.jp/engine/java/7net/common/sCommonLib.js')!=-1){ 

			// Netfly TrueEBook, PATCH-125

			opera.defineMagicFunction('funcGetBrowser',function(){return 2;}); 

		}

	},false);


	if(((hostname.indexOf('expedia.com')>-1)||(hostname.indexOf('expediaweb.com')>-1))){			// CORE-26201, Expedia fix car rental list
		if (location.pathname.indexOf('/pub/agent.dll')>-1) {

			window.opera.defineMagicFunction('writeCarRow2', function (oRealFunc, oThis, str) {

				str = str.replace(/&lt;/g,'<').replace(/&gt;/g,'>');

				return result = oRealFunc.apply(oThis, arguments.slice(2));

			});

		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Expedia fix car rental list). See browser.js for details');
	} else if((hostname=='www.opera.com' || hostname=='jp.opera.com') && pathname.indexOf('/docs/browserjs/')==0){			// 0, Browser.js status and version reported on browser.js documentation page
		document.addEventListener((parseFloat(opera.version())>9?'DOMContentLoaded':'load'),function(){

			if(document.getElementById('browserjs_active')){

				document.getElementById('browserjs_active').style.display='';

				document.getElementById('browserjs_active').getElementsByTagName('span')[0].appendChild(document.createTextNode(bjsversion));

				document.getElementById('browserjs_status_message').style.display='none';

			}else if(document.getElementById('browserjs_status_message')){

				document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! '+bjsversion;

			}

		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Browser.js status and version reported on browser.js documentation page). See browser.js for details');
	} else if(hostname.indexOf( 'fileplanet.com' ) >-1 && href.indexOf('/sp_downloadmanager.aspx')>-1){			// DSK-176321, Fileplanet.com sniffing blocks Opera
		opera.defineMagicVariable('agt',function(){return "win";},null);

		addPreprocessHandler( /(\b)window\s*.\s*opera(\b)/g,'$1undefined$2');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fileplanet.com sniffing blocks Opera). See browser.js for details');
	} else if(hostname.indexOf( 'nmviewogc.cr.usgs.gov' )!=-1){			// 233838, National Map Viewer on USGS relies on Netscape detection for functionality
		navigator.appName='Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (National Map Viewer on USGS relies on Netscape detection for functionality). See browser.js for details');
	} else if(hostname.indexOf("cang.baidu.com") != -1 ){			// OTW-4761, cang.baidu.com for Baidu SouCang can't display saved items
		window.opera.defineMagicFunction(

			"top",

			function(originalFunction, oThis, oParam1, oParam2) {

				return originalFunction();

			}

		);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (cang.baidu.com for Baidu SouCang can\'t display saved items). See browser.js for details');
	} else if(hostname.indexOf("tianya.cn") > -1){			// CORE-25405, layout issues
		addCssToDocument('.wmfcCSS{ table-layout:auto !important;} .wrapper{height:auto !important}');

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (layout issues). See browser.js for details');
	} else if(hostname.indexOf('.aaa.com')>-1){			// PATCH-38, Sniffing on aaa.com prevents zip code search
		opera.defineMagicVariable('NS6', function(){return true;}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sniffing on aaa.com prevents zip code search). See browser.js for details');
	} else if(hostname.indexOf('.aol.') >-1){			// 0, AOL
		/* AOL */
	
	
		if(hostname.indexOf('.aol.jp')>-1){			// PATCH-45, AOL.jp sniffing prevents styling
			document.addEventListener('DOMContentLoaded', function(){document.documentElement.className='SAF';}, false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL.jp sniffing prevents styling). See browser.js for details');
		}
		if(hostname.indexOf('aol.com') >-1){			// 188197, Making sure AOL pages are not overwritten by ad script
			avoidDocumentWriteAbuse();
					// 262693, AOL browser sniffing causes missing styling
			document.addEventListener('DOMContentLoaded', function(){document.documentElement.className='SAF';}, false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Making sure AOL pages are not overwritten by ad script\nAOL browser sniffing causes missing styling). See browser.js for details');
		}
		if(hostname.indexOf('news.aol.com')>-1){			// PATCH-15, AOL popup slideshow does not load because of script execution timing issue
			opera.defineMagicVariable('isPopUpParent', function(){return !/pgPopUp/.test(window.name);}, null);

			opera.defineMagicVariable('swfobject', null, function(obj){

				var orig_embedSWF=obj.embedSWF;

				obj.embedSWF=function(swfUrlStr, replaceElemIdStr, widthStr, heightStr, swfVersionStr, xiSwfUrlStr, flashvarsObj, parObj, attObj){

					if( !document.getElementById(replaceElemIdStr) ){

						(function(T,A){setTimeout( function(){A.callee.apply(T,A);}, 100 );})(this,arguments); // try again later...

				}

					return orig_embedSWF.apply(this,arguments);

				}

				return obj;

			});

			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL popup slideshow does not load because of script execution timing issue). See browser.js for details');
		}
		if(hostname.indexOf('webmail.aol.com') >-1){			// CORE-17733, Send button does not appear
			addCssToDocument('.containerNode .wsButton.rightBorder:first-child, .containerNode .wsButton.rightBorder:first-child .content { min-height: 100px; min-width: 5em }');
					// CORE-18580, Converting RGB to Hex confuses "high contrast mode" detection
			if(CSSStyleDeclaration&&CSSStyleDeclaration.prototype&&CSSStyleDeclaration.prototype.__defineGetter__){	

				var CSSStyleDeclaration_color=getComputedStyle(document.documentElement, '').__lookupGetter__('color');

				CSSStyleDeclaration.prototype.__defineGetter__('color', function(){

					var color=CSSStyleDeclaration_color.apply(this,arguments);

					return (color=='#1f293b') ? 'rgb(31,41,59)'  : color;

				});

			}
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Send button does not appear\nConverting RGB to Hex confuses "high contrast mode" detection). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL). See browser.js for details');
	} else if(hostname.indexOf('.dell.')!=-1&&hostname.indexOf('support.')!=-1){			// 286618,  browser sniffing on support.dell.com
		opera.defineMagicVariable( 'ig_shared', null, function(o){ o.IsNetscape6=true; return o; } );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( browser sniffing on support.dell.com). See browser.js for details');
	} else if(hostname.indexOf('.dfdsseaways.')>-1){			// PATCH-46, DFDS calendar is 1900 years in the future
		Date.prototype.getYear = function(){ return this.getFullYear()-1900; }
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DFDS calendar is 1900 years in the future). See browser.js for details');
	} else if(hostname.indexOf('.ems.com.cn')>-1){			// PATCH-24, Menus on ems.com.cn disappear too quickly
		solveEventOrderBugs();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Menus on ems.com.cn disappear too quickly). See browser.js for details');
	} else if(hostname.indexOf('.google.')>-1&&href.indexOf('/reader/view')>-1){			// PATCH-32, Google Reader wraps long feed titles
		addCssToDocument(".scroll-tree .name { display: block;}");
				// PATCH-61, V shortcut in Google reader opens blank page
		(function(wo){ 

		  window.open = function(){ 

		    if ( arguments[0] == "about:blank" ) { 

		      arguments[0] = ''; 

		    } 

		    return wo.apply(window, arguments); 

		  } 

		})(window.open);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google Reader wraps long feed titles\nV shortcut in Google reader opens blank page). See browser.js for details');
	} else if(hostname.indexOf('.ibm.com')>-1){			// 206984, IBM driver download has HTML comments inside SCRIPT tag, breaks parsing
		removeClosingHTMLComments();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (IBM driver download has HTML comments inside SCRIPT tag, breaks parsing). See browser.js for details');
	} else if(hostname.indexOf('.picsearch.com')>-1){			// PATCH-171, Avoid bug that breaks frameset on picsearch.com
		avoidMagicBodyCreation();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid bug that breaks frameset on picsearch.com). See browser.js for details');
	} else if(hostname.indexOf('.t-online.de')>-1){			// 225374,  video problems on T-online.de
		if(hostname.indexOf('onunterhaltung')>-1){

					//Fix browser detection

					opera.defineMagicFunction( 'allResultsOK', function(){return true;} );

					// Fix plugin detection

					opera.defineMagicVariable( 'fHasWMP64', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )

					opera.defineMagicVariable( 'fHasWMP7', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )

					opera.defineMagicVariable( 'WMPVer', function(){ try{return fHasWMP64?'6.4':'unknown'}catch(e){return '6.4'} }, null )

			opera.addEventListener( 'BeforeScript',function(e){

				replace.call=call;

				e.element.text=replace.call(e.element.text,  'playerframe.Player.url=url;', 'playerframe.Player.url=url;nplayerframe.Player.Open(url);' );

			},false );

					// use TYPE as well as CLASSID on OBJECT tags in markup

					var objId='Player';

					var objref=null;

					document.addEventListener('DOMContentLoaded', function(e){ 

						if( ! (objref=document.getElementById(objId) ) ) return;

						if(objref.getAttribute('classid')=="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6")objref.type='application/x-mplayer2';

					}, false);

					// Remove UI that depends on ActiveX scripting. Built-in WMP UI will do..

					document.addEventListener('DOMContentLoaded', function(e){ 

						var pb=document.getElementById('playBtn');

						var wmp=document.getElementById('playerframe');

						if( pb&&wmp ){

							pb.parentNode.style.visibility='hidden';	wmp.style.visibility='visible';

							try{ document.images.tonaus.height=0;document.images.tonaus.width=0;}catch(e){}

						}

					}, false);

		}
				// 231082,  video problems on T-online.de, VOD section
				if( hostname.indexOf('vod')>-1 ){ // 231082

					navigator.userAgent+=' Firefox';

				}

		
				// 231082,  video problems on T-online.de, WMP license installation
		if(href.indexOf('__license=delivered')>-1){

			location.replace( location.href.replace( /__license=delivered/, '?license=delivered' ) );

		}

		
				// 226414,  video problems on T-online.de, no window.external detection
		window.external=window.external||{};

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( video problems on T-online.de\n video problems on T-online.de, VOD section\n video problems on T-on...). See browser.js for details');
	} else if(hostname.indexOf('.ulead.') >-1){			// DSK-130832, Ulead.com old Milonic menu
		 fixMilonicMenu('mmenu.js');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Ulead.com old Milonic menu). See browser.js for details');
	} else if(hostname.indexOf('.wimbledon.org')>-1){			// PATCH-171, Avoid bug that breaks frameset on wimbledon.org
		avoidMagicBodyCreation();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid bug that breaks frameset on wimbledon.org). See browser.js for details');
	} else if(hostname.indexOf('.yahoo.')>-1){			// 0, Yahoo!
		/* Yahoo! */
	
	
		if(hostname.indexOf("rec.feeds.yahoo.")==0){			// 194334, Make "add feeds" dialog work in Y!Mail beta
			navigator.product='Gecko';

			addCssToDocument('#FeedTabs div.panel{overflow:auto!important}body{overflow:hidden!important}');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make "add feeds" dialog work in Y!Mail beta). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/dc/system_requirements?browser=blocked' )>-1||href.indexOf( '/dc/system_requirements?browser=unsupported' )>-1)){			// 194334, Y!Mail work around browser blocking
			location.href='/dc/launch?sysreq=ignore';

			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail work around browser blocking). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/dc/')==0){			// DSK-206722, can't get past "new features" screen due to redirect
			document.addEventListener( 'DOMContentLoaded', function(){

				for( var link_count=0,element;element=document.links[ link_count ]; link_count++ ){

					if( element.getAttribute('href')=='/dc/launch?consentLW=1' )element.setAttribute('href', '/dc/launch?consentLW=1&sysreq=ignore');

				}

			} ,false );

			
					// DSK-213160, Y!Mail button attribute "action" is a URL in WF2
			HTMLButtonElement.prototype.__defineSetter__('action', function(o){this._action=o});

			HTMLButtonElement.prototype.__defineGetter__('action', function(){return this._action});
					// DSK-216143, Remember to create documentElement properties on XML nodes
			addPreprocessHandler( 'oEl.XMLDocument=oNewDOM;', 'oEl.XMLDocument=oNewDOM;oEl.documentElement=oNewDOM.documentElement;' );

			
					// PATCH-198, Y!Mail chat enter fix
			opera.addEventListener('BeforeEventListener.load', function(e){

				if(e.event.target.tagName==='IFRAME' && /imcBody/.test(e.event.target.className)){

					e.event.target.contentWindow.focus=function(){}// why this works I don't know either..

					var execCom=e.event.target.contentDocument.execCommand;

					e.event.target.contentDocument.execCommand=function(command){

						if(command=='ForeColor')return;

						execCom.apply(this,arguments);

					};

			

					e.event.target.contentDocument.__defineGetter__('designMode', function(){

						return this.body.contentEditable=='true' ? 'on' : 'off';

					});

					e.event.target.contentDocument.__defineSetter__('designMode', function(v){

						this.body.contentEditable = (v == 'on');

					});

				}

			},false);
					// CORE-17539, Y!Mail spell check fix
			document.__defineGetter__('designMode', function() {

				return this.documentElement.contentEditable ? 'on' : 'off';

			});

			

			document.__defineSetter__('designMode', function(v) {

				this.documentElement.contentEditable = (v == 'on');

			});
					// CORE-17538, Y!Mail avoid text selection on drag-and-drop
			window.addEventListener('mousedown', function(evt) {

				var target = evt.target;

				var cursor = getComputedStyle(target, null).cursor;

				if (/move/i.test(cursor) || /size/i.test(cursor)) {

					evt.preventDefault();

				} else if (!('value' in target) /* don't preventDefault for <input>, etc */) {

					for (var node = target; node; node = node.parentNode) {

						if (node.hasAttribute && node.hasAttribute('tabindex')) {

							evt.preventDefault();

							break;

						}

					}

				}

			}, true);
					// 321384, createElement in XML document should put un-prefixed nodes in null namespace
			var docCreateElement = Document.prototype.createElement;

			if( window.XMLDocument ){

				XMLDocument.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }

			}else{

				Document.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }

			}
					// 194334, Make sure dragging does not cause visible selections
			addCssToDocument('[unselectable]::selection, [unselectable] ::selection { background-color: transparent; color: inherit }');
					// 327060, Shadow on dialogs is messed up, so fix it
			addCssToDocument('.dialogFooterCenter { font-size: 0; line-height: 0 } ');
					// PATCH-225, Can not scroll to see all messages in inbox if list is taller than 32767px
			document.addEventListener('DOMContentLoaded', function(e, img, addHeight){

				if(img=document.getElementById('sbInner_24')){

					addHeight=parseInt(img.style.height)-32767;

					while(addHeight>0){

						if(addHeight>32767){

							var thisHeight=32767;

						}else{

							thisHeight=addHeight;

						}

						var tmp=img.cloneNode(true);

						img.parentNode.appendChild(document.createElement('br'));

						img.parentNode.appendChild(tmp).style.height=thisHeight+'px';

						addHeight-=thisHeight;

					}

				}

			}, false);

			
					// 194334, Y!Mail making sure addRule doesn't throw x-doc security errors
			if(!CSSStyleSheet.prototype.addRule )

				CSSStyleSheet.prototype.addRule = function( selector, css ){

					try{

						this.insertRule(selector+" { "+css+" }",this.cssRules.length);

					}catch(ex){}

				};

			
					// 194334, Y!Mail To: / CC: autocomplete fails because boundingLeft is not supported
			HTMLInputElement.prototype.createTextRange=HTMLTextAreaElement.prototype.createTextRange=null;

			

			
					// 194334, Y!Mail faking oncontextmenu support
			fakeOncontextmenu(false, 500)
					// PATCH-65, Handling Y!Mail's XMLDocument usage
			HTMLElement.prototype.__defineGetter__('XMLDocument', function(){

				if(this._XMLDocument)return this._XMLDocument;

			});

			HTMLElement.prototype.__defineSetter__('XMLDocument', function(D){

				if(D && D.firstChild){

					var contents=D.firstChild.cloneNode(true);

					D=document.implementation.createDocument("", "", null);

					D.appendChild(contents);

				}

				if(D)D.loadXML=function(xml){

					var obj=(new DOMParser()).parseFromString(xml, 'text/xml');

					if(this.documentElement)this.replaceChild(obj, this.documentElement); else this.appendChild(obj);

				}

				return this._XMLDocument=D;

			});

			
					// 353880, Y!Mail reversed mouse wheel scrolling
			opera.addEventListener('BeforeEvent.mousewheel', function(e) {

				var d = e.event.wheelDelta * -1;

				e.event.__defineGetter__('wheelDelta', function() { return d });

			}, false);
					// 194334, Y!Mail remove selectSingleNode and selectNodes
			/* because Yahoo mail is better at emulating proprietary IE functions than we are.. */

			Node.prototype.selectSingleNode=undefined;

			Node.prototype.selectNodes=undefined;
					// PATCH-118, Y!Mail Send button opens attach file dialog
			addCssToDocument( '.transparent_attach_btn{ left:60px !important; width: 60px !important }' );

			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (can\'t get past "new features" screen due to redirect\nY!Mail button attribute "action" is a URL in W...). See browser.js for details');
		}
		if(hostname.indexOf('auctions.yahoo.co.jp')>-1&&pathname.indexOf('/jp/show/submit')>-1){			// PATCH-104, Yahoo! Japan Auction sell item disclaimer buttons not shown
			opera.defineMagicFunction('auction_tos',function(oRealFunc,oThis){

				var value=oRealFunc.apply(oThis, arguments.slice(2));

				div=document.getElementById('auc_insert_form');

				if(div){

					div.insertBefore(document.createElement('form'),div.firstChild);

					div.firstChild.appendChild(document.getElementById('auc_insertion_ok'));

					div.firstChild.appendChild(document.getElementById('auc_insertion_cancel'));

				}

				return value;

			},false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo! Japan Auction sell item disclaimer buttons not shown). See browser.js for details');
		}
		if(hostname.indexOf('mail')==-1){			// 101146, Yahoo ISP portal blocks Opera users
			addPreprocessHandler( /d\.location\.href = ".*?\/browser_upgrade\.html";/g, '');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo ISP portal blocks Opera users). See browser.js for details');
		}
		if(hostname.indexOf('mail.yahoo')>-1){			// DSK-263826, Keyboard navigation of autocomplete menu fails
			opera.addEventListener('BeforeEvent.keypress', function(e){

				if( e.event.keyCode>36 && e.event.keyCode<41 ){

					e.event.charCode=0;

				}

			}, false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Keyboard navigation of autocomplete menu fails). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo!). See browser.js for details');
	} else if(hostname.indexOf('adf.ly')==0){			// PATCH-171, Avoid bug that breaks frameset on adf.ly
		avoidMagicBodyCreation();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid bug that breaks frameset on adf.ly). See browser.js for details');
	} else if(hostname.indexOf('ajaxian.com')==0){			// PATCH-246, Work around layout freeze
		addCssToDocument('.commentbar span{float:none!important}');

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around layout freeze). See browser.js for details');
	} else if(hostname.indexOf('allrecipes.com')>-1){			// PATCH-196, remove byte order marks (BOMs) that should not occur in the middle of JavaScript files
		opera.addEventListener('BeforeScript', function(e){

			replace.call=indexOf.call=call;

			e.element.text=replace.call(e.element.text, /\u00ef\u00bb\u00bf/g, '' );

			/*if(e.element.src&&indexOf.call(e.element.src, 's_code.js')>-1){

				e.element.text=e.element.text.replace( /Opera/g, '0pera' );

			}*/

		}, false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (remove byte order marks (BOMs) that should not occur in the middle of JavaScript files). See browser.js for details');
	} else if(hostname.indexOf('amazon.com.cn')>-1){			// PATCH-25, Menus on amazon.com.cn disappear too quickly
		solveEventOrderBugs();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Menus on amazon.com.cn disappear too quickly). See browser.js for details');
	} else if(hostname.indexOf('ameba.jp')!=-1){			// 331093, Enable blog post editor on ameba.jp
		navigator.product='Gecko';

		navigator.userAgent=navigator.userAgent.replace('Opera', '0pera (spoofing as Firefox)');
				// 331093, Work around Opera bug where second BR tag overwrites newly inserted IMG
		addPreprocessHandler(/editor\.insertNodeAtSelection\(link\);\s*editor\.insertNodeAtSelection\(document\.createElement\('br'\)\);/, 'editor.insertNodeAtSelection(link);');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable blog post editor on ameba.jp\nWork around Opera bug where second BR tag overwrites newly inse...). See browser.js for details');
	} else if(hostname.indexOf('asahi.com')>-1){			// PATCH-185, Asahi.com never stops loading
		var docFragment=document.createDocumentFragment();

		var loadingComplete=false;

		

		opera.addEventListener('BeforeScript',function(e) {

			if ((!loadingComplete)&&(e.element.text.indexOf('contentsLoader.load(') > -1)) {

				docFragment.appendChild(e.element.cloneNode(true));

				e.preventDefault();

			}

		},false);

		

		window.addEventListener('DOMContentLoaded',function(e) {

			loadingComplete = true;

			document.body.appendChild(docFragment);

		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Asahi.com never stops loading). See browser.js for details');
	} else if(hostname.indexOf('athome.co.jp') > -1){			// PATCH-147, athome.co.jp Hide warning messages because of Browser UA
		opera.defineMagicFunction('checkTargetBrowser',function(){});

		opera.defineMagicFunction('checkTargetCookie',function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (athome.co.jp Hide warning messages because of Browser UA). See browser.js for details');
	} else if(hostname.indexOf('att.com')!=-1){			// PATCH-36, ATT / Bellsouth browser sniffing
		opera.defineMagicVariable( 'isDHTML', function(){return true;}, null );

		opera.defineMagicFunction('checkBrowser', function(){});

		navigator.appName='Microsoft Internet Explorer';

		navigator.appVersion='MSIE'+navigator.appVersion;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ATT / Bellsouth browser sniffing). See browser.js for details');
	} else if(hostname.indexOf('barnesandnoble.com')>-1){			// OTW-1909, Barnes&Noble uses "required" attributes on elements that aren't required
		window.addEventListener('load', function(){var nodes=document.evaluate('//input[@required]', document.body,null,XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,null),node=null,i=0; while(node=nodes.snapshotItem(i)){ node.removeAttribute('required'); i++; }},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Barnes&Noble uses "required" attributes on elements that aren\'t required). See browser.js for details');
	} else if(hostname.indexOf('bbs.pcpop.com') > -1){			// PATCH-102, Page loads blank due to misnested forms
		addCssToDocument(' #wrapper {width: auto !important} ');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Page loads blank due to misnested forms). See browser.js for details');
	} else if(hostname.indexOf('bcbssc.com')>-1){			// PATCH-93, Blue Cross SC looks up named elements with getElementById()
		(function(gEBI) { 

		  document.getElementById = function(idOrName) { 

		    return gEBI.call(document, arguments) || document.getElementsByName(idOrName)[0] || null; 

		  }; 

		})(document.getElementById);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blue Cross SC looks up named elements with getElementById()). See browser.js for details');
	} else if(hostname.indexOf('bioware.com')>-1){			// 239590, bioware.com uses outdated HierMenus
		fixHierMenus();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (bioware.com uses outdated HierMenus). See browser.js for details');
	} else if(hostname.indexOf('blogger.com')>-1){			// DSK-152851, Blogger: browser detection prevents WYSIWYG editing
		navigator.product = 'Gecko';

		navigator.userAgent = navigator.userAgent.replace(/Opera/, 'Firefox')+' ( rv:1.9.0.3)';

		

		opera.defineMagicVariable(

			'Detect',

			function( obj ){return obj;},

			function( obj ){

				obj.OPERA = function(){return false;}

				obj.MOZILLA = function(){return true;}

				obj.IE=function(){return false;}

				obj.IE_5_5_newer=function(){return false;}

				return obj;

			}

		);

		
				// 187226, Blogger: Should distinguish AltGr and Ctrl
		opera.defineMagicFunction('isCtrlKeyPressed', function(f, t, e){ return e.ctrlKey&&!e.altKey;  });

		opera.defineMagicVariable( 'IE_KEYSET', function(){ return true; },null );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blogger: browser detection prevents WYSIWYG editing\nBlogger: Should distinguish AltGr and Ctrl). See browser.js for details');
	} else if(hostname.indexOf('bookryanair.com')>-1){			// 319803, Make Opera's built-in WF2 validation ignore required attributes on bookryanair.com
		ignoreRequiredAttributes();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make Opera\'s built-in WF2 validation ignore required attributes on bookryanair.com). See browser.js for details');
	} else if(hostname.indexOf('britannica.com')>-1){			// 332948, Prevent overwriting document with stats graphic on britannica.com
		avoidDocumentWriteAbuse();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent overwriting document with stats graphic on britannica.com). See browser.js for details');
	} else if(hostname.indexOf('britishairways.')!=-1){			// 206810, Prevent britishairways.com from reloading the page on resize
		opera.defineMagicFunction('resizeHandler', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent britishairways.com from reloading the page on resize). See browser.js for details');
	} else if(hostname.indexOf('cajamadrid.es')!=-1){			// 346825, Caja Madrid hides login form by CSS mistake
		addCssToDocument('body:last-child .clearfix {content:normal!important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Caja Madrid hides login form by CSS mistake). See browser.js for details');
	} else if(hostname.indexOf('capitalone.com')>-1&&location.protocol=='https:'){			// 86032, CapitalOne login fails - cross-domain access on https disallows setting location
		document.domain='capitalone.com';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (CapitalOne login fails - cross-domain access on https disallows setting location). See browser.js for details');
	} else if(hostname.indexOf('cdec-sic.cl')!=-1){			// 365516, Old HierMenus on cdec-sic.cl
		fixHierMenus();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Old HierMenus on cdec-sic.cl). See browser.js for details');
	} else if(hostname.indexOf('cdon.')>-1){			// PATCH-116, Shopping cart not displayed
		addCssToDocument('ul#article-list li { position: inherit !important; }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Shopping cart not displayed). See browser.js for details');
	} else if(hostname.indexOf('chaseonline.chase.com')!=-1){			// 243036, chase.com field refocus from onkeypress-problem
		opera.defineMagicFunction('handleTabs', function(oT, oF, name){

			var el=document.getElementById(name);

			if(el && el.value.length+1>=el.maxLength && !(event.keyCode==8||event.keyCode==46)){

				setTimeout( function(){ jumpToNext(el); }, 100);

			}

			function jumpToNext(el){

				var i=0;

				if(el.form){while(el!=el.form[i])i++;}else{ return;}

				if(el.form[i+1])el.form[i+1].focus();

			}

		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (chase.com field refocus from onkeypress-problem). See browser.js for details');
	} else if(hostname.indexOf('china-pub.com')>-1){			// CORE-21773, Work around window.event getter bug
		opera.defineMagicFunction('src', function( func,realThis, ev ){

			try{

				var returnValue=func.apply(realThis, arguments.slice(2));

			}catch(e){

				if( ev && ev.target && returnValue==undefined )return ev.target;

			}

			return returnValue;

		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around window.event getter bug). See browser.js for details');
	} else if(hostname.indexOf('cs.kddi.com')>-1){			// OTW-4917, Prevent KDDI site's "anti-multiple-tabs" script from closing window randomly
		window.close=function(){};
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent KDDI site\'s "anti-multiple-tabs" script from closing window randomly). See browser.js for details');
	} else if(hostname.indexOf('danawa.com')!=-1 && href.indexOf('danawa.com/product/item.html')!=-1){			// PATCH-14, Iframe content height is too small and not expanded on danawa.com
		HTMLBodyElement.prototype.__defineGetter__('offsetHeight', function(){

			return  (this.scrollHeight);

		});

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Iframe content height is too small and not expanded on danawa.com). See browser.js for details');
	} else if(hostname.indexOf('deviantart.com')>-1){			// 282065,  deviantart.com prevents mousedown on file inputs, making it impossible to select files
		opera.addEventListener('BeforeEventListener.mousedown', function(e){

		func_toString.call=preventDefault.call=call;

				if( func_toString.call(e.listener)=='function(){return false}' && e.event.target.tagName=='INPUT' ){

					preventDefault.call(e);

				}

			}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( deviantart.com prevents mousedown on file inputs, making it impossible to select files). See browser.js for details');
	} else if(hostname.indexOf('digg.com')!=-1){			// DSK-246430, script scheduling trouble on digg.com
		Element.prototype.appendChild=(function(ac){

			return function(newChild){

				var parent=this;

				var addIt=function(){return ac.call(parent, newChild); }

				if(newChild.tagName=='SCRIPT'){

					setTimeout( addIt, 1 );

					return newChild;

				}else{

					return addIt();

				}

			}

		})(Element.prototype.appendChild);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (script scheduling trouble on digg.com). See browser.js for details');
	} else if(hostname.indexOf('ebay')>-1){			// 0, eBay
		/* eBay issues */
	
	
		if(hostname.indexOf('.ebay.')>-1){			// PATCH-133, ebay.fr hangs, Opera doesn't support option node passed to SELECT.remove()
			HTMLSelectElement.prototype.remove=function(child){

				if ( typeof child === 'number' && this.options[child] ){

					child=this.options[child];

				}else if( ! ( typeof child==='object' && child.parentNode === this ) ){ // don't throw for unexpected values, just return

					return;

				}

				Element.prototype.removeChild.call( this, child );

			};
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ebay.fr hangs, Opera doesn\'t support option node passed to SELECT.remove()). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (eBay). See browser.js for details');
	} else if(hostname.indexOf('ent.sina.com.cn')>-1){			// PATCH-62, Wrapping content in NewStars section
		addCssToDocument('.NewStars .NS_right{float:left}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Wrapping content in NewStars section). See browser.js for details');
	} else if(hostname.indexOf('enter.nifmail.jp') > -1){			// OTW-4878, Nifmail web mail bypass browser blocking
		opera.defineMagicFunction('checkBrowser',function(){

			return 1;

		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Nifmail web mail bypass browser blocking). See browser.js for details');
	} else if(hostname.indexOf('etour.co.jp') > -1){			// PATCH-152, etour.co.jp fix non-disappearing overlapping image
		navigator.appName='Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (etour.co.jp fix non-disappearing overlapping image). See browser.js for details');
	} else if(hostname.indexOf('fedex.com')!=-1){			// 363564, FedEx.com mangles tables by turning TDs into block elements
		document.addEventListener('DOMContentLoaded', function(){ for(var els=document.getElementsByTagName('td'),el,i=0;el=els[i];i++)if(el.style.display=='block')el.style.display='';}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (FedEx.com mangles tables by turning TDs into block elements). See browser.js for details');
	} else if(hostname.indexOf('forums.xbox.com')>-1){			// PATCH-193, No scrollbars on XBox forum
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on XBox forum). See browser.js for details');
	} else if(hostname.indexOf('fotki.com')>-1){			// PATCH-216, No scrollbars on some fotki.com pages
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on some fotki.com pages). See browser.js for details');
	} else if(hostname.indexOf('fujifilm.ch')>-1){			// PATCH-220, Working around a bug that hides menu entries
		addCssToDocument('#navigation ul#primary li ul.secondary_drop_down li {display: inline !important }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Working around a bug that hides menu entries). See browser.js for details');
	} else if(hostname.indexOf('geoaccess.com')!=-1){			// 318050,  BlueCross browser sniffing prevents insurance search
		opera.defineMagicVariable('is_nav', function(){return true;}, null);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( BlueCross browser sniffing prevents insurance search). See browser.js for details');
	} else if(hostname.indexOf('github.com')>-1){			// PATCH-214, No scrollbars on github.com
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on github.com). See browser.js for details');
	} else if(hostname.indexOf('grainger.com')>-1){			// PATCH-51, ignore document.onload on grainger.com
		document.__defineSetter__('onload',function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ignore document.onload on grainger.com). See browser.js for details');
	} else if(hostname.indexOf('groups.google.') > -1 && pathname.indexOf('/browse_frm/thread/') > -1){			// CORE-10896, Opera's interpretation of 100% height isn't high enough for Google Groups
		function adjustHeight() {

		      var tmp, grcsr = (tmp = document.getElementById('grcsr')) && tmp.firstChild, threadHeader = (tmp = document.getElementById('thread_header')) && tmp.parentNode;

		      if (!grcsr || !threadHeader) return;

		      var height = parseInt(getComputedStyle(grcsr, null).getPropertyValue('height')) - parseInt(getComputedStyle(threadHeader, null).getPropertyValue('height'));

		      document.getElementById('index_splitter_pane').style.height = (height -1)+'px';

		      document.getElementById('data_splitter_pane').style.height = height+'px';

		    }

		document.addEventListener('DOMContentLoaded', adjustHeight, false);

		window.addEventListener('resize', adjustHeight, false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Opera\'s interpretation of 100% height isn\'t high enough for Google Groups). See browser.js for details');
	} else if(hostname.indexOf('ibank.isb.ru')!=-1){			// 0, browser sniffing breaks ibank.isb.ru
		navigator.__defineGetter__('family', function(){return 'gecko';})

		navigator.__defineSetter__('family', function(){})

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (browser sniffing breaks ibank.isb.ru). See browser.js for details');
	} else if(hostname.indexOf('ingdirect.com.au')>-1){			// 352969, Make Opera's built-in WF2 validation ignore required attributes on ingdirect.com.au
		ignoreRequiredAttributes();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make Opera\'s built-in WF2 validation ignore required attributes on ingdirect.com.au). See browser.js for details');
	} else if(hostname.indexOf('investordaily.com.au')>-1){			// PATCH-238, Override minmax IE helper script
		opera.defineMagicFunction('minmax_scan', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Override minmax IE helper script). See browser.js for details');
	} else if(hostname.indexOf('ironmaiden.com')>-1){			// PATCH-49, fix disappearing menu on ironmaiden.com
		solveEventOrderBugs();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (fix disappearing menu on ironmaiden.com). See browser.js for details');
	} else if(hostname.indexOf('isbank.com.tr')>-1){			// 265077,  fixing navigation menu on isbank.com.tr
		opera.addEventListener('BeforeScript', function(e){ replace.call=call; e.element.text=replace.call(e.element.text, 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);};else if', 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);}else if') },false);

		
				// 265077, fixing keypress handler on isbank.com.tr
		var ignoreKeypressCodes = {8:'',9:'',16:'',17:'',35:'',36:'',37:'',38:'',39:'', 40:'',45:'',46:''};

		opera.addEventListener('BeforeEventListener.keypress', function( e ){ preventDefault.call=call; if( e.event.keyCode in ignoreKeypressCodes) preventDefault.call(e); }, false)

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( fixing navigation menu on isbank.com.tr\nfixing keypress handler on isbank.com.tr). See browser.js for details');
	} else if(hostname.indexOf('kasyouen.com')>-1){			// PATCH-238, Override minmax IE helper script
		opera.defineMagicFunction('minmax_scan', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Override minmax IE helper script). See browser.js for details');
	} else if(hostname.indexOf('kr.msn.com')!=-1){			// 349584, head layout broken on kr.msn.com
		addCssToDocument('li:after, ul:after{display:none!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (head layout broken on kr.msn.com). See browser.js for details');
	} else if(hostname.indexOf('livejournal.com')>-1){			// PATCH-216, No scrollbars on some livejournal pages with many entries
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on some livejournal pages with many entries). See browser.js for details');
	} else if(hostname.indexOf('lovdata.no')>-1){			// PATCH-213, No scrollbars on lovdata.no
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on lovdata.no). See browser.js for details');
	} else if(hostname.indexOf('mail.google')>-1){			// PATCH-239, Avoid Flash content on mail.google.com due to crasher
		if( navigator.userAgent.indexOf('PPC Mac')>-1){

			opera.addEventListener('PluginInitialized', function(e){

				if(/application\/x-shockwave-flash/i.test(e.element.type))e.element.parentNode.removeChild(e.element);

			}, false);

		}

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid Flash content on mail.google.com due to crasher). See browser.js for details');
	} else if(hostname.indexOf('mail.google.')>-1){			// 244011, GMail deletes messages on End key presses
		opera.addEventListener( 'BeforeEventListener.keypress', function(e){

			preventDefault.call=call;

			if(e.event.keyCode==35&&!e.event.shiftKey){

				preventDefault.call(e);

			}

		}, false );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (GMail deletes messages on End key presses). See browser.js for details');
	} else if(hostname.indexOf('mail.live.com')!=-1){			// CORE-17444, Fix drag and drop in Hotmail
		function fixButton(e) {

			if (e.button == 1) {

				e.__defineGetter__('button', function() { return 0 });

			}

		};

		window.addEventListener('mousedown', fixButton, true);

		window.addEventListener('mousemove', fixButton, true);

		window.addEventListener('mouseup', fixButton, true);

		
				// CORE-17444, define document.selection.empty in Hotmail (part of drag-and-drop fix)
		if(document.selection)document.selection.empty = function() {

			var sel = getSelection();

			if (!sel.isCollapsed) {

				sel.removeAllRanges();

			}

		};
				// PATCH-192, Closing already closed documents from timeout can hang ES execution
		opera.defineMagicVariable('_dapUtils', function(obj){ obj.is_ff_closeIfrm=false; return obj; }, null);
				// CORE-17447, Mispositioned sprites due to missing CSS
		addCssToDocument('.c_is { display: inline-block }');
				// CORE-17445, Detecting style.filter causes missing opacity effects
		CSSStyleDeclaration.prototype.__defineGetter__('filter', function() {

			return undefined;

		});
				// CORE-17446, Borders on folders remain after dragging things past them
		var styleDec = (document.documentElement) ? document.documentElement.style : null;

		if(styleDec){

			var getBorderColor = styleDec.__lookupGetter__('borderColor');

			var setBorderColor = styleDec.__lookupSetter__('borderColor');

			CSSStyleDeclaration.prototype.__defineGetter__('borderColor', function() {

				if (parseFloat(this.borderWidth, 10)) {

					return getBorderColor.apply(this, arguments);

				}

				return '';

			});

			CSSStyleDeclaration.prototype.__defineSetter__('borderColor', setBorderColor);

		}
				// CORE-17459, Handle setting style.left/top to null
		function allowNull(styleProp) {

			CSSStyleDeclaration.prototype.__defineGetter__(styleProp, function() {

				return this.getPropertyValue(styleProp);

			});

			

			CSSStyleDeclaration.prototype.__defineSetter__(styleProp, function(v) {

				return this.setProperty(styleProp, v || '', '');

			});

		};

		allowNull('left');

		allowNull('top');

		
				// CORE-17497, Opera doesn't support col-resize/row-resize cursors.
		addCssToDocument('html .SplitterBarH { cursor: s-resize } html .SplitterBarV { cursor: e-resize } #masterSplitter { cursor: e-resize }');
				// CORE-17500, Identify as Opera to the client-side sniffer
		if (!/EditMessageLight/.test(location.pathname)) {

			var browser = undefined;

			window.__defineGetter__('Browser', function() {

				return browser;

			});

			window.__defineSetter__('Browser', function(v) {

				browser = v;

				if (browser) {

					delete browser.isFF;

					delete browser.isFF2;

					delete browser.isFF3;

				}

				return browser;

			});

		}

		

		// Restore Opera UA string (we mask as Firefox to get the correct code over HTTP)

		var stuff = navigator.userAgent.split('(')[1].split(')')[0].split(';');

		stuff.pop();

		navigator.userAgent = 'Opera/' + opera.version() + ' (' +

				stuff.join(';') + ') Presto/' +

				(parseFloat(opera.version()) < 10 ? '2.1' : '2.2');
				// CORE-17498, Ensure a font with bold/italic variants is default for editor on Mac
		if (/Mac OS X/.test(navigator.userAgent)) {

			addCssToDocument('html .EditArea, html .ExternalClass  { font-family: Verdana }');

		}
				// 178723, Emulating IE's cssText property on style sheets
		var getCssText = function() {

			if (!this.href)	{

				return this.ownerNode.textContent;

			} else {

				try {

					var xhr = new XMLHttpRequest();

					xhr.open('GET', this.href, false);

					xhr.send();

					return xhr.responseText;

				} catch(e) {

					return '';

				}

			}

		};

		if (window.__defineGetter__) {

			CSSStyleSheet.prototype.__defineGetter__('cssText', getCssText);

			CSSStyleSheet.prototype.__defineSetter__('cssText', function(v) {

				if (!this.href) {

					this.ownerNode.innerHTML = '';

					return this.ownerNode.appendChild(document.createTextNode(v));

				}

			});

		} else {

			window.addEventListener('load', function(){

				for( var i=0;i<document.styleSheets.length;i++ ){

					if(document.styleSheets[i])

						document.styleSheets[i].cssText = { _styleRef: document.styleSheets[i], toString:function(){

					return this._styleRef.ownerNode.textContent}

					};

				}

			},false);

		}

		
				// PATCH-37, To-button does not bring up contacts list
		window.getComputedStyle=function(){

			var result=getComputedStyle.apply(this, arguments);

			if( /ContactPicker/.test(arguments[0].id )){

				result.__defineGetter__('height', function(){return '300px'});

			}

			return result;

		}

		
				// PATCH-227, quoting, forwarding not working due to race condition between timeout and IFRAME's load event
		// cache value of <TEXTAREA style="display:none;" name="fMessageBody"> in case it gets overwritten..

		var newMailSource='';

		opera.addEventListener('AfterScript', function(){

			if( document.getElementsByName('fMessageBody')[0] && newMailSource==='' ){

				newMailSource=document.getElementsByName('fMessageBody')[0].value;

				opera.removeEventListener('AfterScript', arguments.callee, false);

			}

		}, false);

		
				// PATCH-107, Fixes downloading attachments in Hotmail for O10.
		HTMLAnchorElement.prototype.getAttribute= function(n){

		if( n=='aNewWin' && getAttribute.call(this, 'aIdx')!=null )return 'true';

			return getAttribute.call(this,n);

		}

		var window_open=window.open;

		window.open=function(){

			if( /ScanAttachment\.aspx/.test(arguments[0]) ){

				var url=arguments[0];

				arguments[0]='';

			}

			var w=window_open.apply(this, arguments);

			if(url){

				w.location.href='data:text/html,'+encodeURIComponent('<html><head></head><body><p style="text-align:center; margin-top: 100px">Downloading attachment...<br><a href="javascript:window.close()">Close window</a></p></body></html>');

				setTimeout(function(){w.location.href=url},1);

			}

			return w;

		}
				// PATCH-120, Fake oncontextmenu support on Hotmail
		fakeOncontextmenu(false, 300);
				// DSK-235885, Hotmail uses lookupGetter on prototypes, not instances
		var styleSetterLookupMethod = document.createElement('span').style.__lookupSetter__;

		 CSSStyleDeclaration.prototype.__lookupSetter__ = function(prop){

			return styleSetterLookupMethod.call(document.createElement('span').style, prop);

		 };
				// CORE-15945, It's usually not necessary to define properties that are already supported with getters and setters.
		var realHTMLElementDefineGetter = HTMLElement.prototype.__defineGetter__;

		HTMLElement.prototype.__defineGetter__ = function(name, func){

			if( name in {'document':''} ) return;

			realHTMLElementDefineGetter.call(this, name, func);

		}

		
				// CORE-15973, Resize function causes event loop due to mutation listener
		opera.defineMagicFunction('dap_Resize', function(){});
				// DSK-239582, redefine document.selection with live.com's compat-layer version
		document.addEventListener( 'load', function(e){

			if(e.target instanceof HTMLIFrameElement  && e.target.id=='RichTextEditor_surface'){

				try{

					var doc=e.target.contentDocument;

					var win=doc.defaultView;

					var fakeHotmailSelectionObject;

					win.HTMLDocument.prototype.__defineSetter__('selection', function(obj){

						fakeHotmailSelectionObject=obj;

					});

					doc.__defineGetter__('selection', function(){

						return fakeHotmailSelectionObject;

					});

		

				setTimeout( function(){

					doc.addEventListener( 'mouseup', fakeOnselectionchange, false );

					doc.addEventListener( 'DOMCharacterDataModified', fakeOnselectionchange, false );

					doc.addEventListener( 'keydown', fakeOnselectionchange, false );

					doc.addEventListener( 'keyup', fakeOnselectionchange, false );}, 500);

				}catch(e){}

			}

			function fakeOnselectionchange(){

				var b=doc.createEvent("Event");

				b.initEvent('selectionchange',true,false);

				doc.dispatchEvent(b);

			}

		},true); 
				// DSK-235885, Adding editor area styling that is missing due to browser sniffing
		addCssToDocument('.RTE .Container iframe{width: 100% !important; height: 100% !important}');
				// PATCH-135, Fixes removing contacts from To field by clicking small X icon
		addCssToDocument('.ContactPicker_AutoComplete img{position:static!important;}');
				// PATCH-149, Delay load event for compose IFRAME if it's not accessible yet, enables editing - but make sure we initialize mail contents even when load event is delayed
		opera.addEventListener('BeforeEventListener.load', function(e){

			var target=e.event.target;

			if(target.tagName=='IFRAME' && target.src.indexOf(location.hostname)>-1 && target.src.indexOf(location.hostname)<target.src.indexOf('/', 8)){

				var delayLoadEvent=false;

				try{

					target.contentWindow.document.body;

				}catch(e){

					delayLoadEvent=true;

				}

				if(delayLoadEvent){

					e.preventDefault();

					var interval=setInterval( function(){

						try{

							target.contentWindow.document.body;

							e.listener.call(target, e.event);

							if( typeof newMailSource !='undefined' && newMailSource!='' && document.getElementsByName('fMessageBody')[0].value.match(/^[\r\n\s]*$/) && target.contentWindow.document.body.innerText.match(/^[\r\n\s]*$/) ){

								target.contentWindow.document.body.innerHTML=newMailSource;

							}

							clearInterval(interval);

						}catch(e){}

					}, 200 );

				}

			}

		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix drag and drop in Hotmail\ndefine document.selection.empty in Hotmail (part of drag-and-drop fix)...). See browser.js for details');
	} else if(hostname.indexOf('mail.ru')>-1){			// PATCH-216, No scrollbars on some mail.ru pages with many comments
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on some mail.ru pages with many comments). See browser.js for details');
	} else if(hostname.indexOf('maps.google.')>-1){			// CORE-633, Enable click-and-hold to show context menu in map
		fakeOncontextmenu(true, 500);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable click-and-hold to show context menu in map). See browser.js for details');
	} else if(hostname.indexOf('mb.softbank.jp')!=-1){			// DSK-267630, My SoftBank login redirection fix
		if( (location.protocol.indexOf('https:') != -1) && (location.pathname.indexOf('/scripts/japanese/mysoftbank/login.jsp') != -1) ) {

			document.addEventListener('DOMContentLoaded',function() {

				var els=document.getElementsByTagName('meta');

				for (var i=0; i<els.length; i++) {

					if (els[i].getAttribute('http-equiv') == 'Refresh'){

						document.write('');

						var timestamp = new Date().getTime();

						var url = els[i].getAttribute('content').match(/.*URL=([^;]*)/)[1];

						location.href = location.protocol+'//'+location.hostname+url+((url.indexOf('?') != -1)?'&':'?')+timestamp;

					}

				}

			},false);

		}

		
				// PATCH-22, Softbank shop uses reserved variable name parent
		(function(){var the_parent;

			opera.defineMagicVariable('parent', function(){return the_parent;}, function(o){the_parent=o;});

		})();

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (My SoftBank login redirection fix\nSoftbank shop uses reserved variable name parent). See browser.js for details');
	} else if(hostname.indexOf('moneta.co.kr')!=-1){			// 219041,  moneta.co.kr relies on IE quirks for CSS positioning
		addCssToDocument('#stocking{position:relative}#stocking>div{position:absolute}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( moneta.co.kr relies on IE quirks for CSS positioning). See browser.js for details');
	} else if(hostname.indexOf('msdn.microsoft.com')!=-1){			// DSK-224171, MSDN menus are invisible, should appear
		HTMLBodyElement.prototype.__defineGetter__('scrollWidth', function(){ return this.document.documentElement.scrollWidth;});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (MSDN menus are invisible, should appear). See browser.js for details');
	} else if(hostname.indexOf('msnbc.com')>-1){			// PATCH-30, MSNBC sniffing hides Flash content
		opera.defineMagicVariable('oSniff', function(o){return o;},function(){ window['oSniff'].nn=5; });
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (MSNBC sniffing hides Flash content). See browser.js for details');
	} else if(hostname.indexOf('namooya.com')>-1){			// 241286, Namooya.com main flash does not appear
		document.attachEvent=undefined;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Namooya.com main flash does not appear). See browser.js for details');
	} else if(hostname.indexOf('nasdaq.com')>-1){			// PATCH-23, Fix Nasdaq overlapping content
		addCssToDocument('#content{clear: none !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix Nasdaq overlapping content). See browser.js for details');
	} else if(hostname.indexOf('nationalgeographic.com')>-1){			// PATCH-223, Work around layout bug that breaks navigation menu on nationalgeographic.com
		addCssToDocument('ul#navigation_tophat_primary > li > h3 > a, ul#navigation_tophat_primary > li > ul > li > a {display: inline !important; }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around layout bug that breaks navigation menu on nationalgeographic.com). See browser.js for details');
	} else if(hostname.indexOf('nbc.com')>-1){			// PATCH-236, Make NBC videos work
		navigator.userAgent += " Chrome/5.0.375.9 Safari/533.4"
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make NBC videos work). See browser.js for details');
	} else if(hostname.indexOf('ncbi.nlm.nih.gov')>-1){			// PATCH-216, No scrollbars on certain ncbi.nlm.nih.gov query pages
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on certain ncbi.nlm.nih.gov query pages). See browser.js for details');
	} else if(hostname.indexOf('news.msn.co.kr') >-1){			// 342895, news.msn.co.kr navigation bar is offset from the page
		addCssToDocument('#home{position:relative!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (news.msn.co.kr navigation bar is offset from the page). See browser.js for details');
	} else if(hostname.indexOf('news.naver.com')>-1){			// PATCH-241, Make menus visible on news.naver.com
		addCssToDocument('div.snb li div {overflow: visible !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make menus visible on news.naver.com). See browser.js for details');
	} else if(hostname.indexOf('news.qq.com')>-1){			// PATCH-112, Requires add() method on SELECT elements
		HTMLSelectElement.prototype.add=function(){this.appendChild.apply(this,arguments);};
				// PATCH-112, weather.news.qq.com expects getElementById() to find named elements
		var gEBI=document.getElementById;

		document.getElementById=function(){

			var result=gEBI.apply(this, arguments);

			if(!result)result=document.getElementsByName.apply(this,arguments)[0];

			return result;

		}
				// PATCH-112, weather.news.qq.com uses document.all for browser detection
		opera.defineMagicVariable('ie4',function(){return true;}, null);
				// OTW-4861, qq.com uses IE-style CSS filters
		fakeCSSFilters();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Requires add() method on SELECT elements\nweather.news.qq.com expects getElementById() to find named...). See browser.js for details');
	} else if(hostname.indexOf('news.sina.com.cn')>-1){			// PATCH-35, Unexpected CDATA escape breaks JS parsing
		opera.addEventListener('BeforeScript', function(e){

			var regexp=/^\s*<!--\/\/--><!\[CDATA\[\/\/><!--/;

			if( regexp.test(e.element.text) ){

				e.element.text = e.element.text.replace(regexp, '');

			}

		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Unexpected CDATA escape breaks JS parsing). See browser.js for details');
	} else if(hostname.indexOf('nrg.co.il')>-1){			// 244416,  NRG.co.il saving articles does not work
		addPreprocessHandler('document.getElementById("launcher").innerHTML="";', '');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( NRG.co.il saving articles does not work). See browser.js for details');
	} else if(hostname.indexOf('officeapps.live.com')>-1){			// PATCH-249, XML namespace parsing on officeapps.live.com
		NamedNodeMap.prototype.getNamedItem = function(nodename) {

			for (var i=0; i<this.length; i++) {

				if (this[i].name == nodename) { return this[i]; }

			}

			return null;

		}

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (XML namespace parsing on officeapps.live.com). See browser.js for details');
	} else if(hostname.indexOf('oper.ru')>-1){			// PATCH-216, No scrollbars on some oper.ru pages with many comments
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on some oper.ru pages with many comments). See browser.js for details');
	} else if(hostname.indexOf('orkut.com')>-1){			// PATCH-21, can't change orkut avatar picture
		var tmp=document.createElement('img');

		var w_getter=tmp.__lookupGetter__('width');

		var h_getter=tmp.__lookupGetter__('height');

		HTMLImageElement.prototype.__defineGetter__('height', function(){

			var h=h_getter.call(this), img;

			if(h==0){

				(img=new Image()).src=this.src;

				return h_getter.call(img);

			}

			return h;

		});

		HTMLImageElement.prototype.__defineGetter__('width', function(){

			var w=w_getter.call(this), img;

			if(w==0){

				(img=new Image()).src=this.src;

				return w_getter.call(img);

			}

			return w;

		});

		HTMLImageElement.prototype.__defineSetter__('width', tmp.__lookupSetter__('width'));

		HTMLImageElement.prototype.__defineSetter__('height', tmp.__lookupSetter__('height'));
				// CORE-19206, orkut avatar image crop does not happen because of timing issue
		(function(sTo){

			window.setTimeout=function(f,t){

				if( t==0 && !document.body )t=100;

				sTo.call( window, f, t );

			}

		})(window.setTimeout);
				// PATCH-229, Hidden form causes non-clickable button, prevents profile image selection
		addCssToDocument('form{opacity:1!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (can\'t change orkut avatar picture\norkut avatar image crop does not happen because of timing issue\n...). See browser.js for details');
	} else if(hostname.indexOf('pb.yamada-denki.jp')>-1){			// OTW-5165, Show digital pamphlet from Yamada Denki
		Element.prototype.attachEvent = null;

		window.opera = null;

		document.addEventListener('DOMContentLoaded',function(e){

			document.addEventListener('mousewheel',onMouseWheel,true);

		},false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Show digital pamphlet from Yamada Denki). See browser.js for details');
	} else if(hostname.indexOf('photobucket.com')>-1){			// PATCH-113, Photobucket menus disappear too quickly
		window.setTimeout=(function(sT){return function(f,t){if(t==0)t=100;sT.call(this,f,t)}})(window.setTimeout);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Photobucket menus disappear too quickly). See browser.js for details');
	} else if(hostname.indexOf('picasaweb.google')!=-1){			// PATCH-146, upload button disappears due to overflow statement
		addCssToDocument('.goog-button-base-pos{overflow:inherit !important}');
				// PATCH-98, Hidden links and image details due to a CSS height property
		addCssToDocument('.lhcl_hideoverflow{ height:auto!important }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (upload button disappears due to overflow statement\nHidden links and image details due to a CSS heig...). See browser.js for details');
	} else if(hostname.indexOf('play.com')>-1){			// PATCH-250, Allow play.com searching with Enter
		window.addEventListener('keypress',

			function(evt){

				if(evt.target.id=='searchstring' && evt.keyCode==13){

					evt.preventDefault();

				}

			},

		false

		);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Allow play.com searching with Enter). See browser.js for details');
	} else if(hostname.indexOf('pluginfree.com') > -1){			// PATCH-105, DNP Pluginfree Viewer fallback to Netscape version for Opera
		opera.defineMagicFunction('sort',function(rf,rt){

			var res;

			return (res=rf.apply(rt,arguments.slice(2)))?res:"nn";

		},false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DNP Pluginfree Viewer fallback to Netscape version for Opera). See browser.js for details');
	} else if(hostname.indexOf('pogo.com')>-1){			// 305697,  Java detection fails on pogo.com
		if(navigator.javaEnabled()){

			var javaVersion = java.lang.System.getProperty('java.version');

			navigator.userAgent += ' Firefox';

			javaVersion=(javaVersion+'').split( '.' ).splice(0,2).join('.');

			navigator.mimeTypes[navigator.mimeTypes.length] = {type: 'application/x-java-applet;version=' + javaVersion };

			navigator.mimeTypes.length = navigator.mimeTypes.length+1;

		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Java detection fails on pogo.com). See browser.js for details');
	} else if(hostname.indexOf('portalaz.com.br')>-1){			// PATCH-44, fix disappearing menu on portalaz.com.br
		solveEventOrderBugs();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (fix disappearing menu on portalaz.com.br). See browser.js for details');
	} else if(hostname.indexOf('rabobank.nl')!=-1){			// 277063,  Rabobank cancels t keypress
		opera.addEventListener('AfterEvent.keypress', function(e){

			preventDefault.call=call;

			if(e.event.keyCode==116 && e.eventCancelled)preventDefault.call(e);

		},false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Rabobank cancels t keypress). See browser.js for details');
	} else if(hostname.indexOf('rent.toyota.co.jp')>-1){			// PATCH-127, Set window.open's default URL to about:blank on rent.toyota.co.jp
		window.opera.defineMagicFunction('open',function(oRealFunc,oThis,strUrl,strWindowName,strWindowFeatures){

			if (!strUrl.length) arguments[2]='about:blank';

			return oRealFunc.apply(oThis,arguments.slice(2));

		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Set window.open\'s default URL to about:blank on rent.toyota.co.jp). See browser.js for details');
	} else if(hostname.indexOf('salesforce.com')>-1){			// PATCH-176, Allow upload of workspace resources
		HTMLIFrameElement.prototype.__defineSetter__('onreadystatechange', function(){});

		

		opera.addEventListener('BeforeEventListener.load', 

			function(e){

				preventDefault.call=call;

				if(e.event.target.contentDocument && e.event.target.contentDocument.body.innerHTML == ""){

					preventDefault.call(e);

				}

			},

			false

		);
				// PATCH-87, Downloading documents on salesforce.com runs into too strict anti-drive-by-install security
		(function() {

			var x = document.createElement('iframe');

			var getSRC = x.__lookupGetter__('src');

			var setSRC = x.__lookupSetter__('src');

			x = null;

			var p = HTMLIFrameElement.prototype;

			p.__defineGetter__('src', function() {

				return getSRC.apply(this, arguments);

			});

			p.__defineSetter__('src', function(v) {

				if (v.indexOf('/download/') > -1) {

					this.contentWindow.location.href = v;

				} else {

					setSRC.apply(this, arguments);

				}

			});

		})();
				// OTW-4939, Salesforce runs into HTML5's data looking for window.data
		HTMLSelectElement.prototype.__defineGetter__('data', function(){ return window.data; });

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Allow upload of workspace resources\nDownloading documents on salesforce.com runs into too strict an...). See browser.js for details');
	} else if(hostname.indexOf('seb-bank.de')>-1){			// PATCH-84, SEB bank prevents typing certain keys
		ignoreCancellationOfCertainKeyEvents('keypress', {114:'', 116:'', 117:'', 122:''});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SEB bank prevents typing certain keys). See browser.js for details');
	} else if(hostname.indexOf('sfc.jp')>-1){			// PATCH-75, noscript content shows on sfc.jp
		addCssToDocument('noscript{display:none !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (noscript content shows on sfc.jp). See browser.js for details');
	} else if(hostname.indexOf('shoptime.com.br')>-1){			// PATCH-81, Fix for not possible to type since Opera does not support charCode
		defineMagicFunction.call(opera, 'soNums',

					function(real, e, args){

						evt = event.keyCode;

						if (evt <20 || (evt >47 && evt<58) ){return true;}

		            return false;

					},

				null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix for not possible to type since Opera does not support charCode). See browser.js for details');
	} else if(hostname.indexOf('show.co.kr')!=-1){			// 348818, Pre-filled text as INPUT background not cleared on focus
		document.addEventListener('focus', function(e){if(e.target.tagName=='INPUT'){e.target.style.backgroundImage='none'; e.target.onfocus=null;}},true);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Pre-filled text as INPUT background not cleared on focus). See browser.js for details');
	} else if(hostname.indexOf('shutterfly.com')!=-1){			// CORE-16706, Array splice throws on 0-length arrays, breaks Shutterfly.com
		var realsplice = Array.prototype.splice; 

		Array.prototype.splice = function () { 

		if( this.length == 0 ) { return []; } 

		return realsplice.apply(this,arguments); 

		};
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Array splice throws on 0-length arrays, breaks Shutterfly.com). See browser.js for details');
	} else if(hostname.indexOf('siren24.com')!=-1){			// SEOUL-609, ActiveX installation page redirect on siren24.com due to sniffing limitation on redirect script
		navigator.appName = 'Netscape';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ActiveX installation page redirect on siren24.com due to sniffing limitation on redirect script). See browser.js for details');
	} else if(hostname.indexOf('social.')>-1&&hostname.indexOf('.microsoft.')>-1){			// PATCH-203, Microsoft forums editor hangs
		addPreprocessHandler(/(if\(tinymce\.relaxedDomain\)t\.iframeHTML\+='<script\s*type="text\/javascript">document\.domain\s*=\s*"'\+tinymce\.relaxedDomain\+'";<\/script>';|ed\.setupIframe\(\);)/g, '', true, function(el){return(el.src && indexOf.call(el.src, 'tiny_mce.js')>-1) });

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Microsoft forums editor hangs). See browser.js for details');
	} else if(hostname.indexOf('sogou.com')>-1){			// PATCH-72, Sogou.com uses window.MouseEvent
		window.MouseEvent=Event;
				// PATCH-69, hide SVG's style.filter property from script on map.sogou.com because it thinks we are IE
		CSSStyleDeclaration.prototype.__defineGetter__('filter', function(){});

		CSSStyleDeclaration.prototype.__defineSetter__('filter', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sogou.com uses window.MouseEvent\nhide SVG\'s style.filter property from script on map.sogou.com beca...). See browser.js for details');
	} else if(hostname.indexOf('spaces.live.com')!=-1){			// 311225, Make Range.prototype.insertNode automatically import nodes from other documents
		var rangeInsertNode = Range.prototype.insertNode;

		Range.prototype.insertNode = function(n){

			if(this.startContainer && this.startContainer.ownerDocument && n.ownerDocument != this.startContainer.ownerDocument )n=this.startContainer.ownerDocument.importNode(n, true);

			return rangeInsertNode.call(this,n);

		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make Range.prototype.insertNode automatically import nodes from other documents). See browser.js for details');
	} else if(hostname.indexOf('status.renren.com') > -1){			// PATCH-101, Allow the comments to be visible
		addCssToDocument('ul#status-list li{overflow:visible;}')
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Allow the comments to be visible). See browser.js for details');
	} else if(hostname.indexOf('stylenanda.co.kr')>-1){			// PATCH-156, Clicks blocked on stylenanda.co.kr
		opera.defineMagicFunction('click', function (oFun, oThis){ return true; } );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Clicks blocked on stylenanda.co.kr). See browser.js for details');
	} else if(hostname.indexOf('sytadin.fr')!=-1){			// 365351, Sytadin.fr IFRAME resize script detects Opera
		fixIFrameSSIscriptII('resizeIframeOnContent');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sytadin.fr IFRAME resize script detects Opera). See browser.js for details');
	} else if(hostname.indexOf('tdwaterhouse.ca')>-1&&location.protocol=='https:'){			// 147840, tdwaterhouse.ca login fails - cross-domain access on https disallows setting location
		document.domain='tdwaterhouse.ca';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (tdwaterhouse.ca login fails - cross-domain access on https disallows setting location). See browser.js for details');
	} else if(hostname.indexOf('tickets.com')!=-1){			// MGTRN-2289, Scripts are not allowed to use reserved identifier "top"
		addPreprocessHandler( /top\(\)/g, '_top()' );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Scripts are not allowed to use reserved identifier "top"). See browser.js for details');
	} else if(hostname.indexOf('tieba.baidu.com')>-1){			// DSK-275537, insert Vcode elements in advance to avoid insert element during typing
		if(pathname=="/f"){

		document.addEventListener("DOMContentLoaded", function(){

			antiAnswer.antiProcess();

		    if (PageData.is_need_verify) {

		        if (VCodePanel.isEmpty()) {

		            VCodePanel.show()

		        }

		    }

		}, false);

		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (insert Vcode elements in advance to avoid insert element during typing). See browser.js for details');
	} else if(hostname.indexOf('tiscali.it')!=-1){			// 344935, Allows some frame nesting on web.tiscali.it
		opera.defineMagicVariable('address', function(current) {

		if (window == window.top && current == window.location) {

		    return (current.search) ? current.href + '&' : current.href+'?';

		}

		return current;

		}, null);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Allows some frame nesting on web.tiscali.it). See browser.js for details');
	} else if(hostname.indexOf('tistory.com')!=-1){			// 347990, two login buttons on tistory.com
		addCssToDocument('#memberbox .btn-login {text-indent:-100px;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (two login buttons on tistory.com). See browser.js for details');
	} else if(hostname.indexOf('tokyo.jp')>-1){			// PATCH-186, tokyo.jp enable maps
		if (location.pathname.indexOf('citymap')>-1) {

			window.opera.defineMagicFunction('chkBrowser',function(){

				return true;

			},false);

		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (tokyo.jp enable maps). See browser.js for details');
	} else if(hostname.indexOf('toshiba.co.jp')>-1){			// CORE-21628, Toshiba Digital Doors hung script
		if (pathname.indexOf('/digital/')>-1) {

			Document.prototype.getElementById=function(id){

				var res=getElementById.call(this,id);	

				if (id=='topmovie' && res) return res.parentNode;

				return res;

			}

			addCssToDocument('#topmovie { visibility: visible !important }');

		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Toshiba Digital Doors hung script). See browser.js for details');
	} else if(hostname.indexOf('towerrecords.co.jp') > -1){			// PATCH-150, towerrecords.co.jp drop-down menu hover fix
		addCssToDocument('.tableHeaderArea {z-index:auto !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (towerrecords.co.jp drop-down menu hover fix). See browser.js for details');
	} else if(hostname.indexOf('tuenti.com')!=-1){			// DSK-243723, Problems submitting messages and comments on tuenti.com
		opera.addEventListener('BeforeEventListener.load', function(e){preventDefault.call=call;

			if( e.event.target.contentWindow && e.event.target.contentWindow.location.href =='about:blank' )preventDefault.call(e);

		}, false);
				// PATCH-134, Videos not shown
		navigator.userAgent += ' [NOT firefox/3]';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Problems submitting messages and comments on tuenti.com\nVideos not shown). See browser.js for details');
	} else if(hostname.indexOf('tvguide.or.jp') > -1){			// PATCH-151, tvguide.or.jp cookie manager fix
		window.opera.defineMagicVariable('_BROWSER_IS_OPERA',function(){return false;},null);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (tvguide.or.jp cookie manager fix). See browser.js for details');
	} else if(hostname.indexOf('us.etrade.com')!=-1 ){			// OTW-3340, Working around E*Trade site's security policy violation
		opera.defineMagicFunction('GoToETURL', function(oF,oT,urlPath,thirdParty){

			try{

				oF.call(oT, urlPath, thirdParty);

			}catch(e){

				top.postMessage(etURL.parse(urlPath,thirdParty), 'http://www.etrade.wallst.com');

			}

		});

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Working around E*Trade site\'s security policy violation). See browser.js for details');
	} else if(hostname.indexOf('usairways.com')>-1){			// 0,  USAirways is not compatible with WF2 spec required attribute
		opera.addEventListener('BeforeEvent.invalid', function(e){

			/* they specify required="True" attributes on hidden form elements. This tries to check if they are hidden

			and make sure they are temporarily "un-required" if they are */

			getAttribute.call = getComputedStyle.call = removeAttribute.call = setTimeout.call = preventDefault.call = call;

			var el=e.event.target;

			if( getAttribute.call(el, 'required')=='True' && getComputedStyle.call(window, el).visibility=='hidden' ){

				removeAttribute.call(el,'required');

				setTimeout.call(window, function(){setAttribute.call=call; setAttribute.call(el,'required', 'True');},0 )

				preventDefault.call(e.event);

			}

		}, false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( USAirways is not compatible with WF2 spec required attribute). See browser.js for details');
	} else if(hostname.indexOf('usatoday.com')!=-1){			// OTW-4689, Work around browser sniffing to make videos appear
		navigator.product='Gecko';

		window.find=function(){};

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around browser sniffing to make videos appear). See browser.js for details');
	} else if(hostname.indexOf('vgtv.no')>-1 || hostname.indexOf('movenetworks.com')>-1 || hostname.indexOf('movenetworkshd.com')>-1){			// PATCH-110, Work around browser sniffing for Move media player
		opera.defineMagicVariable('QI', function(o){ o.browserIsGood=true; return o; }, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around browser sniffing for Move media player). See browser.js for details');
	} else if(hostname.indexOf('viddler.com')>-1){			// PATCH-80, Prevent re-execution of scripts on viddler.com
		if(HTMLScriptElement.prototype.__defineGetter__)HTMLScriptElement.prototype.__defineGetter__('childNodes', function(){return []});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent re-execution of scripts on viddler.com). See browser.js for details');
	} else if(hostname.indexOf('walla.co.il')!=-1){			// 327825, New mail UI on Walla requires IE-style event capture
		emulateIECapturingEvents();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (New mail UI on Walla requires IE-style event capture). See browser.js for details');
	} else if(hostname.indexOf('weather.com')>-1){			// PATCH-44, fix disappearing menu on weather.com
		solveEventOrderBugs();
				// CORE-15756, Fix mouse event order of sign in link
		document.addEventListener('DOMContentLoaded',function(){

		 document.getElementById('hbSingIn').firstChild.addEventListener('click', function(e){e.preventDefault();}, false);

		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (fix disappearing menu on weather.com\nFix mouse event order of sign in link). See browser.js for details');
	} else if(hostname.indexOf('wikimapia.org')>-1 ){			// PATCH-79, Faking oncontextmenu support on wikimapia
		fakeOncontextmenu(false, 300);

		

			
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Faking oncontextmenu support on wikimapia). See browser.js for details');
	} else if(hostname.indexOf('worldofwarcraft.com')>-1){			// OTW-2903, Mouseover popups do not appear due to document.all sniffing
		document.all=null;

		fakeOncontextmenu(true, 500);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Mouseover popups do not appear due to document.all sniffing). See browser.js for details');
	} else if(hostname.indexOf('www.etrade.wallst.com')!=-1){			// OTW-3340, Working around E*Trade site's security policy violation (second part)
		addEventListener('message', function(e){

			if(e.domain=='us.etrade.com')top.location.href=e.data;

		}, false);

		

		

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Working around E*Trade site\'s security policy violation (second part)). See browser.js for details');
	} else if(hostname.indexOf('www.google')>-1 && pathname.indexOf('/finance')==0){			// PATCH-183, Make sure stock details are shown correctly
		window.addEventListener('load', function(){try{google.finance.renderMarketData();}catch(e){}}, false);

		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make sure stock details are shown correctly). See browser.js for details');
	} else if(hostname.indexOf('www.hongen.com') >-1){			// PATCH-187, make links clickable
		addCssToDocument('#SL_ScrBox_1{display:none !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (make links clickable). See browser.js for details');
	} else if(hostname.indexOf('www.kpn.com')>-1){			// PATCH-153, kpn.com hides body by mistake
		addCssToDocument('body{display:block!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (kpn.com hides body by mistake). See browser.js for details');
	} else if(hostname.indexOf('zhangmen.baidu.com')>-1){			// PATCH-179, Enable textarea typing
		document.selection=undefined;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable textarea typing). See browser.js for details');
	} else if(hostname.indexOf('zoover.')>-1){			// PATCH-44, fix disappearing menu on zoover sites
		solveEventOrderBugs();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (fix disappearing menu on zoover sites). See browser.js for details');
	} else if(hostname=='my.tnt.com'){			// PATCH-48, force all images to load before printing TNT delivery sheet
		opera.defineMagicFunction('printPageDirect',function (func,realThis) {

			var total = document.images.length, loaded = 0, imgs = [];

			for( var i = 0; i < total; i++ ) {

				imgs[i] = new Image();

				imgs[i].onload = imgs[i].onerror = function () {

					loaded++;

					if( total == loaded ) {

						func.apply(realThis, arguments.slice(2));

					}

				};

				imgs[i].src = document.images[i].src;

			}

			setTimeout(function () {

				if( total > loaded ) {

					loaded = total;

					func.apply(realThis, arguments.slice(2));

				}

			},10000);

		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (force all images to load before printing TNT delivery sheet). See browser.js for details');
	} else if(href.indexOf('/sample_lr.html')>-1){			// PATCH-128, Sun Webmail fails to set document.domain due to browser sniffing
		navigator.userAgent+=' Gecko';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sun Webmail fails to set document.domain due to browser sniffing). See browser.js for details');
	} else if(href.indexOf('bing.com/maps/')!=-1){			// 165310, Fake oncontextmenu support
		fakeOncontextmenu(true,false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fake oncontextmenu support). See browser.js for details');
	} else if(href==='https://bugs.opera.com/wizard/'){			// PATCH-221, Include browser.js timestamp in bug reports
		document.addEventListener('DOMContentLoaded', function(){

			var frm;

			if(document.getElementById('bug') instanceof HTMLFormElement){

				frm=document.getElementById('bug');

				if(frm.auto)frm.auto.value+='\n\nBrowser JavaScript: \n'+bjsversion;

			}

		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Include browser.js timestamp in bug reports). See browser.js for details');
	} else if(location.hostname.indexOf('.legolandholidays.dk')>-1){			// PATCH-73, Fix to show relative positioned table contents
		document.addEventListener('DOMContentLoaded', function(){document.evaluate('//td[@height=900]', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.style.position='absolute';}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix to show relative positioned table contents). See browser.js for details');
	} else if(pathname.indexOf("Maconomy/MaconomyPortal") > -1){			// PATCH-6, Fix unload form submit behavior on Maconomy portals
		opera.addEventListener("BeforeEvent.unload", function(e){

				if(!(typeof doSubmitEmptyData==='function'))return;

				var original_function = doSubmitEmptyData;

				doSubmitEmptyData = function( command, parameter_1, parameter_2, parameter_3, formSetup ){

					var form = viewDocument.forms["emptyForm"], node;

					setupForm(form, formSetup);

					form.windowSerialId.value = windowSerialId;

					form.command.value        = command;

					form.parameter_1.value    = parameter_1;

					form.parameter_2.value    = parameter_2;

					form.parameter_3.value    = parameter_3;

					form.dataChanged.value    = (formSetup.dataChanged == null ? 0 : (formSetup.dataChanged ? 1 : 0));

					form.componentName.value  = "";

		

					var getstr = "";

					for (i=0; node = form.elements[i]; i++) {

						switch(node.type){

							case "hidden":

							case "text":

							case "select-one":

								getstr += escape(node.name) + "=" + escape(node.value) + "&";

								break;

							case "checkbox":

								if (node.checked) {

									getstr += escape(node.name) + "=" + escape(node.value) + "&";

								} else {

									getstr += escape(node.name) + "=&";

								}

								break;

							case "radio":

								if (node.checked) {

									getstr += escape(node.name) + "=" + escape(node.value) + "&";

								}

								break;

						}

		

					}

					getstr = getstr.replace(/&$/,""); //remove trailing &

					var xhr = new XMLHttpRequest();

					xhr.open("POST",form.action,true);

					xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");

					xhr.send(getstr);

					resetForm(form);

					doSubmitEmptyData = original_function;

			}

		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix unload form submit behavior on Maconomy portals). See browser.js for details');
	}


})(opera);

