
#!/usr/local/bin/perl

my $datadir = "../data";
my $logsize  = 200;


use strict;

use CGI::Carp qw( fatalsToBrowser );

# use Encode;
# use Encode::Guess qw/ shiftjis euc-jp 7bit-jis /;

use CGI; my $q = new CGI();


if ( $q->param("m") eq "p" && $q->param("msg") )
{
	my $bbs = U( T( $q->param("bbs") ) );
	my $nam = U( T( $q->param("nam") ) );
	my $sbj = U( T( $q->param("sbj") ) );
	my $msg = U( T( $q->param("msg") ) );
	my $fid = U( T( $q->param("fid") ) );
	my $rid = U( T( $q->param("rid") ) );
	my $ref = U( T( $q->param("ref") ) );
	my $dat = date( time() );
	
	my $errflag  = 0;
	
	my $datafile = "$datadir/$bbs.dat";
	
	
	print "Content-type:text/html\n\n";
	
	if ( $bbs =~ /\W/ || ! -e $datafile )
	{
		$errflag = 1;
		print "<ERROR>データが存在しません。</ERROR>\n";
	}
	
	if ( length( $nam ) > 20 )
	{
		$errflag = 1;
		print "<ERROR>投稿者名が長すぎます。</ERROR>\n";
	}
	
	if ( $msg =~ /&lt;ERRORTEST&gt;/ )
	{
		$errflag = 1;
		print "<ERROR>エラーメッセージテスト</ERROR>\n";
	}
	
	
	if ( ! $errflag )
	{
		open( my $fh, "+<$datafile" ); flock( $fh, 2 );
		
		seek( $fh, 0, 0 );
		
		my( $sysdata, @logdata ) = <$fh>;
		my $id = ( $logdata[0] =~ /^<>(\d+)<>/ )[0] + 1;
		
		@logdata = @logdata[ 0 .. $logsize - 2 ] if( @logdata >= $logsize );
		unshift( @logdata, "<>$id<>$fid<>$rid<>$dat<>$nam<>$sbj<>$msg<>$ref<>\n" );
		
		seek( $fh, 0, 0 );
		truncate( $fh, 0 );
		
		print $fh $sysdata;
		print $fh @logdata;
		
		close( $fh );
		
		
		
		open( my $fh, "+<$datadir/index.dat" ); flock( $fh, 2 );
		
		seek( $fh, 0, 0 );
		
		my @indexdata = <$fh>;
		my @indexnew   = ();
		
		foreach ( @indexdata )
		{
			if ( /^<>$bbs<>([^<]*)<>/o )
			{
				my $title   = $1;
				my $summary = $msg;
				
				$summary =~ s/(^|<br>)&gt;[^>]*($|<br>)/<br>/ig; $summary =~ s/<br>//ig;
				$summary = length( $summary ) > 60 ? cut_utf8( $summary, 30 ). "..." : $summary;
				
				unshift( @indexnew, "<>$bbs<>$title<>".date_index( time() )."<>$summary<>\n" );
			}
			else
			{
				   push( @indexnew, $_ );
			}
		}
		
		seek( $fh, 0, 0 );
		truncate( $fh, 0 );
		
		print $fh @indexnew;
		
		close( $fh );
		
		
		print "<OK>\n";
	}
	
	exit;
}

elsif ( $q->param("m") eq "s" )
{
	print "Content-type:text/html\n\n";
	print "<PLAINTEXT>\n";
	open( my $fh, "bbs.cgi" ); print while <$fh>; close( $fh );
	
	exit;
}


sub T
{
	my $buf = shift;
	
	$buf =~ s/</&lt;/g;
	$buf =~ s/>/&gt;/g;
	$buf =~ s/\r\n|\r|\n/<br>/g;
	
	return $buf;
}

sub U
{
	my $buf = shift; return $buf;
	# return Encode::encode( 'utf8', Encode::decode( 'shiftjis', $buf ) );
}

sub date
{
	my @date = localtime( shift );
	
	return sprintf(
		"%04d年%02d月%02d日(%s)%02d時%02d分%02d秒",
		$date[5] + 1900,
		$date[4] + 1,
		$date[3],
		qw( 日 月 火 水 木 金 土 )[ $date[6] ],
		$date[2],
		$date[1],
		$date[0],
	);
}

sub date_index
{
	my @date = localtime( shift );
	
	return sprintf(
		"%04d/%02d/%02d %02d:%02d:%02d",
		$date[5] + 1900,
		$date[4] + 1,
		$date[3],
		$date[2],
		$date[1],
		$date[0],
	);
}

sub cut_utf8
{
	my $s = shift;
	my $l = shift;
	
	return ( $s =~ /^((?:[\x00-\x09\x0B-\x0C\x0E-\x7F]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF][\x80-\xBF]){$l})/ )[0];
}

