# sNX
package Kuzuha;
use strict;

use Kuzuha::Session;
use Kuzuha::Utility qw(matchHostname);

use vars qw($VERSION);
$VERSION = 'v0.0.3';

# -w[h́uUse of uninitialized valuevx
$SIG{__WARN__} = sub { warn @_ unless $_[0] =~ /Use of uninitialized value/ };

# property index
use constant SESSION => 0;
use constant VERSION => 1;

# \z
# Kuzuha new(String dbclass, String dburl)
sub new {
  my ($class, %args) = @_;
  my $this = [
    undef,
    undef,
    undef,
  ];
  bless $this, $class;

  $this->[SESSION] = Kuzuha::Session->new($args{dbclass}, $args{dburl});
  $this->[SESSION]->setAdminpost($args{adminpost});
  $this->[VERSION] = $VERSION;
  $this->[SESSION]->setVersion($this->[VERSION]);
  return $this;
}


# KuzuhasIy[V
# void main()
sub main {
  my ($this) = @_;

  # ݒ̎擾
  my $c = $this->[SESSION]->db->getConstants;

  # tH[͂̎擾
  my $f = $this->[SESSION]->parameter->getParams;

  # zXgɂANZX֎~
  if ($c->{use_banlist} and !$this->[SESSION]->isAdmin and
   matchHostname($this->[SESSION]->parameter->options->{hostname}, $this->[SESSION]->db->getBanlist(9))
  ) {
    return $this->prtError('access_denied');
  }

  # pX[hݒ
  elsif (!$this->[SESSION]->getAdminpost) {
    require Kuzuha::App::Admin;
    return Kuzuha::App::Admin->new($this->[SESSION])->setup();
  }

  # ߋO_E[h (bbs.cgi/YYYYMMDD.html.gz)
  elsif ($this->[SESSION]->parameter->getPathInfo() =~ /\/\d+\.html\.gz$/) {
    require Kuzuha::App::Getlog;
    return Kuzuha::App::Getlog->new($this->[SESSION])->download();
  }

  # e
  elsif ($f->{m} eq 'p' and $f->{v} ne '') {
    require Kuzuha::App::BBSPost;
    my $postapp = Kuzuha::App::BBSPost->new($this->[SESSION]);
    my $posterr = $postapp->main();

    # G[
    if ($posterr == 1) {
      return;
    }
    # NAɍĕ\
    elsif ($posterr == 2) {
      require Kuzuha::App::BBS;
      my $app = Kuzuha::App::BBS->new($this->[SESSION]);
      if ($f->{f}) {
        return $app->prtFollow(1);
      }
      elsif ($f->{'write'}) {
        return $app->prtNewpost(1);
      }
      elsif ($f->{ms} eq 'tree') {
        require Kuzuha::App::Treeview;
        return Kuzuha::App::Treeview->new($this->[SESSION])->prtTreeView(1);
      }
      else {
        return $app->prtBBS(1);
      }
    }
    # Ǘ[hڍs
    elsif ($posterr == 4) {
      require Kuzuha::App::Admin;
      return Kuzuha::App::Admin->new($this->[SESSION])->main();
    }
    # ݊
    elsif (!$posterr and $f->{f}) {
      return $postapp->prtPostComplete();
    }
    elsif ($f->{ms} eq 'tree') {
      require Kuzuha::App::Treeview;
      return Kuzuha::App::Treeview->new($this->[SESSION])->prtTreeView();
    }
    else {
      require Kuzuha::App::BBS;
      return Kuzuha::App::BBS->new($this->[SESSION])->prtBBS();
    }
  }
  # CSS\
  elsif ($f->{m} eq '.css') {
    require Kuzuha::App::CSS;
    return Kuzuha::App::CSS->new($this->[SESSION])->main();
  }
  # ߋO
  elsif ($f->{m} eq 'g') {
    require Kuzuha::App::Getlog;
    return Kuzuha::App::Getlog->new($this->[SESSION])->main();
  }
  # Ǘ[h
  elsif ($f->{m} eq 'ad') {
    require Kuzuha::App::Admin;
    return Kuzuha::App::Admin->new($this->[SESSION])->main();
  }
  # ݒ
  elsif ($f->{m} eq 'c' or exists $f->{setup}) {
    require Kuzuha::App::Custom;
    return Kuzuha::App::Custom->new($this->[SESSION])->main();
  }
  # c[\
  elsif ($f->{m} eq 'tree' or $f->{ms} eq 'tree') {
    require Kuzuha::App::Treeview;
    return Kuzuha::App::Treeview->new($this->[SESSION])->main();
  }
  # L
  elsif ($f->{m} eq 'u') {
    require Kuzuha::App::Delete;
    return Kuzuha::App::Delete->new($this->[SESSION])->main();
  }
  # f
  else {
    require Kuzuha::App::BBS;
    return Kuzuha::App::BBS->new($this->[SESSION])->main();
  }
}

sub session { $_[0]->[SESSION] }
sub version { $_[0]->[VERSION] }

sub prtError {
  require Kuzuha::App::Error;
  Kuzuha::App::Error->new($_[0]->[SESSION])->endWithError($_[1]);
}

1;
