# AvP[Ṽev[gzNX
package Kuzuha::App;
use strict;

use Kuzuha::Utility qw(getCPUTimeDiff);

use Kuzuha::ErrorHandler;
@Kuzuha::App::ISA = qw(Kuzuha::ErrorHandler);

# \z
# Kuzuha::App new()
sub new {
  my ($class, $session, $bbsid) = @_;
  my $this = {
    s => $session,
    bbsid => $bbsid,
  };
  bless $this, $class;

  # ݒ
  $this->{c} = $this->{s}->db->getConstants();

  # p[^
  $this->{f} = $this->{s}->parameter->getParams();

  # ʂ̕\pf[^
  $this->{commondata} = {};
  for my $name (qw(bbstitle cgiurl infopage targetname)) {
    $this->{commondata}->{$name} = $this->{c}->{$name};
  }
  for my $name (qw(u i c query gzip reltype autolink followwin cookie linkoff hideform showimg autowrap)) {
    $this->{commondata}->{$name} = $this->options->{$name};
  }

  return $this;
}

# jiG[Ώo͂j
DESTROY { $_[0]->prtError if $_[0]->has_error }

# sIy[V
# void main()
sub main;

# shortcuts
sub c { $_[0]->{c} }
sub f { $_[0]->{f} }
sub s { $_[0]->{s} }
sub db { $_[0]->{s}->db }
sub parameter { $_[0]->{s}->parameter }
sub display { $_[0]->{s}->display }
sub options { $_[0]->{s}->parameter->options }

# HTMLwb_̕\
# void prtHeader(HashRef data)
sub prtHeader {
  my ($this, $data) = @_;
  my $disp = $this->display;
  $data->{title} = $this->{c}->{bbstitle} unless ($data->{title});
  if ($this->{c}->{use_outercss}) {
    $data->{css} = $this->{c}->{cgiurl} . '?m=.css';
  } else {
    require Kuzuha::App::CSS;
    Kuzuha::App::CSS->new($this->{s})->parseCSSData($data);
  }
  $disp->prtTemplate('header', $data);
}

# HTMLtb^̕\
# void prtFooter(HashRef data)
sub prtFooter {
  my ($this, $data) = @_;
  $data->{cputime} = getCPUTimeDiff($this->{s}->getCPUTime(), times());
  my $disp = $this->display;
  $disp->prtTemplate('footer', $data);
}

# G[\
# void prtError(String errormsg)
sub prtError {
  my ($this, $errormsg, $hidebacknavi) = @_;
  $errormsg ||= $this->errstr;
  my %data = %{$this->{commondata}};
  $data{errormsg} = $errormsg;
  $data{backnavi} = !$hidebacknavi;

  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader({title => $this->{c}->{bbstitle} . ' G['});
  $disp->prtTemplate('error', \%data);
  $this->prtFooter();
}

1;
