# Ǘ[h
package Kuzuha::App::Admin;
use strict;

use Kuzuha::Utility qw(escapeHTML);

use Kuzuha::App;
@Kuzuha::App::Admin::ISA = qw(Kuzuha::App);

@::CHECK_MODULES = qw(CGI CGI::Carp HTML::Template Jcode Carp DBI DBD::mysql IO::File FileHandle IO::Dir DirHandle);

# sIy[V
# void main()
sub main {
  my ($this) = @_;

  # ݒύX
  if ($this->{f}->{ad} eq 'c') {
    if (my @result = grep(/^cx_(\w+)/, keys %{$this->{f}})) {
      $this->modifyConstant(@result);
    }
    else {
      $this->prtEditConstants();
    }
  }
  # T[o[
  elsif ($this->{f}->{ad} eq 'i') {
    $this->prtServerInfo();
  }
  # bZ[W폜
  elsif ($this->{f}->{ad} eq 'k') {
    if ($this->{f}->{x}) {
      $this->doKillMessage();
    }
    $this->prtKillMessage();
  }
  # nhҏW
  elsif ($this->{f}->{ad} eq 'h') {
    if ($this->{f}->{edit} or $this->{f}->{new} or $this->{f}->{delete}) {
      $this->modifyHandleName();
    }
    $this->prtEditHandleName() unless $this->has_error;
  }
  # zXgҏW
  elsif ($this->{f}->{ad} eq 'b') {
    if ($this->{f}->{edit} or $this->{f}->{new} or $this->{f}->{delete}) {
      $this->modifyBanlist();
    }
    $this->prtEditBanlist() unless $this->has_error;
  }
  # NG[hҏW
  elsif ($this->{f}->{ad} eq 'ng') {
    if ($this->{f}->{edit}) {
      $this->modifyNGWord();
    }
    $this->prtEditNGWord() unless $this->has_error;
  }
  # ÍpX[hʕ\
  elsif ($this->{f}->{ad} eq 'p') {
    $this->prtSetPassword();
  }
  # ÍpX[h\
  elsif ($this->{f}->{ad} eq 'ps') {
    $this->prtPassword($this->{f}->{ps});
  }
  # Ǘj[
  else {
    $this->prtAdminMenu();
  }
}


# ݒs
# void setup()
sub setup {
  my ($this) = @_;
  if ($this->{f}->{ad} eq 'ps') {
    $this->prtPassword($this->{f}->{ps});
  }
  else {
    $this->prtSetPassword();
  }
}


# Ǘj[
# void prtAdminMenu()
sub prtAdminMenu {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  $data{use_handlename} = $this->{c}->{use_handlename};
  $data{use_banlist} = $this->{c}->{use_banlist};
  $data{use_ngword} = $this->{c}->{use_ngword};

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_menu', \%data);
  $this->prtFooter();
}


# ݒύX
# void prtEditConstants()
sub prtEditConstants {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  my $commentlist = $this->db->getConstComments();
  $data{hascomment} = 1 if $commentlist;
  my @constlist;
  for my $key (sort keys %{$this->{c}}) {
    my $value = $this->{c}->{$key};
    escapeHTML(\$value);
    my $comment = $commentlist->{$key};
    escapeHTML(\$comment);
    push @constlist, {name => $key, value => $value, comment => $comment, hascomment => $data{hascomment}};
  }
  $data{constlist} = \@constlist;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_conf', \%data);
  $this->prtFooter();
}


# ݒύX
# void modifyConstant()
sub modifyConstant {
  my ($this, $result) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  $result =~ /cx_(\w+)/ and $result = $1;
  if (exists $this->{f}->{"cv_$result"}) {
    $this->db->modifyConstant($result, $this->{f}->{"cv_$result"});
    $this->db->setConstants();
  }
  my $value = $this->{f}->{"cv_$result"};
  escapeHTML(\$value);
  $data{detail} = "$result = $value";

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_modcomp', \%data);
  $this->prtFooter();
}


# T[o[
# void prtServerInfo()
sub prtServerInfo {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  $data{osname} = $^O;
  $data{perlversion} = $^V ? join('.', unpack 'C*', $^V) : $];

  my @modlist;
  for my $modname (@::CHECK_MODULES) {
    my $version = 'Not Found.';
    eval "require $modname";
    unless ($@) {
      $version = $modname->VERSION;
    }
    push @modlist, {name => $modname, version => $version};
  }
  $data{modlist} = \@modlist;

  my @envlist;
  while (my ($key, $value) = each %ENV) {
    escapeHTML(\$value);
    push @envlist, {name => $key, value => $value};
  }
  $data{envlist} = \@envlist;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_info', \%data);
  $this->prtFooter();
}


# bZ[W폜
# void prtKillMessage()
sub prtKillMessage {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  my $messages = $this->db->getAllMessages();
  for my $message (@$messages) {
    $message->{msg} =~ s/^[\s\r\n]+//;
    $message->{msg} =~ s/<[^>]+>//g;
    my @msgsplit = split(/\r/, $message->{msg});
    $message->{msgdigest} = $msgsplit[0];
    my $index = 1;
    while ($index < $#msgsplit and length($message->{msgdigest} . $msgsplit[$index]) < 50) {
      $message->{msgdigest} .= $msgsplit[$index];
      $index++;
    }
    $message->{name} =~ s/<[^>]+>//g;
  }
  $data{killmsg} = $messages;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_killmsg', \%data);
  $this->prtFooter();
}


# bZ[W폜
# void doKillMessage()
sub doKillMessage {
  my ($this) = @_;
  my (@msgid);
  if ($this->{f}->{x} =~ /\0/) {
    @msgid = split (/\0/, $this->{f}->{x});
  }
  else {
    push @msgid, $this->{f}->{x};
  }
  $this->db->deleteMessages(\@msgid);
}


# ÍpX[hʕ\
# void prtSetPassword()
sub prtSetPassword {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{v} = $this->{f}->{v};

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_setpass', \%data);
  $this->prtFooter();
}



# ÍpX[h\
# void prtPassword()
sub prtPassword {
  my ($this, $inputpass) = @_;
  my %data = %{$this->{commondata}};
  my ($salt);

  if (!$inputpass) {
    $this->prtError('admin_passwordempty'); # pX[hݒ肳Ă܂B
    return;
  }

  my @salt = ('0'..'9', 'A'..'Z', 'a'..'z');
  1 while (length($salt .= $salt[rand(@salt)]) < 8);

  $data{cryptpass} = crypt($inputpass, $salt);
  $data{inputsize} = length($data{cryptpass}) + 10;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_pass', \%data);
  $this->prtFooter();
}



# nhꗗҏW
# void prtEditHandleName()
sub prtEditHandleName {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  my $handlelist = $this->db->getHandleNames();
  my @handlelist;
  for my $data (@$handlelist) {
    push @handlelist, {name => $data->[0], pass => $data->[1]};
  }
  $data{handlelist} = \@handlelist;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_handle', \%data);
  $this->prtFooter();
}


# nhҏW
sub modifyHandleName {
  my ($this) = @_;

  if ($this->{f}->{edit}) {
    unless ($this->{f}->{hx} and $this->{f}->{"hp_$this->{f}->{hx}"}) {
      return $this->error('admin_lackofinput');
    }
    $this->db->insertHandleName(
      escapeHTML($this->{f}->{hx}),
      escapeHTML($this->{f}->{"hp_$this->{f}->{hx}"})
    );
  }
  elsif ($this->{f}->{new}) {
    unless ($this->{f}->{new_hn} and $this->{f}->{new_hp}) {
      return $this->error('admin_lackofinput');
    }
    $this->db->insertHandleName(
      escapeHTML($this->{f}->{new_hn}),
      escapeHTML($this->{f}->{new_hp})
    );
  }
  elsif ($this->{f}->{delete}) {
    unless ($this->{f}->{hx}) {
      return $this->error('admin_lackofinput');
    }
    $this->db->deleteHandleName(escapeHTML($this->{f}->{hx}));
  }

  return 1;
}

# zXgҏW
# void prtEditBanlist()
sub prtEditBanlist {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  my $banlist = $this->db->getBanlist();
  my @banlist;
  for my $data (@$banlist) {
    my %bandata;
    $bandata{id} = $data->[0];
    $bandata{hostname} = $data->[1];
    if ($data->[2]) {
      $bandata{bt_addr} = 1;
    } else {
      $bandata{bt_host} = 1;
    }
    if ($data->[3] == 0) {
      $bandata{br_0} = 1;
    } elsif ($data->[3] == 1) {
      $bandata{br_1} = 1;
    } elsif ($data->[3] == 2) {
      $bandata{br_2} = 1;
    }
    push @banlist, \%bandata;
  }
  $data{banlist} = \@banlist;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_banlist', \%data);
  $this->prtFooter();
}


# zXgҏW
sub modifyBanlist {
  my ($this) = @_;

  if ($this->{f}->{edit}) {
    unless ($this->{f}->{bx} and $this->{f}->{"bn_$this->{f}->{bx}"}) {
      return $this->error('admin_lackofinput');
    }
    $this->db->updateBanlist(
      $this->{f}->{bx},
      $this->{f}->{"bn_$this->{f}->{bx}"},
      $this->{f}->{"bt_$this->{f}->{bx}"},
      $this->{f}->{"br_$this->{f}->{bx}"},
    );
  }
  elsif ($this->{f}->{new}) {
    unless ($this->{f}->{new_bn} and $this->{f}->{new_bt} ne '' and $this->{f}->{new_br} ne '') {
      return $this->error('admin_lackofinput');
    }
    $this->db->insertBanlist(
      $this->{f}->{new_bn},
      $this->{f}->{new_bt},
      $this->{f}->{new_br},
    );
  }
  elsif ($this->{f}->{delete}) {
    unless ($this->{f}->{bx}) {
      return $this->error('admin_lackofinput');
    }
    $this->db->deleteBanlist($this->{f}->{bx});
  }

  return 1;
}


# e֎~ҏW
# void prtEditNGWord()
sub prtEditNGWord {
  my ($this) = @_;
  my %data = %{$this->{commondata}};
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};

  my $ngword = $this->db->getNGWord();
  $data{ngword} = join "\n", @$ngword;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('admin_ngword', \%data);
  $this->prtFooter();
}


# nhҏW
sub modifyNGWord {
  my ($this) = @_;
  my $ngword = $this->{f}->{ngword};
  $ngword =~ s/^[\r\n]+//;
  $ngword =~ s/[\r\n]+$//;
  $ngword =~ s/[\r\n]{2,}/\n/gm;
  $this->db->updateNGWord($ngword);
  return 1;
}


# G[\
# void prtError(String errormsg)
sub prtError {
  my ($this, $errormsg) = @_;
  $errormsg ||= $this->errstr;

  my %data;
  $data{u} = $this->{f}->{u};
  $data{v} = $this->{f}->{v};
  $data{errormsg} = $errormsg;

  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader({title => $this->{c}->{bbstitle} . ' G['});
  $disp->prtTemplate('error_admin', \%data);
  $this->prtFooter();
}

1;
