# f̕\
package Kuzuha::App::BBS;
use strict;

use Kuzuha::Utility qw(getFixednumber genPcode convISOTimeToTimeformat escapeURL);

use Kuzuha::App;
@Kuzuha::App::BBS::ISA = qw(Kuzuha::App);


# sIy[V
# void main()
sub main {
  my ($this) = @_;

  # tH[ʕ\
  if ($this->{f}->{'m'} eq 'f') {
    $this->prtFollow();
  }
  # VKeʕ\
  elsif ($this->{f}->{'m'} eq 'p' and exists $this->{f}->{write}) {
    $this->prtNewpost();
  }
  # Xbh\
  elsif ($this->{f}->{'m'} eq 't') {
    $this->prtThread();
  }
  # eҌ\
  elsif ($this->{f}->{'m'} eq 's') {
    $this->prtNameSearch();
  }
  # LbV̕\
#  elsif ($this->{s}->db->can('loadCache') and $this->isDefault()) {
#    $this->prtCache();
#  }
  # f̕\
  else {
    $this->prtBBS();
  }
}


# f̕\
# void prtBBS(bool retry)
sub prtBBS {
  my ($this, $retry) = @_;
  my %data = %{$this->{commondata}};

  # \IuWFNg
  my $disp = $this->{s}->display;

  # bZ[W\p[^
  my $params = $this->getDispParams();
  for my $name (qw(msgdisp bindex eindex topmsgid lastindex)) {
    $data{$name} = $params->{$name};
  }

  $data{version} = $this->{s}->getVersion();

  # tH[ݒ
  if ($retry) {
    $data{dtitle} = $this->{f}->{'t'};
    $data{dmsg} = $this->{f}->{'v'};
    $data{dlink} = $this->{f}->{'l'};
  }
  $this->setFormdata(\%data);

  # bZ[W
  if ($params->{msgdisp} < 0) {
    $data{msg_normal} = 0;
    $data{msg_nonew} = 0;
    $data{msg_nomsg} = 0;
  } elsif ($params->{eindex} > 0) {
    $data{msg_normal} = 1;
    $data{msg_nonew} = 0;
    $data{msg_nomsg} = 0;
    $data{bindex} = $params->{bindex}+1;
    $data{eindex} = $params->{eindex};
  } else {
    $data{msg_normal} = 0;
    $data{msg_nonew} = 1;
    $data{msg_nomsg} = 0;
  }
  if ($params->{eindex} >= $params->{lastindex}) {
    $data{msg_nomsg} = 1;
  }

  # irQ[g{^
  if ($params->{eindex} > 0) {
    if ($params->{eindex} < $params->{lastindex}) {
      $data{nextpage} = 1;
    }
    if ($this->{c}->{'show_readnewbtn'}) {
      $data{readnew} = 1;
    }
  }

  # Ǘғe
  if ($this->{c}->{'bbsmode_adminonly'}) {
    $data{adminlogin} = 1;
  }

  # fobO
  if ($this->{c}->{debug}) {
    $data{debuginfo} .= "[params]\n";
    for my $debug (sort keys %{$this->{f}}) {
      $data{debuginfo} .= "$debug = $this->{f}->{$debug}\n";
    }
    $data{debuginfo} .= "\n[options]\n";
    for my $debug (sort keys %{$this->{s}->parameter->options}) {
      $data{debuginfo} .= "$debug = ".$this->{s}->parameter->options->{$debug}."\n";
    }
    $data{debuginfo} .= "\n[data]\n";
    for my $debug (sort keys %data) {
      next if $debug eq 'debuginfo';
      $data{debuginfo} .= "$debug = $data{$debug}\n";
    }
  }

  # 㕔̕\
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('main_upper', \%data);

  # bZ[W̕\
  my $messages = [];
  if ($params->{eindex} - $params->{bindex} > 0) {
    $messages = $this->{s}->db->getMessagesByRange($params->{bindex}, $params->{eindex}, $this->{bbsid});
  }
  if ($this->{c}->{'reltype'} and ($this->{f}->{'readnew'} or ($params->{msgdisp} == 0 and $params->{bindex} == 0))) {
    # Âɕёւ
    @$messages = reverse @$messages;
  }
  for my $message (@$messages) {
    $this->prtMessage($message);
  }

  # ̕\
  $disp->prtTemplate('main_lower', \%data);
  $this->prtFooter();

}


# bZ[W\p[^ނ̎擾
# HashRef getDispParams()
sub getDispParams {
  my ($this) = @_;

  my $db = $this->{s}->db;

  # ǃ|C^iŐVMSGIDj
  my $topmsgid = $db->getTopmsgid($this->{bbsid});

  # \
  my $msgdisp = getFixednumber($this->{f}->{'d'});
  if (!defined $msgdisp) {
    $msgdisp = $this->{c}->{'msgdisp'};
  } elsif ($msgdisp < 0) {
    $msgdisp = -1;
  } elsif ($msgdisp > $this->{c}->{'logsave'}) {
    $msgdisp = $this->{c}->{'logsave'};
  }
  if ($this->{f}->{'readzero'}) {
    $msgdisp = 0;
  }

  # Jnindex
  my $bindex = $this->{f}->{'b'} || 0;

  # y[Wȍ~̏ꍇ
  if ($bindex > 1) {
    # VeJnindex炷
    if ($topmsgid > $this->{f}->{'p'}) {
      $bindex += ($topmsgid - $this->{f}->{'p'});
    }
    # ǃ|C^͍XVȂ
    $topmsgid = $this->{f}->{'p'};
  }

  # I[index
  my $eindex = $bindex + $msgdisp;

  # ǃ[h
  if ($this->{f}->{'readnew'} or ($msgdisp == 0 and $bindex == 0)) {
    $bindex = 0;
    $eindex = $topmsgid - $this->{f}->{'p'};
  }

  # Ō̃y[W̏ꍇA؂l
  my $lastindex = $db->countMessages($this->{bbsid});
  if ($eindex > $lastindex) {
    $eindex = $lastindex;
  }

  # -1\
  if ($msgdisp < 0) {
    $bindex = 0;
    $eindex = 0;
  }

  return {
    bindex => $bindex,
    eindex => $eindex,
    lastindex => $lastindex,
    msgdisp => $msgdisp,
    topmsgid => $topmsgid,
  };
}


# tH[ݒ
# void setFormdata(HashRef data, HashRef mode);
sub setFormdata {
  my ($this, $data, $mode) = @_;

  my $options = $this->{s}->parameter->options;

  # veNgR[h
  my $pcode = genPcode($this->{s}->getTime(), substr($this->{s}->getAdminpost(), -4), $options->{hostaddr});
  $data->{pcode} = $pcode;

  if (!$mode->{mode}) {
    $mode->{mode} = '<input type="hidden" name="m" value="p" />';
  }
  $data->{formmode} = $mode->{mode};

  # etH[̔\
  if (
    ($this->{c}->{'bbsmode_adminonly'} == 1 and !$this->{s}->isAdmin)
     or
    (
      ($this->{c}->{'bbsmode_adminonly'} != 0 or $options->{'hideform'})
       and
      ($this->{f}->{'m'} ne 'f' and !$this->{f}->{'write'})
    )
  ) {
    $data->{mode_hide} = 1;
  }

  # ݒsƃNs
  if ($this->{f}->{'m'} ne 'f' and !exists($this->{f}->{'f'}) and !$this->{f}->{'write'}) {
    $data->{extraform} = 1;

    # JE^
    if (!$this->{c}->{'counter'} and !$this->{c}->{'mbrcount'}) {
      $data->{counterrow} = 0;
    } else {
      $data->{counterrow} = 1;
      if ($this->{c}->{'counter'}) {
        my $counter = $this->{s}->db->counter($this->{bbsid});
        $data->{counter} = $counter;
        $data->{showcounter} = 1;
        $data->{countdate} = $this->{c}->{countdate};
        $data->{countlevel} = $this->{c}->{countlevel};
      }
      if ($this->{c}->{'mbrcount'}) {
        my $mbrcount = $this->{s}->db->mbrcount($this->{s}->getTime(), $options->{hostaddr}, $this->{bbsid});
        $data->{mbrcount} = $mbrcount;
        $data->{showmbrcount} = 1;
        $data->{cntlimit} = $this->{c}->{cntlimit};
      }
    }

    if ($this->{c}->{'bbsmode_adminonly'} == 0) {
      $data->{formconfig} = 1;
    }
    else {
      $data->{autolink} = 1;
      $data->{hideform} = 1;
    }

    # Ns̔\
    if ($options->{'linkoff'}) {
      $data->{linkoff} = 1;
      $data->{linkrow} = 0;
    }
    else {
      $data->{linkrow} = 1;
    }

    # wvs
    if ($this->{c}->{'bbsmode_adminonly'} != 1) {
      if ($this->{c}->{allow_undo} and $options->{undo_p} and $options->{undo_k}) {
        $data->{helpundo} = 1;
      }
      $data->{helprow} = 1;
      for my $name (qw(logsave)) {
        $data->{$name} = $this->{c}->{$name};
      }
    }

    # irQ[g{^s
    if ($this->{c}->{'show_readnewbtn'}) {
      $data->{readnewbtn} = 1;
    }
    if ($options->{'hideform'} and $this->{c}->{'bbsmode_adminonly'} == 0) {
      $data->{newpostbtn} = 1;
    }
    if ($data->{readnewbtn} or $data->{newpostbtn}) {
      $data->{btnrow} = 1;
    }

  }
  else {
    $data->{extraform} = 0;
  }

}

# bZ[W̐ݒ
# void setMessage(HashRef message)
sub setMessage {
  my ($this, $message) = @_;

  my $options = $this->{s}->parameter->options;

  # ttH[}bg
  $message->{timedisp} = convISOTimeToTimeformat($message->{msgtime}, $this->{c}->{timeformat});

  # {^
  {
    # tH[e{^
    if ($this->{c}->{bbsmode_adminonly} != 1) {
      $message->{btnfollow} = "$this->{c}->{cgiurl}?m=f;s=$message->{msgid};$options->{query}";
    }

    # QƋL{^
    if ($message->{refid}) {
      $message->{btnref} = "$this->{c}->{cgiurl}?m=f;s=$message->{refid};$options->{query}";
    }

    # eҌ{^
    if ($message->{name} ne $this->{c}->{anony_name} and $this->{c}->{bbsmode_adminonly} != 1) {
      my ($sname) = $message->{name};
      $sname =~ s/<[^>]*>//g;
      $sname = escapeURL($sname);
      $message->{btnname} = "$this->{c}->{cgiurl}?m=s;s=$sname;$options->{query}";
    }

    # Xbh\{^
    if ($this->{c}->{bbsmode_adminonly} != 1) {
      $message->{btnthread} = "$this->{c}->{cgiurl}?m=t;s=$message->{threadid};$options->{query}";
    }

    # c[\{^
    if ($this->{c}->{bbsmode_adminonly} != 1) {
      $message->{btntree} = "$this->{c}->{cgiurl}?m=tree;s=$message->{threadid};$options->{query}";
    }

    # UNDO{^
    if ($this->{c}->{allow_undo} and exists($this->{s}->parameter->options->{undo_p})
     and $this->{s}->parameter->options->{undo_p} eq $message->{msgid}) {
      $message->{btnundo} = "$this->{c}->{cgiurl}?m=u;s=$message->{msgid};$options->{query}";
    }
  }
  $message->{target} = $this->{c}->{targetname};

  # pFύX
  $message->{msg} =~ tr/\n/\r/;
  $message->{msg} =~ s/(^|\r)(\&gt;[^\r]*)/$1<span class=\"q\">$2<\/span>/g;
  $message->{msg} =~ s/<\/span>\r<span class=\"q\">/\r/g;
  $message->{msg} =~ tr/\r/\n/;
}


# bZ[W̕\
# void prtMessage(HashRef message)
sub prtMessage {
  my ($this, $message) = @_;
  $this->setMessage($message);
  $this->{s}->display->prtTemplate('message', $message);
}


# tH[ʕ\
# void prtFollow([bool retry])
sub prtFollow {
  my ($this, $retry) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  if ($this->{c}->{bbsmode_adminonly} == 1
   and crypt($this->{f}->{u}, $this->{s}->getAdminpost()) ne $this->{s}->getAdminpost()) {
    return $this->error('bbs_authfailed'); # pX[hႢ܂B
  }

  # bZ[W̎擾
  my $message = $this->{s}->db->getMessageByID($this->{f}->{s});

  unless ($message) {
    return $this->error('bbs_msgnotfound'); # w肳ꂽbZ[W܂B
  }

  my $formmsg;
  if (!$retry) {
    $formmsg = $message->{msg};
    $formmsg =~ tr/\r/\n/;
    $formmsg =~ s/&gt; &gt;[^\n]+\n//g;
    $formmsg =~ s/\n/\n&gt; /g;
    $formmsg =~ s/<a href=\"[^>]+>([^<]+)<\/a>/$1/gi;
    $formmsg =~ s/\n*<a href=[^>]+><img [^>]+><\/a>//gi;
    $formmsg = "&gt; $formmsg\r";
    $formmsg =~ s/\n&gt;\s+\n/\n/g;
    $formmsg =~ s/\n&gt;\s+\n$/\n/g;
  } else {
    $formmsg = $this->{f}->{v};
  }
  $formmsg .= "\r";

  $this->setMessage($message);
  if (!$message->{threadid}) {
    $message->{threadid} = $message->{msgid};
  }
  for my $key (keys %$message) {
    $data{$key} = $message->{$key};
  }

  my $dname = $message->{name};
  $dname =~ s/<[^>]*>//g;
  $data{dtitle} = ''.$dname. $this->{c}->{fsubj};
  $data{dmsg} = $formmsg;

  $data{followid} = $message->{msgid};
  $data{msgdisp} = $this->{f}->{d};
  $data{ff} = $this->{f}->{ff};

  $this->setFormdata(\%data);

  # \
  my $disp = $this->{s}->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('follow', \%data);
  $this->prtFooter();
}

# VKeʕ\
# void prtNewpost(bool retry)
sub prtNewpost {
  my ($this, $retry) = @_;
  my %data = %{$this->{commondata}};

  if ($this->{c}->{bbsmode_adminonly} != 0
   and crypt($this->{f}->{u}, $this->{s}->getAdminpost()) ne $this->{s}->getAdminpost()) {
    return $this->error('bbs_authfailed'); # pX[hႢ܂B
  }

  $this->setFormdata(\%data);

  # \
  my $disp = $this->{s}->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('newpost', \%data);
  $this->prtFooter();
}


# Xbh\
# void prtThread()
sub prtThread {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  # bZ[W̎擾
  my $messages = $this->{s}->db->getMessagesByThreadID($this->{f}->{s});
  unless ($messages) {
    return $this->error('bbs_msgnotfound'); # w肳ꂽbZ[W܂B
  }
  for my $message (@$messages) {
    $this->setMessage($message);
  }
  $data{message} = $messages;
  $data{success} = $#{$messages} + 1;

  # \
  my $disp = $this->{s}->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('thread', \%data);
  $this->prtFooter();
}



# eҌ\
# void prtNameSearch()
sub prtNameSearch {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  # bZ[W̎擾
  my $messages = $this->{s}->db->getMessagesByName($this->{f}->{s});
  unless ($messages) {
    return $this->error('bbs_msgnotfound'); # w肳ꂽbZ[W܂B
  }
  for my $message (@$messages) {
    $this->setMessage($message);
  }
  $data{message} = $messages;
  $data{success} = $#{$messages} + 1;

  # \
  my $disp = $this->{s}->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('thread', \%data);
  $this->prtFooter();
}


sub isDefault {
  my ($this) = @_;
  my $options = $this->{s}->parameter->options;
  for my $name (qw(u i c_background c_text c_a_color c_a_visited c_subj c_qmsg c_a_active c_a_hover
  gzip reltype autolink followwin cookie linkoff hideform showimg autowrap)) {
    if ($options->{$name} ne $this->{c}->{$name}) {
      return 0;
    }
  }
  return 0;
}

sub prtCache {
  my ($this) = @_;
  require Kuzuha::App::Cache;
  Kuzuha::App::Cache->new($this->{s})->printCache();
}

1;
