# fe
package Kuzuha::App::BBSPost;
use strict;

use Kuzuha::Utility qw(matchHostname verifyPcode convTimestampToISOTime
 escapeHTML checkMBStringMatch addLink escapeURL convTimestampToTimeformat);
use Kuzuha::App::Cache;

use Kuzuha::App;
@Kuzuha::App::BBSPost::ISA = qw(Kuzuha::App);

use constant COOKIE_EXPIRES => 2592000;
use constant UNDO_EXPIRES => 86400;

# sIy[V
# void main()
sub main {
  my ($this) = @_;

  # p[^`FbN
  my $posterr = 0;
  $posterr = $this->checkPostParams();

  # ݏ
  unless ($posterr) {
    my (%message);
    $posterr = $this->getFormMessage(\%message);
    unless ($posterr) {
      $posterr = $this->doMessagePost(\%message);
    }
    # ߋOǉ
    if (!$posterr and $this->{c}->{pastlogsave}) {
      $posterr = $this->addPastLog(\%message);
    }
    # LbVXV
    if (!$posterr and $this->db->can('startSaveCache')) {
      #$this->saveCache();
    }
    # Cookieo
    if (!$posterr and $this->options->{cookie}) {
      $this->setCookies();
    }
  }
  return $posterr;
}


# ep[^`FbN
# int checkPostParams()
# ^[R[h 0: 1:𒆎~G[ 2:߂čĕ\ 3:߂ăNA 4:Ǘ[hڍs
sub checkPostParams {
  my ($this) = @_;

  if ($this->{c}->{runmode} == 1) {
    $this->error('post_frozen'); # ̌f͌ݓe@\~łB
    return 1;
  }

  # zXgɂANZX֎~
  if ($this->{c}->{use_banlist} and !$this->{s}->isAdmin) {
    if (matchHostname($this->options->{hostname}, $this->db->getBanlist(1))) {
      $this->error('post_denied'); # ̌f͌ݓeĂ܂B
      return 1;
    }
  }

  if ($this->{c}->{bbsmode_adminonly} == 1 or ($this->{c}->{bbsmode_adminonly} == 2 and !$this->{f}->{f})) {
    unless ($this->{s}->isAdmin) {
      $this->error('post_adminonly'); # fւ̓e͊Ǘ҂̂݋Ă܂B
      return 1;
    }
  }

  # e`FbN
  if ($this->{f}->{v} =~ /^[\s\r\n]+$/) {
    return 2;
  }

  # Referer`FbNiOvj
  if ($ENV{'HTTP_REFERER'} and $this->{c}->{refcheckurl}
    and index($ENV{'HTTP_REFERER'}, $this->{c}->{refcheckurl}) > 0) {
    $this->error('post_referer');# eʂ̂tqksłB
    return 1;
  }

  for my $line (split(/\r/, $this->{f}->{v})) {
    if (length($line) > $this->{c}->{maxmsgcol}) {
      $this->error('post_line_toolong'); # eě傫܂B
      return 1;
    }
  }

  if (($this->{f}->{v} =~ tr/\r/\r/) > $this->{c}->{maxmsglines} - 1) {
    $this->error('post_lines_toomany'); # ee̍s傫܂B
    return 1;
  }

  if (length($this->{f}->{v}) > $this->{c}->{maxmsgbytes}) {
    $this->error('post_size_toolarge'); # ee傫܂B
    return 1;
  }

  if (!$this->{f}->{pc} or length($this->{f}->{pc}) != 12) {
    $this->error('post_lackofdata'); # tH[f[^̈ꕔɌ܂Bx蒼ĉB
    return 1;
  }

  # veNgR[hƍ
  {
    my $timestamp = verifyPcode($this->{f}->{pc}, substr($this->{s}->getAdminpost(), -4),
     $this->options->{hostaddr});

    if (!$timestamp) {
      $this->error('post_lackofdata'); # tH[f[^̈ꕔɌ܂Bx蒼ĉB
      return 1;
    }
    if (($this->{s}->getTime() - $timestamp) < $this->{c}->{minpostsec} ) {
      $this->error('post_tryagain'); # x蒼ĉB
      return 1;
    }
    if (($this->{s}->getTime() - $timestamp) > $this->{c}->{maxpostsec} ) {
      return 2;
    }
  }

  # NG[h
  if ($this->{c}->{use_ngword}) {
    my $ngwords = $this->db->getNGWord();
    for my $ngword (@$ngwords) {
      if (
        index($this->{f}->{v}, $ngword) > -1
        or index($this->{f}->{l}, $ngword) > -1
        or index($this->{f}->{t}, $ngword) > -1
        or index($this->{f}->{u}, $ngword) > -1
        or index($this->{f}->{i}, $ngword) > -1
      ) {
        $this->error('post_ngword'); # e֎~傪܂܂Ă܂B
        return 1;
      }
    }
  }

  return 0;
}


# tH[f[^o^bZ[Wݒ
# HashRef getFormMessage()
sub getFormMessage {
  my ($this, $message) = @_;

  my $db = $this->db;

  $message->{msgtime} = convTimestampToISOTime($this->{s}->getTime());

  $message->{hostname} = $this->options->{hostname} if $this->{c}->{iprec};
  $message->{useragent} = $this->options->{useragent} if $this->{c}->{uarec};

  $message->{name} = $this->{f}->{u};
  $message->{userattr} = $this->{f}->{i};
  $message->{title} = $this->{f}->{t};
  $message->{msg} = $this->{f}->{v};
  $message->{url} = $this->{f}->{l};

  # trim and escapeHTML
  $message->{msg} =~ s/[\r\n\s]+$//;
  escapeHTML(\$message->{msg});
  for my $name ('name', 'userattr', 'title', 'url', 'hostname', 'useragent') {
    escapeHTML(\$message->{$name}, 1);
  }

  # QID
  $message->{refid} = $this->{f}->{f} if $this->{f}->{f};
  $message->{threadid} = $this->{f}->{h} if $this->{f}->{h};

  # veNgR[h
  $message->{pcode} = substr($this->{f}->{pc}, 8, 4);

  # e
  if ($message->{name} eq '') {
    $message->{name} = $this->{c}->{anony_name};
  } else {
    # Ǘl`FbN
    if ($this->{s}->isAdmin) {
      $message->{name} = "<span class=\"muh\">$this->{c}->{adminname}</span>";
      # Ǘ[hւ̈ڍs
      if ($this->{c}->{adminkey} and $message->{msg} eq $this->{c}->{adminkey}) {
        return 4;
      }
    }
    elsif ($this->{s}->getAdminpost() and $message->{name} eq $this->{s}->getAdminpost()) {
      $message->{name} = $this->{c}->{adminname} . '<span class="muh">inJ[j</span>';
    }
    elsif (checkMBStringMatch($message->{name}, $this->{c}->{adminname})) {
      $message->{name} = $this->{c}->{adminname} . '<span class="muh">ixj</span>';
    }
    # Œnh`FbN
    elsif ($this->{c}->{use_handlename} and $db->isHandleName($message->{name})) {
      $message->{name} .= '<span class="muh">ixj</span>';
    }
    # Ȉxh~@\
    elsif (index($message->{name}, '#') > -1) {
      my $cryptid = crypt(substr($message->{name}, index($message->{name}, '#')), '00');
      $cryptid =~ s/\W//g;
      $cryptid = substr($cryptid, -7);
      $message->{name} = substr($message->{name}, 0, index($message->{name}, '#'))
       . ' <span class="muh">(' . $cryptid . ')</span>';
    }
    # Œnhϊ
    elsif ($this->{c}->{use_handlename} and my $handlename = $db->getHandleNameByPass($message->{name})) {
      $message->{name} = "<span class=\"muh\">$handlename</span>";
    }
  }

  # URLN
  if ($this->{c}->{autolink}) {
    $message->{msg} = addLink($message->{msg});
  }

  # URL
  if ($message->{url}) {
    $message->{msg} .= "\r\r<a href=\"".escapeURL($message->{url})."\">$message->{url}</a>";
  }

  $message->{msg} =~ s/\r\n/\r/g;
  $message->{msg} =~ tr/\n/\r/;

  # `FbN
  if (length($message->{msg}) > $this->{c}->{maxmsgbytes}) {
    $this->error('post_size_toolarge'); # ee傫܂B
    return 1;
  }

  return 0;
}

# e
# int doMessagePost(HashRef message)
sub doMessagePost {
  my ($this, $message) = @_;
  my ($posterr, $postmessage) = $this->db->insertMessage($message);
  $this->{message} = $postmessage;
  return $posterr;
}

# ߋOo͏
# int addPastLog(HashRef message)
sub addPastLog {
  my ($this, $message) = @_;
  my $logdate;
  if ($this->{c}->{pastlogsaveformat} == 0) {
    $logdate = convTimestampToTimeformat($this->{s}->getTime(), '<year><mon><mday>');
  }
  else {
    $logdate = convTimestampToTimeformat($this->{s}->getTime(), '<year><mon>');
  }

  my $db = $this->db;
  my $posterr = $db->insertPastlog($message, $logdate);
  return $posterr;
}


# e
# void prtPostComplete()
sub prtPostComplete {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('postcomplete', \%data);
  $this->prtFooter();
}


# CookieT
sub setCookies {
  my ($this) = @_;
  my $message = $this->{message};
  $this->display->setCookie('c', {
    u => $this->options->{u},
    i => $this->options->{i},
    c => $this->options->{c},
  }, $this->{s}->getTime + COOKIE_EXPIRES);
  if ($this->{c}->{allow_undo}) {
    my $undokey = crypt ($message->{pcode}, $this->{s}->getAdminpost);
    $undokey =~ s/\W//g;
    $undokey = substr($undokey, -8);
    $this->display->setCookie('u', {
      p => $message->{msgid},
      k => $undokey,
    }, $this->{s}->getTime + UNDO_EXPIRES);
    $this->options->{undo_p} = $message->{msgid};
    $this->options->{undo_k} = $undokey;
  }
}


sub saveCache {
  my ($this) = @_;
  my $cacheapp = Kuzuha::App::Cache->new($this->{s});
  $cacheapp->saveCache();
}

1;
