# ݒ
package Kuzuha::App::Custom;
use strict;

use Kuzuha::Utility qw(threebytehex_base64);

use Kuzuha::App;
@Kuzuha::App::Custom::ISA = qw(Kuzuha::App);

# sIy[V
# void main()
sub main {
  my ($this) = @_;

  if ($this->{f}->{m} eq 'c' and exists $this->{f}->{cr}) {
    $this->clearCustoms();
  }
  elsif ($this->{f}->{m} eq 'c') {
    $this->setCustoms();
  }
  else {
    $this->prtCustoms();
  }
}


# ݒ
# void prtCustoms()
sub prtCustoms {
  my ($this) = @_;
  my (%data);

  my $options = $this->options;

  for my $name (qw(bbstitle cgiurl infopage targetname bbsmode_adminonly bbsmode_image)) {
    $data{$name} = $this->{c}->{$name};
  }
  for my $name (qw(u i c query gzip reltype autolink followwin cookie linkoff hideform showimg autowrap
  c_text c_background c_a_color c_a_visited c_a_active c_a_hover c_subj c_qmsg)) {
    $data{$name} = $options->{$name};
  }
  $data{msgdisp} = exists $this->{f}->{d} ? $this->{f}->{d} : $this->{c}->{msgdisp};

  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('custom', \%data);
  $this->prtFooter();
}


# ݒ菈
# void setCustoms()
sub setCustoms {
  my ($this) = @_;

  my $redirecturl = $this->{c}->{cgiurl};
  my @colors = qw(c_background c_text c_a_color c_a_visited c_subj c_qmsg c_a_active c_a_hover);
  my $options = $this->options;

  my $flgchgindex = -1;
  my $cindex = 0;
  for my $confname (@colors) {
    if (length($this->{f}->{$confname}) == 6 and $this->{f}->{$confname} =~ /^[0-9a-fA-F]{6}$/
      and $this->{f}->{$confname} ne $this->{c}->{$confname}) {
      $options->{$confname} = $this->{f}->{$confname};
      $flgchgindex = $cindex;
    }
    $cindex++;
  }

  my $cbase64str = '';
  for my $i (0.. $flgchgindex) {
    $cbase64str .= threebytehex_base64($options->{$colors[$i]});
  }

  $this->parameter->setCustomizedValues();

  $options->{c} = substr($options->{c}, 0, 2) . $cbase64str;

  $redirecturl .= "?c=".$options->{c};
  for my $key (qw(w d)) {
    if ($this->{f}->{$key} ne '') {
      $redirecturl .= ";$key=".$this->{f}->{$key};
    }
  }
  if ($this->{f}->{nm}) {
    $redirecturl .= ";m=".$this->{f}->{nm};
  }

  if ($this->{c}->{cookie}) {
    $this->display->setCookie();
  }

  $this->display->prtRedirectHeader($redirecturl);
}


# ݒ胊Zbg
# void clearCustoms()
sub clearCustoms {
  my ($this) = @_;

  if ($this->{c}->{cookie}) {
    $this->display->setCookie();
  }

  $this->display->prtRedirectHeader($this->{c}->{cgiurl});
}

1;
