# L
package Kuzuha::App::Delete;
use strict;

use Kuzuha::App;
@Kuzuha::App::Delete::ISA = qw(Kuzuha::App);

# sIy[V
# void main()
sub main {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  my $options = $this->options;

  if ($options->{undo_p} and $options->{undo_p} eq $this->{f}->{s}) {

    my $message = $this->db->getMessageByID($options->{undo_p});
    unless ($message) {
      return $this->error('undo_notfound');
    }

    my $undokey = crypt ($message->{pcode}, $this->{s}->getAdminpost);
    $undokey =~ s/\W//g;
    $undokey = substr($undokey, -8);
    if ($undokey ne $options->{undo_k}) {
      return $this->error('undo_denied');
    }

    $this->db->deleteMessages([$options->{undo_p}]);

    delete $options->{undo_p};
    delete $options->{undo_k};
    $this->display->setCookie('u', {}, $this->{s}->getTime - 3600);
  }
  else {
    return $this->error('undo_denied');
  }

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('delcomplete', \%data);
  $this->prtFooter();
}

1;
