# ߋO
package Kuzuha::App::Getlog;
use strict;

use Kuzuha::Utility qw(insertComma convTimestampToISOTime escapeHTML convISOTimeToTimeformat escapeURL);
use Time::Local;

use Kuzuha::App;
@Kuzuha::App::Getlog::ISA = qw(Kuzuha::App);

use constant CHARSET => 'sjis';

# sIy[V
# void main()
sub main {
  my ($this) = @_;

  # g\
  if ($this->{f}->{gm} eq 'h') {
    $this->prtGetlogHelp();
  }
  # Xbh
  elsif ($this->{f}->{gm} eq 't') {
    $this->prtSearchThread();
  }
  # Xbhc[\
  elsif ($this->{f}->{gm} eq 'tree') {
    $this->prtSearchTree();
  }
  # 
  elsif ($this->{f}->{l} ne '' or $this->{f}->{n} ne '') {
    $this->prtSearchLog();
  }
  # ߋOʕ\
  else {
    $this->prtGetlog();
  }
}


# _E[h
# void download()
sub download {
  my ($this) = @_;
  my $pathinfo = $this->parameter->getPathInfo();
  if ($pathinfo =~ /\/(\d+)\.html\.gz$/) {
    $this->{download} = $1.".dat";
  }
  $this->prtSearchLog();
  delete $this->{download};
}


# ߋOʕ\
# void prtGetlog()
sub prtGetlog {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  my $options = $this->options;

  my $inputtype = 'radio';
  if ($this->{c}->{multiplesearch}) {
    $inputtype = 'checkbox';
  }
  $data{daterange} = $this->{c}->{pastlogsaveformat} ? "01/00:00:00-31/23:59:59" : "00:00:00-23:59:59";

  # t@CXg̎擾
  my (@filenames, @selectoptions);
  $data{filelist} = $this->db->getPastlogList();
  for my $filedat (@{$data{filelist}}) {
    $filedat->{inputtype} = $inputtype;
    ($filedat->{htmlname} = $filedat->{filename}) =~ s/\.dat$/\.html\.gz/;
    $filedat->{filesize} = insertComma($filedat->{filesize});
    for my $name (qw(cgiurl)) {
      $filedat->{$name} = $this->{c}->{$name};
    }
    for my $name (qw(u i c query)) {
      $filedat->{$name} = $options->{$name};
    }
    push @filenames, $filedat->{filename};
    push @selectoptions, {option => $filedat->{filename}};
  }
  # ZNgXg
  $data{filelist}->[0]->{chk_file} = ' checked="checked"';
  $data{filelist}->[0]->{multiselect} = 1;
  $data{filelist}->[0]->{selectsize} = ($#filenames > 8) ? 10 : $#filenames + 2;
  $data{filelist}->[0]->{rowspan} = $#filenames + 1;
  $data{filelist}->[0]->{'select'} = \@selectoptions;

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('getlog', \%data);
  $this->prtFooter();
}


# ߋO̎g
# void prtGetlogHelp()
sub prtGetlogHelp {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('getlog_help', \%data);
  $this->prtFooter();
}



# ߋO
sub prtSearchLog {
  my ($this) = @_;
  my (%conditions);
  my %data = %{$this->{commondata}};

  my $disp = $this->display;

  $data{pastlogsaveformat} = $this->{c}->{pastlogsaveformat};
  $data{download} = $this->{download} if $this->{download};

  # Ot@C𓾂
  my @logfile = $this->getRequestedFileList();
  $#logfile = 0 unless $this->{c}->{multiplesearch};

  # L[[h͂zɓ
  # $keywordɂ̓NH[gꂽL[[hA$nkeywordɂ͔ےL[[h
  my ($keyword, $nkeyword, $keywordcount) = $this->parseKeyword();
  if ($keywordcount > $this->{c}->{maxkeywords}) {
    return $this->error('pastlog_toomanykeywords'); # "L[[h $::maxkeyword܂łłB"
  }
  $conditions{keyword} = $keyword;
  $conditions{nkeyword} = $nkeyword;

  $conditions{andor} = $this->{f}->{o} if $this->{f}->{o};
  $conditions{target} = $this->{f}->{target} if $this->{f}->{target};
  $conditions{download} = $this->{download} if $this->{download};
  for my $key (qw(ci not single hl jcode image)) {
    $conditions{$key} = 1 if $this->{f}->{$key};
  }

  # eri̕bŕ\j
  if ($this->{f}->{range} =~ /\d/
   and $this->{f}->{range} ne "01/00:00:00-31/23:59:59" and $this->{f}->{range} ne  "00:00:00-23:59:59") {
    $conditions{range} = 1;
    my ($start, $end) = split(/-/, $this->{f}->{range});
    if ($start =~ m[^\s*(?:(\d+)/)?(?:(\d*))?(?::(\d*))?(?::(\d*))?\s*$]) {
      my $xday  = !$this->{c}->{pastlogsaveformat} ? 0 : ($1 >= 1 and $1 <= 31) ? $1-1 : 0;
      my $xhour = ($2 >= 0 and $2 <= 23) ? $2 : 0;
      my $xmin  = ($3 >= 0 and $3 <= 59) ? $3 : 0;
      my $xsec  = ($4 >= 0 and $4 <= 59) ? $4 : 0;
      $conditions{start} = 86400 * $xday + 3600 * $xhour + 60 * $xmin + $xsec;
    } else {
      $conditions{start} = 0;
    }
    if ($end =~ m[^\s*(?:(\d+)/)?(?:(\d*))?(?::(\d*))?(?::(\d*))?\s*$]) {
      my $xday  = !$this->{c}->{pastlogsaveformat} ? 0 : ($1 >= 1 and $1 <= 31) ? $1-1 : 30;
      my $xhour = ($2 >= 0 and $2 <= 23) ? $2 : 23;
      my $xmin  = ($3 >= 0 and $3 <= 59) ? $3 : 59;
      my $xsec  = ($4 >= 0 and $4 <= 59) ? $4 : 59;
      $conditions{end} = 86400 * $xday + 3600 * $xhour + 60 * $xmin + $xsec;
    } else {
      if ($this->{c}->{pastlogsaveformat}) {
        $conditions{end} = 2678399;
      } else {
        $conditions{end} = 86399;
      }
    }
    if ($conditions{start} > $conditions{end}) {
      my $tmp = $conditions{start};
      $conditions{start} = $conditions{end};
      $conditions{end} = $tmp;
    }
  }

  # o͂̊Jn
  if ($this->{download}) {
    my $dlfilename = $this->{download};
    $dlfilename =~ s/\.dat$/\.html\.gz/;
    $disp->prtContentDisposition($dlfilename);
  } else {
    $disp->prtHTTPHeader();
  }
  $this->prtHeader();

  # eOt@Cʌʂւ̃V[gJbg
  my %topdata = %data;
  if (@logfile and !$this->{download}) {
    $topdata{currentquery} = $this->getCurrentQuery(\@logfile);
    my (@linklist, $logindex, @maxoverlist);
    if (@logfile > 1) {
      for ($logindex = 0; $logindex < @logfile and $logindex < $this->{c}->{maxsearchfiles}; $logindex++) {
        my %linklist;
        $linklist{logfile} = $logfile[$logindex];
        $linklist{single} = $this->getCurrentQuery([$linklist{logfile}]);
        push @linklist, \%linklist;
      }
      $topdata{linklist} = \@linklist;
    }
    if ($logindex != @logfile and $logindex == $this->{c}->{maxsearchfiles}) {
      $topdata{maxover} = 1;
      $topdata{maxsearchfiles} = $this->{c}->{maxsearchfiles};
      for (; $logindex < @logfile; $logindex += $this->{c}->{maxsearchfiles}) {
        my $lastfile = $logindex + $this->{c}->{maxsearchfiles} - 1;
        $lastfile = $#logfile if $lastfile > $#logfile;
        my @files = @logfile[$logindex .. $lastfile];
        my %linklist;
        $linklist{maxquery} = $this->getCurrentQuery(\@files);
        $linklist{maxname} = "$files[0] - $files[$#files]";
        push @maxoverlist, \%linklist;
      }
      $topdata{maxoverlist} = \@maxoverlist;
    }
  }
  $disp->prtTemplate('pastlog_top', \%topdata);

  # Ot@CԂɌĂ
  my $db = $this->db;
  for (my $i = 0; $i < @logfile and $i < $this->{c}->{maxsearchfiles}; $i++) {
    my $logfile = $logfile[$i];

    # Ԏw
    if ($conditions{range}) {
      if ($this->{c}->{pastlogsaveformat} and $logfile =~ /^(\d\d\d\d)(\d\d)\.dat/) {
        $conditions{rangebase} = timelocal(0, 0, 0, 1, $2-1, $1);
      } elsif ($logfile =~ /^(\d\d\d\d)(\d\d)(\d\d)\.dat/) {
        $conditions{rangebase} = timelocal(0, 0, 0, $3, $2-1, $1);
      }
      $conditions{rangestart} = $conditions{rangebase} + $conditions{start};
      $conditions{rangeend} = $conditions{rangebase} + $conditions{end};
      $conditions{rangestart_iso} = convTimestampToISOTime($conditions{rangestart});
      $conditions{rangestart_iso} =~ /(\d\d\d\d)-(\d\d)-(\d\d) (\d\d):(\d\d):(\d\d)/;
      $conditions{rangestart_digits} = $1.$2.$3.$4.$5.$6;
      $conditions{rangeend_iso} = convTimestampToISOTime($conditions{rangeend});
      $conditions{rangeend_iso} =~ /(\d\d\d\d)-(\d\d)-(\d\d) (\d\d):(\d\d):(\d\d)/;
      $conditions{rangeend_digits} = $1.$2.$3.$4.$5.$6;
    }

    # print "$logfile:<pre>", Dumper(\%conditions), "</pre>" if $this->{c}->{debug};

    # ̊Jn
    $db->beginPastlogSearch($logfile, \%conditions) or next;
    my %subdata = %data;
    $subdata{logfile} = $logfile;
    if ($conditions{range}) {
      $subdata{range} = $this->{f}->{range};
    }
    $disp->prtTemplate('pastlog_upper', \%subdata);
    # ďo
    while (my $message = $db->nextPastlogSearch()) {
      last unless defined $message;
      # L[[h̃nCCg
      if ($conditions{hl}) {
        for my $keyword (@{$conditions{keyword}}) {
          $message->{msg} =~ s/((?:\G|>)[^<]*?)(\Q$keyword\E)/$1<span class=\"hl\">$2<\/span>/g;
        }
      }
      $this->setMessage($message, $logfile);
      $disp->prtTemplate('message', $message);
    }
    $db->endPastlogSearch();
    $subdata{hitcount} = $db->getPastlogHit();
    $subdata{searchquery} = escapeHTML($this->{f}->{k}) if $this->{f}->{k};
    $disp->prtTemplate('pastlog_lower', \%subdata);
  }

  # ̃y[W
  my %subdata = %data;
  if (defined $this->{f}->{logpage} and !$this->{download}) {
    my $page = $this->{f}->{logpage};
    my @files = $this->getRequestedFileList();
    if (++$page <= $#files) {
      $subdata{pastlogsaveformat} = $this->{c}->{pastlogsaveformat};
      $subdata{logpage} = $page;
      $subdata{hiddenvalues} = '';
      while (my ($name, $value) = each(%{$this->{f}})) {
        next if ($name eq 'logpage' or $name eq 'l');
        escapeHTML($value);
        $subdata{hiddenvalues} .= qq|<input type="hidden" name="$name" value="$value" />\n|;
      }
      for my $file (@files) {
        $subdata{hiddenvalues} .= qq|<input type="hidden" name="l" value="$file" />\n|;
      }
    }
  }
  $disp->prtTemplate('pastlog_bottom', \%subdata);
  $this->prtFooter();
}




# Xbh\
# void prtSearchThread()
sub prtSearchThread {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s} and $this->{f}->{l}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  my $logfile = $this->{f}->{l};
  $data{logfile} = $logfile;
  $data{currentquery} = $this->getCurrentQuery([$logfile]);

  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('pastlog_top', \%data);

  # bZ[W̎擾
  $disp->prtTemplate('pastlog_upper', \%data);
  # ďo
  my $db = $this->db;
  my $messages = $db->beginPastlogSearchByThread($this->{f}->{s}, $logfile);
  while (my $message = $db->nextPastlogSearch()) {
    last unless defined $message;
    $this->setMessage($message, $logfile);
    $disp->prtTemplate('message', $message);
  }
  $db->endPastlogSearch();
  $data{hitcount} = $db->getPastlogHit();
  $disp->prtTemplate('pastlog_lower', \%data);

  $this->prtFooter();
}





# c[\
# void prtSearchTree()
sub prtSearchTree {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s} and $this->{f}->{l}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  my $logfile = $this->{f}->{l};
  $data{logfile} = $logfile;
  $data{currentquery} = $this->getCurrentQuery([$logfile]);

  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('pastlog_top', \%data);

  # bZ[W̎擾
  $disp->prtTemplate('pastlog_upper', \%data);
  # 
  my @result;
  my $db = $this->db;
  my $messages = $db->beginPastlogSearchByThread($this->{f}->{s}, $logfile);
  while (my $message = $db->nextPastlogSearch()) {
    last unless defined $message;
    my $message_store  = $message;
    $this->setMessage($message_store, $logfile);
    push @result, $message_store;
  }
  $db->endPastlogSearch();

  {
    my %treedata = %data;
    $treedata{btnfollow} = '#';
    $treedata{targetname} = '_self';
    require Kuzuha::App::Treeview;
    my $treeapp = Kuzuha::App::Treeview->new($this->{s});
    $treeapp->setTextTree(\%treedata, $this->{f}->{s}, \@result, \%treedata);
    $treedata{btnthread} = "$this->{c}->{cgiurl}?m=g;gm=t;s=$this->{f}->{s};l=$logfile;$treedata{query}";
    $disp->prtTemplate('tree_thread', \%treedata);
  }

  $data{hitcount} = $db->getPastlogHit();
  $disp->prtTemplate('pastlog_lower', \%data);

  $this->prtFooter();
}










# bZ[W̐ݒ
# void setMessage(HashRef message)
sub setMessage {
  my ($this, $message, $logfile) = @_;

  # ttH[}bg
  $message->{timedisp} = convISOTimeToTimeformat($message->{msgtime}, $this->{c}->{timeformat});

  # {^
  {
    # QƋL{^
    if ($message->{refid}) {
      $message->{btnref} = "#m$message->{refid}";
    }

    # Xbh\{^
    $message->{btnthread} = '';
    if (!$this->{download} and $this->{c}->{bbsmode_adminonly} != 1) {
      $message->{btnthread} = "$this->{c}->{cgiurl}?m=g;gm=t;s=$message->{threadid};l=$logfile;".$this->options->{query};
    }

    # c[\{^
    if (!$this->{download} and $this->{c}->{bbsmode_adminonly} != 1) {
      $message->{btntree} = "$this->{c}->{cgiurl}?m=g;gm=tree;s=$message->{threadid};l=$logfile;".$this->options->{query};
    }
  }
  $message->{target} = '_self';

  # pFύX
  $message->{msg} =~ tr/\n/\r/;
  $message->{msg} =~ s/(^|\r)(\&gt;[^\r]*)/$1<span class=\"q\">$2<\/span>/g;
  $message->{msg} =~ s/<\/span>\r<span class=\"q\">/\r/g;
  $message->{msg} =~ tr/\r/\n/;
}



# [hpNG̎擾
sub getCurrentQuery {
  my ($this, $files) = @_;
  my $query;
  for my $name (qw(gm c d s k o ci not single range target gzip jcode)) {
    $query .= $name . '=' . escapeURL($this->{f}->{$name}) . ';' if $this->{f}->{$name};
  }
  for my $filename (@$files) {
    $query .= "l=$filename;";
  }
  return $query;
}



# vꂽt@CXg擾
sub getRequestedFileList {
  my ($this) = @_;
  my @logfile;

  # _E[h
  if ($this->{download}) {
    push @logfile, $this->{download};
  }
  # S
  elsif ($this->{f}->{n} eq 'all') {
    @logfile = $this->getFileList();
  }
  # t@Cw
  elsif (defined($this->{f}->{l})) {
    if ($this->{f}->{l} =~ /\0/) {
      @logfile = grep { length($_) } split(/\0/, $this->{f}->{l});
    } else {
      push @logfile, $this->{f}->{l};
    }
    @logfile = sort { $b cmp $a } keys %{+{ map { $_, 1 } @logfile }};
  }
  # y[W[h
  elsif (defined($this->{f}->{logpage})) {
    my $page = $this->{f}->{logpage};
    my @files = $this->getFileList();
    @logfile = ($files[$page]) if (defined($files[$page]));
  }
  # ŐVn̃t@C(XnMXԖڂM)
  elsif (defined($this->{f}->{n})) {
    my ($first, $last);
    if ($this->{f}->{n} =~ /(\d+)n(\d+)/) {
      $first = $1;
      $last  = $first + $2 - 1;
    } else {
      $first = 0;
      $last  = $this->{f}->{n} - 1;
    }
    my @files = $this->getFileList();
    @logfile = @files[$first .. ($last < $#files ? $last : $#files)];
  }
  # ŐV1̃t@C
  else {
    my @files = $this->getFileList();
    push @logfile, $files[0];
  }
  unless (@logfile) {
    return $this->error('pastlog_read');
  }
  # d菜
  {
    my %count;
    @logfile = grep(!$count{$_}++, @logfile);
  }
  return @logfile;
}


# ݂t@CXg擾
sub getFileList {
  my ($this) = @_;
  my @filelist;
  my $filelist = $this->db->getPastlogList();
  for my $filedat (@$filelist) {
    push @filelist, $filedat->{filename};
  }
  return @filelist;
}



# L[[h𕪉
sub parseKeyword {
  my ($this) = @_;
  my $keyword = $this->{f}->{k} or return ();

  $keyword =~ s/\r\n/\r/g;
  $keyword =~ tr/\n/\r/;

  if ($this->{f}->{jcode}) {
    require Jcode;
    Jcode::convert(\$keyword, CHARSET);
  }

  my (@words, @negatives);

  # quoted keywords
  if (index($keyword, '"') > -1) {
    @words = ($keyword =~ /(?:^|\s)\"(.+?)\"(?:\s|$)/gms);
    $keyword =~ s/(^|\s)\"(.+?)\"(\s|$)/$1$3/gms;
  }
  # negative keywords
  if (index($keyword, '-') > -1) {
    if (index($keyword, '"') > -1) {
      @negatives = ($keyword =~ /(?:^|\s)-\"(.+?)\"(?:\s|$)/gms);
      $keyword =~ s/(^|\s)-\"(.+?)\"(\s|$)/$1$3/gms;
    }
    push @negatives, ($keyword =~ /-([^\s]+)/g);
    $keyword =~ s/-([^\s]+)//g;
  }
  push @words, split (/\s+/, $keyword);
  @words = grep (!/^\s*$/, @words);
  grep {s/^\"//;s/\"$//;} @words;
  grep {s/^\"//;s/\"$//;} @negatives;

  if ($this->{f}->{ci}) {
    grep { $_ = $this->nocase_quote($_) } @words;
    grep { $_ = $this->nocase_quote($_) } @negatives;
  }
  # d菜
  { my %count; @words = grep(!$count{$_}++, @words); }
  { my %count; @negatives = grep(!$count{$_}++, @negatives); }

  my $keywordcount = @words + @negatives;
  return (\@words, \@negatives, $keywordcount);
}


# 啶𓯈ӎquotemeta
sub init_nocase {
  my ($c1, @c2u, @c2l,);
  $::re_alpha = '[A-Za-z]';
  if (CHARSET eq 'sjis') {
    $c1 = 0x82;
    @c2u = 0x60 .. 0x79;
    @c2l = 0x81 .. 0x9A;
    $::re_2byte_alpha = '\x82[\x60-\x79\x81-\x9A]';
    $::re_kanji       = '[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]';
  }
  elsif (CHARSET eq 'euc') {
    $c1 = 0xA3;
    @c2u = 0xC1 .. 0xDA;
    @c2l = 0xE1 .. 0xFA;
    $::re_2byte_alpha = '\xA3[\xC1-\xDA\xE1-\xFA]';
    $::re_kanji       = '[\xA1-\xFE][\xA1-\xFE]'; #EUC͕KvȂEEE
  }
  else{ die }
  for (my $i=0;$i<@c2u;$i++) {
    my $upper = pack('CC',$c1,$c2u[$i]);
    my $lower = pack('CC',$c1,$c2l[$i]);
    $::alpha_table{$upper} = $::alpha_table{$lower} = "(?:\Q$upper\E|\Q$lower\E)";
  }
}
sub nocase_quote {
  my ($this, $s) = @_;
  $this->init_nocase() unless defined $::re_alpha;
  $s =~ s/($::re_2byte_alpha)|($::re_kanji)|($::re_alpha)|(\W)/
  if ($1) {
    $::alpha_table{$1};
  }
  elsif ($3) {
    "[\u$3\l$3]";
  }
  else {
    quotemeta($+);
  }
  /geo;
  return $s;
}





1;
