# c[\
package Kuzuha::App::Treeview;
use strict;

use Kuzuha::Utility qw(convISOTimeToTimeformat);
use Data::Dumper;

use Kuzuha::App;
@Kuzuha::App::Treeview::ISA = qw(Kuzuha::App);

$::SAFETY = 12000;

# sIy[V
# void main()
sub main {
  my ($this) = @_;

  # ʃXbh̃c[\
  if ($this->{f}->{s} ne '') {
    $this->prtThreadTree();
  }
  # VKeʕ\
  elsif ($this->{f}->{'m'} eq 'p' and exists $this->{f}->{write}) {
    require Kuzuha::App::BBS;
    Kuzuha::App::BBS->new($this->{s})->main();
  }
  # c[r[\
  else {
    $this->prtTreeView();
  }
}




# c[r[\
sub prtTreeView {
  my ($this, $retry) = @_;
  my %data = %{$this->{commondata}};

  require Kuzuha::App::BBS;
  my $bbs = Kuzuha::App::BBS->new($this->{s});

  # \IuWFNg
  my $disp = $this->display;

  # bZ[W\p[^
  my $params = $bbs->getDispParams();
  for my $name (qw(msgdisp bindex eindex topmsgid lastindex)) {
    $data{$name} = $params->{$name};
  }

  my $options = $this->options;
  $this->{options} = $options;

  my $isreadnew = 0;
  if (($this->{f}->{readnew} or ($params->{msgdisp} eq '0' and $params->{bindex} == 0)) and $this->{f}->{p} > 0) {
    $isreadnew = 1;
  }

  $data{version} = $this->{s}->getVersion();

  # tH[ݒ
  if ($retry) {
    $data{dtitle} = $this->{f}->{'t'};
    $data{dmsg} = $this->{f}->{'v'};
    $data{dlink} = $this->{f}->{'l'};
  }
  $bbs->setFormdata(\%data, {mode => '<input type="hidden" name="m" value="p" /><input type="hidden" name="ms" value="tree" />'});

  my $threadindex = 0;
  my $logdata = $this->db->getAllMessages();

  # 㕔̕\
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('treeview_upper', \%data);

  # ŏIݎibZ[WIDjŐṼXbhɏ
  while (@$logdata > 0) {

    my $msgcurrent = shift @$logdata;
    if (!$msgcurrent->{threadid}) {
      $msgcurrent->{threadid} = $msgcurrent->{msgid};
    }

    # Xbh$logdata璊oAXbh̃bZ[Wz @thread 쐬
    my @thread = ($msgcurrent);
    my $i = 0;
    while ($i < @$logdata) {
      my $message = $logdata->[$i];
      if ($message->{threadid} == $msgcurrent->{threadid}
        or $message->{msgid} == $msgcurrent->{threadid}) {
        splice(@$logdata, $i, 1);
        push @thread, $message;
        # ̔
        last if ($message->{msgid} == $message->{threadid} or !$message->{threadid});
      }
      else {
        $i++;
      }
    }

    # ǃ[h
    if ($isreadnew) {
      my $hit = 0;
      for ($i = 0; $i < @thread; $i++) {
        if ($thread[$i]->{msgid} > $this->{f}->{p}) {
          $hit = 1;
          last;
        }
      }
      if (!$hit) {
        next;
      }
    }
    elsif ($params->{msgdisp} < 0) {
      last;
    }
    # Jnindex
    elsif ($threadindex < $params->{bindex}) {
      $threadindex++;
      next;
    }

    # $thread ̃eLXgc[o
    my %treedata = %{$this->{commondata}};
    $this->setTextTree(\%treedata, $msgcurrent->{threadid}, \@thread);
    $disp->prtTemplate('tree_thread', \%treedata);

    $threadindex++;

    last if ($threadindex >= $params->{eindex});
  }
  $params->{eindex} = $threadindex;
  $params->{lastindex} = $params->{eindex} if $#{$logdata} < 0;

  # bZ[W
  if ($params->{msgdisp} < 0) {
    $data{msg_normal} = 0;
    $data{msg_nonew} = 0;
    $data{msg_nomsg} = 0;
  } elsif ($params->{eindex} > 0) {
    $data{msg_normal} = 1;
    $data{msg_nonew} = 0;
    $data{msg_nomsg} = 0;
    $data{bindex} = $params->{bindex}+1;
    $data{eindex} = $params->{eindex};
  } else {
    $data{msg_normal} = 0;
    $data{msg_nonew} = 1;
    $data{msg_nomsg} = 0;
  }
  if ($params->{eindex} >= $params->{lastindex}) {
    $data{msg_nomsg} = 1;
  }

  # irQ[g{^
  if ($params->{eindex} > 0) {
    if ($params->{eindex} < $params->{lastindex}) {
      $data{nextpage} = 1;
    }
    if ($this->{c}->{'show_readnewbtn'}) {
      $data{readnew} = 1;
    }
  }

  # Ǘғe
  if ($this->{c}->{'bbsmode_adminonly'}) {
    $data{adminlogin} = 1;
  }

  # fobO
  if ($this->{c}->{debug}) {
    $data{debuginfo} .= "[params]\n";
    for my $debug (sort keys %{$this->{f}}) {
      $data{debuginfo} .= "$debug = $this->{f}->{$debug}\n";
    }
    $data{debuginfo} .= "\n[options]\n";
    for my $debug (sort keys %$options) {
      $data{debuginfo} .= "$debug = $options->{$debug}\n";
    }
    $data{debuginfo} .= "\n[data]\n";
    for my $debug (sort keys %data) {
      next if $debug eq 'debuginfo';
      $data{debuginfo} .= "$debug = $data{$debug}\n";
    }
    $data{debuginfo} .= "\nlogdata:$#{$logdata}\n";
  }

  # ̕\
  $disp->prtTemplate('treeview_lower', \%data);
  $this->prtFooter();

}












# eLXgc[o
# @param   Array   $threadid    ebZ[W
# @param   Array   \@thread      eq܂ރbZ[W̔z
sub setTextTree {
  my ($this, $data, $threadid, $thread, $exconditions) = @_;

  $exconditions ||= {};
  @$thread = sort {$a->{msgid} <=> $b->{msgid}} @$thread;
  $data->{btnthread} = "$this->{c}->{cgiurl}?m=t;s=$threadid;$this->{commondata}->{query}";
  $data->{tree} = ${$this->generateTree($thread, $threadid, $exconditions)};
  $data->{tree} =~ s/<\/span><span class=\"bc\">//g;
  $data->{tree} =~ s/<\/span>  <span class=\"bc\">/  /g;
  $data->{tree} =~ s/\r/\r  /g;
  $data->{tree} =~ s/(<span class=\"bc\">[^<]*<\/span>)/$1 /g;
  $data->{tree} = '  ' . $data->{tree};
  1 while $data->{tree} =~ s/\Q  \E$//;
  $data->{tree} =~ s/\r$//;
  $data->{tree} =~ tr/\r/\n/;
}




# eLXgc[̍ċA֐
# @param   Array   \@treemsgs  eq܂ރbZ[W̔z
# @param   Integer $parentid   eID
# @return  String  \$treeprint eq̃c[
sub generateTree {
  my ($this, $treemsgs, $parentid, $exconditions) = @_;

  die if --$::SAFETY < 0;

  # c[
  my $treeprint = '';

  # ebZ[W̏o
  my $pos = 0;
  my $found = 0;
  for my $treemsg (@$treemsgs) {
    if ($treemsg->{msgid} == $parentid) {

      # p̏
      if ($this->options->{qoff}) {
        $treemsg->{msg} =~ s/(^|\r)&gt;[^\r]*//g;
      }
      else {
        $treemsg->{msg} =~ s/(^|\r)(\&gt;[^\r]*)/$1<span class=\"q\">$2<\/span>/g;
      }

      # V\
      if ($this->{f}->{p} > 0 and $treemsg->{msgid} > $this->{f}->{p}) {
        $treemsg->{msg} = '<span class="newmsg">' . $treemsg->{msg} . '</span>';
      }

      # tH[ʂւ̃N
      if ($exconditions->{btnfollow}) {
        $treemsg->{btnfollow} = $exconditions->{btnfollow};
      } else {
        $treemsg->{btnfollow} = "$this->{c}->{cgiurl}?m=f;s=$parentid;$this->{commondata}->{query}";
      }
      if ($exconditions->{targetname}) {
        $treemsg->{targetname} = $exconditions->{targetname};
      } else {
        $treemsg->{targetname} = $this->{commondata}->{targetname};
      }

      # ttH[}bg
      $treemsg->{timedisp} = convISOTimeToTimeformat($treemsg->{msgtime}, $this->{c}->{timeformat});

      # 摜BBS̉摜\
      #$treemsg->{msg} = Func::conv_imgtag($treemsg->{msg});

      $treemsg->{msg} =~ s/^[\r\n]+//;
      $treemsg->{msg} =~ s/[\r\n]+$//;
      $treeprint .= $this->display->getTemplate('tree_msg', $treemsg);

      # z񂩂
      splice(@$treemsgs, $pos, 1);
      $found = 1;
      last;
    }
    $pos++;
  }
  # e Not Found.
  if (!$found and $#{$treemsgs} > -1) {
    $treeprint .= $this->display->getTemplate('tree_msgdeleted');
  }
  $treeprint =~ s/\r\n/\r/g;
  $treeprint =~ tr/\n/\r/;

  # qID
  my (@childids, @sepids);
  for my $treemsg (@$treemsgs) {
    if ($treemsg->{refid} == $parentid) {
      push @childids, $treemsg->{msgid};
    } else {
      push @sepids, $treemsg->{msgid};
    }
  }

  # qȂA}uv̂΂
  if (@childids) {
    $treeprint =~ s/\r/\r<span class=\"bc\"><\/span>/g;
  }
  # Ȃ΍s
  else {
    $treeprint =~ s/\r/\r  /g;
  }

  # q̃c[擾A
  my $childidcount = $#childids;
  my $childidindex = 0;
  for my $childid (@childids) {
    my $childtree = $this->generateTree($treemsgs, $childid, $exconditions);

    # ̎qȂA}uvuv̂΂
    if ($childidindex < $childidcount) {
      $$childtree =~ s/\r/\r<span class=\"bc\"><\/span>/g;
      $$childtree = '<span class="bc"></span>' . $$childtree;
    }
    # Ō̎qȂ}uvs󔒂𖄂߂
    else {
      $$childtree =~ s/\r/\r  /g;
      $$childtree = '<span class="bc"></span>' . $$childtree;
    }

    # q̃c[eɌ
    $treeprint .= "\r" . $$childtree;

    $childidindex++;
  }

  # ǎtH[
  if (!$found and $#{$treemsgs} > -1) {
    my $sepidcount = $#sepids;
    my $sepidindex = 0;
    for my $sepid (@sepids) {
      my $septree = $this->generateTree($treemsgs, $sepid, $exconditions);

      # q̃c[eɌ
      $treeprint .= "\r" . $$septree;
      $sepidindex++;
    }
  }

  return \$treeprint;
}



# ʃXbh̃c[\
sub prtThreadTree {
  my ($this) = @_;
  my %data = %{$this->{commondata}};

  unless ($this->{f}->{s}) {
    return $this->error('bbs_lackofparams'); # p[^܂B
  }

  # bZ[W̎擾
  my $messages = $this->db->getMessagesByThreadID($this->{f}->{s});
  unless ($messages) {
    return $this->error('bbs_msgnotfound'); # w肳ꂽbZ[W܂B
  }
  $this->setTextTree(\%data, $this->{f}->{s}, $messages);

  # \
  my $disp = $this->display;
  $disp->prtHTTPHeader();
  $this->prtHeader();
  $disp->prtTemplate('tree_thread', \%data);
  $this->prtFooter();
}


1;
