# CSVt@C𗘗pDatabaseNX
package Kuzuha::Database::CSV;
use strict;

use FileHandle;
use DirHandle;
use Fcntl qw/:flock/;

use Kuzuha::Database;
@Kuzuha::Database::CSV::ISA = qw(Kuzuha::Database);

# Ot@C`̒`
my %logformat = (
  msgid       => 0,   # bZ[WID(ʔ)
  bbsid       => 1,   # Remix^}`[hpgsbNID
  threadid    => 2,   # XbhID
  refid       => 3,   # QID
  msgtime     => 4,   # o^
  pcode       => 5,   # veNgR[h
  hostname    => 6,   # zXg
  useragent   => 7,   # [U[G[WFg
  name        => 8,   # O
  userattr    => 9,   # [U[(Wł̓[AhX)
  title       => 10,  # 薼
  msg         => 11,  # {
  msgattr     => 12,  # bZ[W(󖢎gp)
);


# \z
# Kuzuha::Database::CSV new(String dburl)
sub new {
  my($class, $dburl) = @_;

  # f[^LbVbless
  my $this = {
    dburl => $dburl,
  };
  bless $this, $class;

  $this->dbConnect();

  # f[^LbṼNA
  delete $this->{c};
  $this->setConstants();

  return $this;
}


#---------------------------------------------------------------
#   Public Methods
#---------------------------------------------------------------

# DBڑ
# bool dbConnect()
sub dbConnect { 1 }


# DBؒf
# bool dbDisonnect()
sub dbDisconnect { 1 }


#---------------------------------------------------------------
#   ݒ


# ݒݒe[u擾
# void setConstants()
sub setConstants {
  my ($this) = @_;
  my ($data);

  eval "require '$this->{dburl}'";
  $this->db_error($@) if $@;

  $this->{c} = \%config::CONFIG;
}


# ݒLbV擾
# HashRef getConstants()
sub getConstants {
  my ($this) = @_;

  unless (exists $this->{c}) {
    $this->setConstants();
  }

  return $this->{c};
}


# ݒ̐ݒeRg擾
# HashRef getConstComments()
sub getConstComments {
  my ($this, $bbsid) = @_;
  return undef;
}


# ݒύX
# int modifyConstant(String name, String value)
sub modifyConstant {
  my ($this, $name, $value) = @_;
  my ($oldvalue);

  my $fh = FileHandle->new($this->{dburl}, "r+");
  unless (defined $fh) {
    $this->db_error('db_modifyconstant');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @data = $fh->getlines;
  for my $data (@data) {
    if ($data =~ s/(\s+[\"\']?$name[\"\']?\s+=>\s+[\"\']?)([^\s\"\']*)([\"\']?\,\s)/$1$value$3/) {
      $oldvalue = $2;
      last;
    }
  }
  # f[^
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @data;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 0;
}


#---------------------------------------------------------------
#   bZ[WQ


# ǃ|C^̎擾
# int getTopmsgid([int bbsid], [int logdate])
sub getTopmsgid {
  my ($this, $bbsid, $logdate) = @_;

  return $this->{topmsgid} if ($this->{topmsgid});

  my $fh = $this->_openLogfile($bbsid, $logdate);
  my $firstline = $this->_splitCSVLine($fh->getline);
  $fh->close;

  if ($firstline->[$logformat{msgid}]) {
    $this->{topmsgid} = $firstline->[0];
    return $this->{topmsgid};
  }
  else {
    return 0;
  }
}


# ۑĂ錏̎擾
# int countMessages([int bbsid], [int logdate]);
sub countMessages {
  my ($this, $bbsid, $logdate) = @_;
  my $count = 0;
  my $fh = $this->_openLogfile($bbsid, $logdate);
  $count++ while $fh->getline;
  $fh->close;
  return $count;
}


# w͈͂̃bZ[W擾
# ArrayRef getMessagesByRange(int bindex, int eindex, [int bbsid])
sub getMessagesByRange {
  my ($this, $bindex, $eindex, $bbsid) = @_;
  my (@logdata);
  my $fh = $this->_openLogfile($bbsid);
  for (1 .. $bindex) {
    $fh->getline;
  }
  for ($bindex .. $eindex-1) {
    push @logdata, $fh->getline;
  }
  $fh->close;

  for my $logline (@logdata) {
    $logline = $this->_convCSVToMessage($logline);
  }

  return \@logdata;
}


# SbZ[W擾
# ArrayRef getAllMessages([int bbsid])
sub getAllMessages {
  my ($this, $bbsid) = @_;
  my (@logdata);
  my $fh = $this->_openLogfile($bbsid);
  @logdata = $fh->getlines;
  $fh->close;

  for my $logline (@logdata) {
    $logline = $this->_convCSVToMessage($logline);
  }

  return \@logdata;
}


# wID̃bZ[W擾
# HashRef getMessageByID(int msgid, [int bbsid])
sub getMessageByID {
  my ($this, $msgid, $bbsid) = @_;
  my ($buffer, $message);
  my $fh = $this->_openLogfile($bbsid);
  while ($buffer = $fh->getline and $buffer) {
    my $values = $this->_splitCSVLine($buffer);
    if ($values->[$logformat{msgid}] == $msgid) {
      $message = $this->_convCSVToMessage($buffer);
      last;
    }
  }
  $fh->close;

  return $message;
}


# wXbhID̃bZ[Wꗗ擾
# ArrayRef getMessagesByThreadID(int threadid, [int bbsid])
sub getMessagesByThreadID {
  my ($this, $threadid, $bbsid) = @_;
  my ($buffer, @logdata);

  my $fh = $this->_openLogfile($bbsid);
  while ($buffer = $fh->getline and $buffer) {
    my $values = $this->_splitCSVLine($buffer);
    if ($values->[$logformat{threadid}] == $threadid) {
      push @logdata, $this->_convCSVToMessage($buffer);
      last if ($values->[$logformat{msgid}] == $threadid);
    }
  }
  $fh->close;

  return \@logdata;
}


# w肳ꂽeҖ̃bZ[Wꗗ擾
# ArrayRef getMessagesByThreadID(String name, [int bbsid])
sub getMessagesByName {
  my ($this, $name, $bbsid) = @_;
  my ($buffer, @logdata);

  my $fh = $this->_openLogfile($bbsid);
  while ($buffer = $fh->getline and $buffer) {
    my $values = $this->_splitCSVLine($buffer);
    $values->[$logformat{name}] =~ s/<[^>]*>//g;
    if ($values->[$logformat{name}] eq $name) {
      push @logdata, $this->_convCSVToMessage($buffer);
    }
  }
  $fh->close;

  return \@logdata;
}


#---------------------------------------------------------------
#   bZ[W


# bZ[Wo^
# int insertMessage(HashRef message, [int bbsid])
sub insertMessage {
  my ($this, $message, $bbsid) = @_;

  my $filepath = $this->_getFilepath($bbsid);
  my $fh = FileHandle->new($filepath, "r+");
  if (!$fh) {
    $this->db_error('db_messageread');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @logdata = $fh->getlines;
  my $logdatasize = $#logdata + 1;
  my $logformatsize = scalar keys %logformat;

  # `FbN
  my $posterr = 0;
  for my $i (0 .. $this->{c}->{checkcount}) {
    last if $i > $logdatasize - 2;
    my $items = $this->_splitCSVLine($logdata[$i]);
    next if ($#{$items} < 1);
    # d݃`FbN
    if ($message->{msg} eq $items->[$logformat{msg}]) {
      $posterr = 3;
      last;
    }
    # zXgeԊu`FbN
    if ($this->{c}->{iprec} and $message->{msgtime} < ($items->[0] + $this->{c}->{sptime})
     and $message->{hostname} eq $items->[$logformat{hostname}]) {
      $posterr = 2;
      last;
    }
    # dveNgR[h`FbN
    if ($message->{pcode} and $message->{pcode} eq $items->[$logformat{pcode}]) {
      $posterr = 2;
      last;
    }
  }
  if ($posterr) {
    flock ($fh, LOCK_UN);
    $fh->close;
    return $posterr;
  }

  # f[^̍쐬
  my @firstline = split(/,/, $logdata[0]);
  if ($firstline[$logformat{msgid}] > 0) {
    $message->{msgid} = $firstline[$logformat{msgid}] + 1;
  }
  else {
    $message->{msgid} = 1;
  }
  if (!$message->{refid} and !$message->{threadid}) {
    $message->{threadid} = $message->{msgid};
  }
  my @insertdata;
  my @logkeys =  keys %logformat;
  for my $logkey (@logkeys) {
    $insertdata[$logformat{$logkey}] = $message->{$logkey};
  }
  my $insertdata = join ',', map {(s/"/""/g or /[\r\n,]/) ? qq("$_") : $_} @insertdata;
  $insertdata =~ s/\r\n/\r/g;
  $insertdata =~ tr/\n/\r/;
  $insertdata .= "\n";

  # Âf[^폜
  if ($logdatasize >= $this->{c}->{logsave}) {
    $#logdata = $this->{c}->{logsave};
  }

  # f[^
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh $insertdata;
  print $fh @logdata;
  flock ($fh, LOCK_UN);
  $fh->close;

  undef @logdata;
  undef @insertdata;
  return wantarray ? (0, $message) : 0;
}


# bZ[WߋOɒǉ
# int insertMessage(HashRef message, String logdate, [int bbsid])
sub insertPastlog {
  my ($this, $message, $logdate, $bbsid) = @_;

  my $isnewdate = 0;
  my $filepath = $this->_getFilepath($bbsid, $logdate);

  if (-e $filepath and (-s $filepath) > $this->{c}->{maxpastlogsize}) {
    $this->db_error('db_maxpastlogsize'); # ߋOt@CTCY𒴂Ă܂B
  }
  unless (-e $filepath) {
    $isnewdate = 1;
  }

  my @insertdata;
  my @logkeys =  keys %logformat;
  for my $logkey (@logkeys) {
    $insertdata[$logformat{$logkey}] = $message->{$logkey};
  }
  my $insertdata = join ',', map {(s/"/""/g or /[\r\n,]/) ? qq("$_") : $_} @insertdata;
  $insertdata =~ s/\r\n/\r/g;
  $insertdata =~ tr/\n/\r/;
  $insertdata .= "\n";

  # ߋOo
  my $fh = FileHandle->new($filepath, "a");
  if (!$fh) {
    $this->db_error('db_pastlogwrite');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  print $fh $insertdata;
  flock ($fh, LOCK_UN);
  $fh->close;

  # ÂߋO폜
  if ($isnewdate and $this->{c}->{pastlogsaveformat} == 0) {
    my $dir = $this->_getDirpath($bbsid);
    my @files = DirHandle->new($dir)->read();
    for my $filename (@files) {
      if ($filename =~ /^(\d+)\.dat$/ and (-M $dir.$filename) > $this->{c}->{pastlogsaveday}) {
        unlink $dir.$filename;
      }
    }
  }

  return 0;
}


# ߋOt@Cꗗ̎擾
# ArrayRef getPastlogList()
sub getPastlogList {
  my ($this, $bbsid) = @_;
  my @pastloglist;

  my $dir = $this->_getDirpath($bbsid);
  my @files = DirHandle->new($dir)->read();
  for my $filename (@files) {
    if ($filename =~ /^(\d+)\.dat$/) {
      my @stat = stat($dir.$filename);
      my %fileinfo;
      $fileinfo{filename} = $filename;
      $fileinfo{filepath} = $dir.$filename;
      $fileinfo{filesize} = $stat[7];
      $fileinfo{modtime} = Kuzuha::Utility::convTimestampToISOTime($stat[9]);
      push @pastloglist, \%fileinfo;
    }
  }
  @pastloglist = sort {$b->{filename} cmp $a->{filename}} @pastloglist;
  return \@pastloglist;
}


# ߋOJn
# resultsetƌ[`LbVɕێ
sub beginPastlogSearch {
  my ($this, $logfile, $conditions, $bbsid) = @_;
  $logfile =~ s/\.dat$//;

  my ($searchexp, $rangeexp);
  if ($conditions->{range}) {
    $rangeexp = <<_CODE_;
if (\$message[$logformat{msgtime}] =~ /(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d)/) {
  my \$currentdigits = \$1.\$2.\$3.\$4.\$5.\$6;
  next if (\$currentdigits < \$conditions->{rangestart_digits});
  last if (\$currentdigits > \$conditions->{rangeend_digits});
}
_CODE_
  }
  if ($#{$conditions->{keyword}} < 0) {
    $searchexp = 1;
  }
  else {
    my $targets;
    if ($conditions->{target} eq 'name') {
      $targets = "\$message[$logformat{name}]";
    }
    elsif ($conditions->{target} eq 'title') {
      $targets = "\$message[$logformat{title}]";
    }
    elsif ($conditions->{target} eq 'msg') {
      $targets = "\$message[$logformat{msg}]";
    }
    else{
      $targets = "\@message[$logformat{name},$logformat{title},$logformat{msg}]";
    }
    my $andor = $conditions->{andor} eq 'o' ? ' or ' : ' and ';
    my $i = @{$conditions->{keyword}};
    for my $keyword (@{$conditions->{keyword}}) {
      if ($conditions->{ci} or $conditions->{escseq}) {
        $searchexp .= qq|grep(/$keyword/, $targets)\n|;
      } else {
        $searchexp .= qq|\$this->_hasIndex([$targets],'$keyword')\n|;
      }
      $searchexp .= $andor if --$i > 0;
    }
    $i = @{$conditions->{nkeyword}};
    $searchexp .= $andor if $i;
    for my $nkeyword (@{$conditions->{nkeyword}}) {
      if ($conditions->{ci} or $conditions->{escseq}) {
        $searchexp .= qq|\!grep(/$nkeyword/, $targets)\n|;
      } else {
        $searchexp .= qq|\!\$this->_hasIndex([$targets],'$nkeyword')\n|;
      }
      $searchexp .= $andor if --$i > 0;
    }
  }

  my $fh = $this->_openLogfile($bbsid, $logfile);
  unless (defined $fh) {
    $this->db_error('db_pastlogread');
  }
  $this->{past_resultset} = $fh;
  $this->{past_hit} = 0;
  $this->{past_message} = undef;

  # R[h𖳖Tu[`ō쐬
  $this->{past_eval} = <<_CODE_;
\$this->{past_sub} = sub {
  delete \$this->{past_message};
  while (my \$buffer = \$this->{past_resultset}->getline) {
    my \@message = \@{\$this->_splitCSVLine(\$buffer)};
$rangeexp
    if ($searchexp) {
      \$this->{past_hit}++;
      \$this->{past_message} = \$this->_convListToMessage(\\\@message);
      last;
    }
  }
};
_CODE_
  EVAL: {
    local $@;
    eval $this->{past_eval};
    $this->db_error($@) if $@;
  }
  if ($this->{c}->{debug} > 1) {
    use Kuzuha::Utility;
    dumpInComment($conditions, $this->{past_eval});
  }
  return 1;
}


# ߋOXbhJn
# resultsetƌ[`LbVɕێ
sub beginPastlogSearchByThread {
  my ($this, $threadid, $logfile, $bbsid) = @_;
  $logfile =~ s/\.dat$//;

  my $fh = $this->_openLogfile($bbsid, $logfile);
  unless (defined $fh) {
    $this->db_error('db_pastlogread');
  }
  $this->{past_resultset} = $fh;
  $this->{past_hit} = 0;
  $this->{past_message} = undef;

  # R[h𖳖Tu[`ō쐬
  $this->{past_eval} = <<_CODE_;
\$this->{past_sub} = sub {
  delete \$this->{past_message};
  while (my \$buffer = \$this->{past_resultset}->getline) {
    my \$message = \$this->_splitCSVLine(\$buffer);
    if (\$message->[$logformat{threadid}] eq '$threadid') {
      \$this->{past_hit}++;
      \$this->{past_message} = \$this->_convListToMessage(\$message);
      last;
    }
  }
};
_CODE_
  #print "<pre><font color=#cccccc>$this->{past_eval}</font></pre>" if $this->{c}->{debug};
  EVAL: {
    local $@;
    eval $this->{past_eval};
    $this->db_error($@) if $@;
  }
  return 1;
}


# ߋO
# resultseti߂ă}b`ɐ̂Ԃ
sub nextPastlogSearch {
  my ($this) = @_;
  $this->{past_sub}->();
  return $this->{past_message};
}


# ߋOI
# resultset
sub endPastlogSearch {
  my ($this) = @_;

  $this->{past_resultset}->close;
  delete $this->{past_resultset};
}


# ߋOqbg
sub getPastlogHit {
  my ($this) = @_;
  return $this->{past_hit};
}


# bZ[W폜
# deleteMessages(ArrayRef msgids)
sub deleteMessages {
  my ($this, $msgids, $bbsid) = @_;

  my $filepath = $this->_getFilepath($bbsid);
  my $fh = FileHandle->new($filepath, "r+");
  if (!$fh) {
    $this->db_error('db_messageread');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @logdata = $fh->getlines;
  my $logdatasize = $#logdata + 1;

  my (%killntimes, @killlogdata, @newlogdata);
  my $i = 0;
  while ($i < $logdatasize) {
    my $items = $this->_splitCSVLine($logdata[$i]);
    if (grep(/^$items->[$logformat{msgid}]$/, @$msgids)) {
      $killntimes{$items->[$logformat{msgid}]} = $items->[$logformat{msgtime}];
      push @killlogdata, $logdata[$i];
    }
    else {
      push @newlogdata, $logdata[$i];
    }
    $i++;
  }

  # f[^
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @newlogdata;
  flock ($fh, LOCK_UN);
  $fh->close;

  # ߋOs폜
  {
    while (my ($killid, $killntime) = each %killntimes) {
      my $logdate;
      $killntime =~ /(\d\d\d\d)-(\d\d)-(\d\d)/;
      if ($this->{c}->{pastlogsavesw}) {
        $logdate = $1.$2;
      } else {
        $logdate = $1.$2.$3;
      }
      $filepath = $this->_getFilepath($bbsid, $logdate);
      $fh = FileHandle->new($filepath, "r+");
      if (!$fh) {
        $this->db_error('db_messageread');
      }
      binmode($fh);
      flock ($fh, LOCK_EX);
      seek ($fh, 0, 0);

      my $hit = 0;
      @newlogdata = ();
      while (my $logline = $fh->getline) {
        my $items = $this->_splitCSVLine($logline);
        if (!$hit and $items->[$logformat{msgid}] eq $killid) {
          $hit = 1;
        }
        else {
          push @newlogdata, $logline;
        }
      }

      seek ($fh, 0, 0);
      truncate ($fh, 0);
      print $fh @newlogdata;
      flock ($fh, LOCK_UN);
      $fh->close;
    }
  }

  undef @logdata;
  undef @newlogdata;
  return 0;
}


#---------------------------------------------------------------
#   Œnh


# Œnh̔
sub isHandleName {
  my ($this, $candidate) = @_;

  my $fh = $this->_openAnyfile('handlename.dat');
  if (!$fh) {
    $this->db_error('db_handlename');
  }
  my $hit = 0;
  while (my $line = $fh->getline) {
    my $items = $this->_splitCSVLine($line);
    if ($items->[0] eq $candidate) {
      $hit = 1;
      last;
    }
  }
  $fh->close;
  return $hit;
}


# ŒnhpX̔
sub getHandleNameByPass {
  my ($this, $candidate) = @_;

  my $fh = $this->_openAnyfile('handlename.dat');
  if (!$fh) {
    $this->db_error('db_handlename');
  }
  my $name = undef;
  while (my $line = $fh->getline) {
    my $items = $this->_splitCSVLine($line);
    if ($items->[1] eq $candidate) {
      $name = $items->[0];
      last;
    }
  }
  $fh->close;
  return $name;
}


# Œnhꗗ
sub getHandleNames {
  my ($this) = @_;

  my $fh = $this->_openAnyfile('handlename.dat');
  if (!$fh) {
    $this->db_error('db_handlename');
  }
  my @data = $fh->getlines;
  for my $data (@data) {
    $data = $this->_splitCSVLine($data);
  }
  $fh->close;
  return \@data;
}


# Œnhǉ/pXҏW
sub insertHandleName {
  my ($this, $name, $pass) = @_;

  my $fh = $this->_openAnyfile('handlename.dat', 'r+');
  if (!$fh) {
    $this->db_error('db_handlename');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @data = $fh->getlines;
  my $exists = 0;
  for my $data (@data) {
    $data = $this->_splitCSVLine($data);
    if (!$exists and $data->[0] eq $name) {
      $data->[1] = $pass;
      $exists = 1;
    }
  }
  if (!$exists) {
    push @data, [$name, $pass];
  }
  @data = map {$_ = (join ',', map {(s/"/""/g or /[\r\n,]/) ? qq("$_") : $_} @$_) . "\n"} @data;
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @data;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 1;
}


# Œnh
sub deleteHandleName {
  my ($this, $name) = @_;

  my $fh = $this->_openAnyfile('handlename.dat', 'r+');
  if (!$fh) {
    $this->db_error('db_handlename');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @data = $fh->getlines;
  my @newdata;
  my $hit = 0;
  for my $data (@data) {
    my $items = $this->_splitCSVLine($data);
    if (!$hit and $items->[0] eq $name) {
      $hit = 1;
    } else {
      push @newdata, $data;
    }
  }
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @newdata;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 1;
}


#---------------------------------------------------------------
#   zXg


# zXgꗗ
sub getBanlist {
  my ($this, $matchtype) = @_;
  $matchtype ||= 0;

  my $fh = $this->_openAnyfile('banlist.dat');
  if (!$fh) {
    $this->db_error('db_banlist');
  }
  my @data = $fh->getlines;
  my @result;
  for my $data (@data) {
    $data = $this->_splitCSVLine($data);
    if ($data->[3] >= $matchtype) {
      push @result, $data;
    }
  }
  $fh->close;

  return \@result;
}


# zXgǉ
sub insertBanlist {
  my ($this, $hostname, $nametype, $bantype) = @_;

  my $fh = $this->_openAnyfile('banlist.dat', 'r+');
  if (!$fh) {
    $this->db_error('db_banlist');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @data = $fh->getlines;
  my $id = 1;
  if ($#data > -1) {
    my $firstline = $this->_splitCSVLine($data[$#data]);
    $id = $firstline->[0] + 1;
  }
  push @data, join ',', map {(s/"/""/g or /[\r\n,]/) ? qq("$_") : $_} ($id, $hostname, $nametype, $bantype);
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @data;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 1;
}


# zXgҏW
sub updateBanlist {
  my ($this, $id, $hostname, $nametype, $bantype) = @_;

  my $fh = $this->_openAnyfile('banlist.dat', 'r+');
  if (!$fh) {
    $this->db_error('db_banlist');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @data = $fh->getlines;
  my $exists = 0;
  for my $data (@data) {
    $data = $this->_splitCSVLine($data);
    if (!$exists and $data->[0] eq $id) {
      $data->[1] = $hostname;
      $data->[2] = $nametype;
      $data->[3] = $bantype;
      $exists = 1;
    }
  }
  if (!$exists) {
    push @data, [$id, $hostname, $nametype, $bantype];
  }
  @data = map {$_ = (join ',', map {(s/"/""/g or /[\r\n,]/) ? qq("$_") : $_} @$_) . "\n"} @data;
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @data;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 1;
}


# zXg
sub deleteBanlist {
  my ($this, $id) = @_;

  my $fh = $this->_openAnyfile('banlist.dat', 'r+');
  if (!$fh) {
    $this->db_error('db_banlist');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  seek ($fh, 0, 0);
  my @data = $fh->getlines;
  my @newdata;
  my $hit = 0;
  for my $data (@data) {
    my $items = $this->_splitCSVLine($data);
    if (!$hit and $items->[0] eq $id) {
      $hit = 1;
    } else {
      push @newdata, $data;
    }
    Kuzuha::Utility::debugPrint("$items->[0] eq $id");
  }
  seek ($fh, 0, 0);
  truncate ($fh, 0);
  print $fh @newdata;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 1;
}


#---------------------------------------------------------------
#   e֎~


# e֎~ꗗ
sub getNGWord {
  my ($this) = @_;

  my $fh = $this->_openAnyfile('ngword.dat');
  if (!$fh) {
    $this->db_error('db_ngword');
  }
  my @data = $fh->getlines;
  chomp @data;

  return \@data;
}


# e֎~ҏW
sub updateNGWord {
  my ($this, $ngword) = @_;

  my $fh = $this->_openAnyfile('ngword.dat', 'w');
  if (!$fh) {
    $this->db_error('db_ngword');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  print $fh $ngword;
  flock ($fh, LOCK_UN);
  $fh->close;

  return 1;
}


#---------------------------------------------------------------
#   o̓LbV

sub startSaveCache {
  my ($this, $cachename, $bbsid) = @_;

  my $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }

  my $cachefile = $filedir . $cachename . '.cache.html';
  my $fh = FileHandle->new($cachefile, 'w');
  if (!$fh) {
    $this->db_error('db_cachewrite');
  }
  binmode($fh);
  flock ($fh, LOCK_EX);
  $this->{cachehandle} = $fh;
  select ($fh);
  return 1;
}

sub endSaveCache {
  my ($this) = @_;
  my $fh = $this->{cachehandle};
  if (!$fh) {
    return;
  }
  flock ($fh, LOCK_UN);
  $fh->close;
  undef $this->{cachehandle};
  select (STDOUT);
  return 1;
}

sub loadCache {
  my ($this, $cachename, $bbsid) = @_;

  my $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }

  my $cachefile = $filedir . $cachename . '.cache.html';
  my $fh = FileHandle->new($cachefile);
  if (!$fh) {
    $this->db_error('db_cacheread');
  }
  my @lines = $fh->getlines;
  $fh->close;
  my $cachetext = join '', @lines;
  return \$cachetext;
}


#---------------------------------------------------------------
#   JE^[


# ɂJE^[
# int counter()
sub counter {
  my ($this, $bbsid) = @_;
  my (@count, @filenumber);

  my $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }

  my $countlevel = $this->{c}->{countlevel};
  $countlevel = 1 if $countlevel < 1;

  for my $i (0 .. $countlevel-1) {
    my $fh = FileHandle->new("${filedir}count$i.dat");
    if (defined $fh) {
      $count[$i] = $fh->getline;
      $fh->close;
    } else {
      $count[$i] = 0;
    }
    $filenumber[$count[$i]] = $i;
  }

  @count = sort {$a <=> $b} @count;
  my $mincount = $count[0];
  my $maxcount = $count[$countlevel-1] + 1;

  my $fh = FileHandle->new("${filedir}count$filenumber[$mincount].dat", "w");
  if (defined $fh) {
    $fh->print($maxcount);
    $fh->close;
    return $maxcount;
  } else {
    # G[
    return -1;
  }
}


# Q҃JEg
# int mbrcount(int timestamp, String hostaddr, int bbsid)
sub mbrcount {
  my ($this, $timestamp, $hostaddr, $bbsid) = @_;

  my $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }

  my $filename = "${filedir}mbrcount.dat";

  my $ukey = 0;
  if ($hostaddr) {
    my @addrbin = split(/\./, $hostaddr);
    my $addrsum = 0;
    for my $i (0 .. 3) {
      $addrbin[$i] = vec(pack('C4', $addrbin[$i]), 0, 8);
      $addrsum += $addrbin[$i];
    }
    $ukey = $addrsum * ($addrbin[0] ^ $addrbin[1] & $addrbin[2] ^ $addrbin[3]);
  }

  my $mbrcount = 0;
  my @newcntdata;
  my $fh = FileHandle->new($filename, "r+");
  if ($fh) {
    binmode($fh);
    flock ($fh, LOCK_EX);
    seek ($fh, 0, 0);
    my @cntdata = $fh->getlines;
    my $cadd = 0;
    for my $cntvalue (@cntdata) {
      if (index($cntvalue, ',') > -1) {
        chomp $cntvalue;
        my ($cuser, $ctime) = split (/,/, $cntvalue, 2);
        if ($cuser eq $ukey) {
          push @newcntdata, "$ukey,$timestamp\n";
          $cadd = 1;
          $mbrcount++;
        }
        elsif (($ctime + $this->{c}->{cntlimit}) >= $timestamp) {
          push @newcntdata, "$cuser,$ctime\n";
          $mbrcount++;
        }
      }
    }
    if (!$cadd) {
      push @newcntdata, "$ukey,$timestamp\n";
      $mbrcount++;
    }
  }
  else {
    push @newcntdata, "$ukey,$timestamp\n";
    $mbrcount++;
    $fh = FileHandle->new($filename, "w");
    if ($fh) {
      flock ($fh, LOCK_EX);
      binmode($fh);
    }
  }

  if ($fh) {
    # f[^
    seek ($fh, 0, 0);
    truncate ($fh, 0);
    print $fh @newcntdata;
    flock ($fh, LOCK_UN);
    $fh->close;

    undef @newcntdata;
    return $mbrcount;
  }
  else {
    # G[
    return -1;
  }

}


#---------------------------------------------------------------
#   Private Methods
#---------------------------------------------------------------


# ǂݍݗpɃOt@CJBȂ΍쐬
# FileHandle _openLogfile(int bbsid, int logdate)
sub _openLogfile {
  my ($this, $bbsid, $logdate) = @_;
  my $filepath = $this->_getFilepath($bbsid, $logdate);
  my $fh = FileHandle->new($filepath);
  unless (defined $fh) {
    $fh = FileHandle->new($filepath, 'w');
    unless (defined $fh) {
      $this->db_error('db_logread');
    }
    undef $fh;
    $fh = FileHandle->new($filepath);
    unless (defined $fh) {
      $this->db_error('db_logread');
    }
  }
  return $fh;
}


# ǂݍݗpɃOt@CJBȂ΍쐬
# FileHandle _openLogfile(int bbsid, int logdate)
sub _openAnyfile {
  my ($this, $filename, $mode, $bbsid) = @_;
  $mode ||= 'r';
  my $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }
  my $filepath = $filedir . $filename;
  my $fh = FileHandle->new($filepath, $mode);
  unless (defined $fh) {
    $fh = FileHandle->new($filepath, 'w');
    unless (defined $fh) {
      $this->db_error('db_logread');
    }
    undef $fh;
    $fh = FileHandle->new($filepath, $mode);
    unless (defined $fh) {
      $this->db_error('db_logread');
    }
  }
  return $fh;
}


# Ot@C̃t@CpX
# String _getFilepath(int bbsid, int logdate)
sub _getFilepath {
  my ($this, $bbsid, $logdate) = @_;
  my ($filename, $filedir);
  $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }
  if (defined $logdate and $logdate > 0) {
    $filename = "$logdate.dat";
  } else {
    $filename = "log.dat";
  }
  return $filedir.$filename;
}


# Ot@C̃fBNgpX
# String _getDirpath(int bbsid)
sub _getDirpath {
  my ($this, $bbsid) = @_;
  my ($filename, $filedir);
  $filedir = $this->{c}->{datadir};
  $filedir .= '/' if ($filedir !~ /\/$/);
  if (defined $bbsid and $bbsid > 0) {
    $filedir .= "$bbsid/";
  }
  return $filedir;
}


# CSVOsbZ[Wɕϊ
# HashRef _convCSVToMessage(String logline);
sub _convCSVToMessage {
  my ($this, $logline) = @_;
  my $values = $this->_splitCSVLine($logline);

  my %message;
  while (my ($name, $value) = each %logformat) {
    $message{$name} = $values->[$value];
  }

  return \%message;
}


# l̃XgbZ[Wɕϊ
# HashRef _convListToMessage(ArrayRef values);
sub _convListToMessage {
  my ($this, $values) = @_;

  my %message;
  while (my ($name, $value) = each %logformat) {
    $message{$name} = $values->[$value];
  }

  return \%message;
}


# CSV`̍sl̃Xgo
# ArrayRef _parseCSVLine(String csvline);
sub _splitCSVLine {
  my ($this, $csvline) = @_;
  $csvline =~ s/(?:\x0D\x0A|[\x0D\x0A])?$/,/;
  my @values = map {/^"(.*)"$/ ? scalar($_ = $1, s/""/"/g, $_) : $_}
                ($csvline =~ /("[^"]*(?:""[^"]*)*"|[^,]*),/g);
  return \@values;
}


# z̊evfindexŃ}b`O
# bool _hasIndex(ArrayRef haystack, String needle)
sub _hasIndex {
  shift;
  for (@{$_[0]}) {
    if (index($_, $_[1]) > -1) {
      return 1;
    }
  }
  return 0;
}


1;
