# MySQL𗘗pDatabaseNX
package Kuzuha::Database::MySQL;
use strict;

use Kuzuha::Utility;
use DBI();

use Kuzuha::Database;
@Kuzuha::Database::MySQL::ISA = qw(Kuzuha::Database);

# \z
# Kuzuha::Database::MySQL new(String dburl)
sub new {
  my($class, $dburl) = @_;

  # f[^LbVbless
  my $this = {
    dburl => $dburl,
  };
  bless $this, $class;

  $this->dbConnect();

  # f[^LbṼNA
  delete $this->{c};
  $this->setConstants();

  return $this;
}


# j
DESTROY {
  my ($this) = @_;
  $this->dbDisconnect();
}

#---------------------------------------------------------------
#   Public Methods
#---------------------------------------------------------------

# DBڑ
# bool dbConnect()
sub dbConnect {
  my ($this) = @_;
  my ($dsn, $user, $password) = $this->_splitDBURL();
  $this->{dbh} = DBI->connect($dsn, $user, $password);
  unless (defined $this->{dbh}) {
    $this->db_error('db_connection_error');
  }
  return 1;
}

# DBؒf
# bool dbDisonnect()
sub dbDisconnect {
  my ($this) = @_;
  $this->{dbh}->disconnect()if defined $this->{dbh};
  undef $this->{dbh};
  return 1;
}


#---------------------------------------------------------------
#   ݒ


# ݒݒe[u擾
# void setConstants()
sub setConstants {
  my ($this) = @_;
  my (%data);

  my $sth = $this->{dbh}->prepare("SELECT name, value FROM constants");
  $sth->execute();
  while (my $ref = $sth->fetchrow_arrayref()) {
    $data{$ref->[0]} = $ref->[1];
  }
  $sth->finish();

  $this->{c} = \%data;
}


# ݒLbV擾
# HashRef getConstants()
sub getConstants {
  my ($this) = @_;

  unless (exists $this->{c}) {
    $this->setConstants();
  }

  return $this->{c};
}


# ݒ̐ݒeRg擾
# HashRef getConstComments()
sub getConstComments {
  my ($this, $bbsid) = @_;
  my %comments;

  my $sth = $this->{dbh}->prepare("SELECT name, comment FROM constants");
  $sth->execute();
  while (my $ref = $sth->fetchrow_arrayref()) {
    $comments{$ref->[0]} = $ref->[1];
  }
  $sth->finish();

  return \%comments;
}


# ݒύX
# int modifyConstant(String name, String value)
sub modifyConstant {
  my ($this, $name, $value) = @_;

  $this->{dbh}->do("UPDATE constants SET value=? WHERE name=?", undef, $value, $name)
    or $this->db_error($this->{dbh}->errstr);

  return 0;
}


#---------------------------------------------------------------
#   bZ[WQ


# ǃ|C^̎擾
# int getTopmsgid([int bbsid], [int logdate])
sub getTopmsgid {
  my ($this, $bbsid, $logdate) = @_;

  return $this->{topmsgid} if ($this->{topmsgid});

  my $sth = $this->{dbh}->prepare("SELECT msgid FROM msglog ORDER BY msgid DESC");
  $sth->execute();
  if (my $ref = $sth->fetchrow_arrayref()) {
    $this->{topmsgid} = $ref->[0];
  }
  else {
    $this->{topmsgid} = 0;
  }
  $sth->finish();

  return $this->{topmsgid};
}


# ۑĂ錏̎擾
# int countMessages([int bbsid], [int logdate]);
sub countMessages {
  my ($this, $bbsid, $logdate) = @_;
  my $count = 0;

  my $sth = $this->{dbh}->prepare("SELECT COUNT(msgid) FROM msglog");
  $sth->execute();
  if (my $ref = $sth->fetchrow_arrayref()) {
    $count = $ref->[0];
  }
  $sth->finish();

  return $count;
}


# w͈͂̃bZ[W擾
# ArrayRef getMessagesByRange(int bindex, int eindex, [int bbsid])
sub getMessagesByRange {
  my ($this, $bindex, $eindex, $bbsid) = @_;
  my (@logdata);

  my $sth = $this->{dbh}->prepare("SELECT * FROM msglog ORDER BY msgid DESC LIMIT $bindex, ".($eindex - $bindex));
  $sth->execute();
  while (my $ref = $sth->fetchrow_hashref()) {
    push @logdata, $ref;
  }
  $sth->finish();

  return \@logdata;
}


# SbZ[W擾
# ArrayRef getAllMessages([int bbsid])
sub getAllMessages {
  my ($this, $bbsid) = @_;
  my (@logdata);

  my $sth = $this->{dbh}->prepare("SELECT * FROM msglog ORDER BY msgid DESC");
  $sth->execute();
  while (my $ref = $sth->fetchrow_hashref()) {
    push @logdata, $ref;
  }
  $sth->finish();

  return \@logdata;
}


# wID̃bZ[W擾
# HashRef getMessageByID(int msgid, [int bbsid])
sub getMessageByID {
  my ($this, $msgid, $bbsid) = @_;
  my ($buffer, $message);

  my $sth = $this->{dbh}->prepare("SELECT * FROM msglog WHERE msgid=?");
  $sth->execute($msgid);
  if (my $ref = $sth->fetchrow_hashref()) {
    $message = $ref;
  }
  $sth->finish();

  return $message;
}


# wXbhID̃bZ[Wꗗ擾
# ArrayRef getMessagesByThreadID(int threadid, [int bbsid])
sub getMessagesByThreadID {
  my ($this, $threadid, $bbsid) = @_;
  my (@logdata);

  my $sth = $this->{dbh}->prepare("SELECT * FROM msglog WHERE threadid=? ORDER BY msgid DESC");
  $sth->execute($threadid);
  while (my $ref = $sth->fetchrow_hashref()) {
    push @logdata, $ref;
  }
  $sth->finish();

  return \@logdata;
}


# w肳ꂽeҖ̃bZ[Wꗗ擾
# ArrayRef getMessagesByThreadID(String name, [int bbsid])
sub getMessagesByName {
  my ($this, $name, $bbsid) = @_;
  my ($buffer, @logdata);

  my $sth = $this->{dbh}->prepare("SELECT * FROM msglog WHERE name=? ORDER BY msgid DESC");
  $sth->execute($name);
  while (my $ref = $sth->fetchrow_hashref()) {
    push @logdata, $ref;
  }
  $sth->finish();

  return \@logdata;
}


#---------------------------------------------------------------
#   bZ[W


# bZ[Wo^
# int insertMessage(HashRef message, [int bbsid])
sub insertMessage {
  my ($this, $message, $bbsid) = @_;

  $this->_lockDatabase('kuzuha_msgpost', 10);

  # `FbN
  my $posterr = 0;
  {
    my $sth = $this->{dbh}->prepare("SELECT * FROM msglog ORDER BY msgid DESC LIMIT $this->{c}->{checkcount}");
    $sth->execute();
    while (my $items = $sth->fetchrow_hashref()) {
      # d݃`FbN
      if ($message->{msg} eq $items->{msg}) {
        $posterr = 3;
        last;
      }
      # zXgeԊu`FbN
      if ($this->{c}->{iprec} and $message->{msgtime} < ($items->[0] + $this->{c}->{sptime})
       and $message->{hostname} eq $items->{hostname}) {
        $posterr = 2;
        last;
      }
      # dveNgR[h`FbN
      if ($message->{pcode} and $message->{pcode} eq $items->{pcode}) {
        $posterr = 2;
        last;
      }
    }
    $sth->finish();
  }
  if ($posterr) {
    $this->_unlockDatabase('kuzuha_msgpost');
    return $posterr;
  }

  # f[^̍쐬
  {
    my $sth = $this->{dbh}->prepare("SELECT msgid FROM msglog ORDER BY msgid DESC LIMIT 1");
    $sth->execute();
    if (my $items = $sth->fetchrow_arrayref()) {
      $message->{msgid} = $items->[0] + 1;
    }
    else {
      $message->{msgid} = 1;
    }
    $sth->finish();
    if (!$message->{refid} and !$message->{threadid}) {
      $message->{threadid} = $message->{msgid};
    }
  }
  {
    my @fields_all = qw(
      msgid
      bbsid
      threadid
      refid
      msgtime
      pcode
      hostname
      useragent
      name
      userattr
      title
      msg
      msgattr
    );
    my @fields;
    for my $field (@fields_all) {
      push @fields, $field if ($message->{$field});
    }
    my $sql = "INSERT INTO msglog (" . join (', ', @fields) . ") values (?";
    my $fieldindex = 0;
    $sql .= ', ?' while ++$fieldindex <= $#fields;
    $sql .= ')';
    my @values;
    for my $field (@fields) {
      push @values, $message->{$field};
    }
    $this->{dbh}->do($sql, undef, @values) or ($this->_unlockDatabase>('kuzuha_msgpost') and $this->db_error($this->{dbh}->errstr));
  }
  # Âf[^폜
  {
    my $minmsgid = 0;
    my $sth = $this->{dbh}->prepare("SELECT msgid FROM msglog ORDER BY msgid DESC LIMIT $this->{c}->{logsave}");
    $sth->execute();
    while (my $ref = $sth->fetchrow_arrayref()) {
      $minmsgid = $ref->[0];
    }
    $sth->finish();
    if ($minmsgid) {
      $this->{dbh}->do("DELETE FROM msglog WHERE msgid < ?", undef, $minmsgid)
       or ($this->_unlockDatabase>('kuzuha_msgpost') and $this->db_error($this->{dbh}->errstr));
    }
  }

  $this->_unlockDatabase('kuzuha_msgpost');

  return wantarray ? (0, $message) : 0;
}


# bZ[WߋOɒǉ
# int insertPastlog(HashRef message, String logdate, [int bbsid])
sub insertPastlog {
  my ($this, $message, $logdate, $bbsid) = @_;

  # ^`FbN
  $logdate =~ /^\d+$/ or $this->db_error('db_pastlog_logdate_incorrect');

  my $isnewdate = 0;
  my $totalbytes = 0;
  $message->{logdate} = $logdate;

  {
    my $sth = $this->{dbh}->prepare("SELECT COUNT(msgid) FROM msglog_past WHERE logdate=?");
    $sth->execute($logdate);
    unless ($sth->fetchrow_arrayref()) {
      $isnewdate = 1;
    }
    $sth->finish();
  }
  {
    my @fields_all = qw(
      msgid
      bbsid
      threadid
      refid
      msgtime
      pcode
      hostname
      useragent
      name
      userattr
      title
      msg
      msgattr
      logdate
    );
    my @fields;
    for my $field (@fields_all) {
      push @fields, $field if ($message->{$field});
    }
    my $sql = "INSERT INTO msglog_past (" . join (', ', @fields) . ") values (?";
    my $fieldindex = 0;
    $sql .= ', ?' while ++$fieldindex <= $#fields;
    $sql .= ')';
    my @values;
    for my $field (@fields) {
      push @values, $message->{$field};
      $totalbytes += length($message->{$field});
    }
    $this->{dbh}->do($sql, undef, @values) or $this->db_error($this->{dbh}->errstr);
  }

  # TCYXV
  {
    my $sth = $this->{dbh}->prepare("SELECT filesize FROM msglog_past_info WHERE logdate=?");
    $sth->execute($logdate);
    if ($sth->fetchrow_arrayref()) {
      $sth->finish();
      $this->{dbh}->do("UPDATE msglog_past_info SET filesize=filesize+?, modtime=? WHERE logdate=?",
       undef, $totalbytes, $message->{msgtime}, $logdate) or $this->db_error($this->{dbh}->errstr);
    }
    else {
      $sth->finish();
      $this->{dbh}->do("INSERT INTO msglog_past_info (logdate, filesize, modtime) VALUES (?, ?, ?)",
       undef, $logdate, $totalbytes, $message->{msgtime}) or $this->db_error($this->{dbh}->errstr);
    }
  }

  # ÂߋOƃTCY폜
  if ($isnewdate and $this->{c}->{pastlogsaveformat} == 0) {
    $logdate =~ /^\d{8}$/ or $this->db_error('db_pastlog_logdate_incorrect');
    my $pastdate = Kuzuha::Utility::addYYYYMMDD($logdate, -1 * $this->{c}->{pastlogsaveday});
    $this->{dbh}->do("DELETE FROM msglog_past WHERE logdate < ?", undef, $pastdate) or $this->db_error($this->{dbh}->errstr);
    $this->{dbh}->do("DELETE FROM msglog_past_info WHERE logdate < ?", undef, $pastdate) or $this->db_error($this->{dbh}->errstr);
  }

  return 0;
}


# ߋOt@Cꗗ̎擾
# ArrayRef getPastlogList()
sub getPastlogList {
  my ($this, $bbsid) = @_;
  my @pastloglist;

  {
    my $sth = $this->{dbh}->prepare("SELECT logdate, filesize, modtime FROM msglog_past_info ORDER BY logdate DESC");
    $sth->execute();
    while (my $info = $sth->fetchrow_arrayref()) {
      my %fileinfo;
      $fileinfo{filename} = $info->[0] . '.dat';
      $fileinfo{filesize} = $info->[1];
      $fileinfo{modtime} = $info->[2];
      push @pastloglist, \%fileinfo;
    }
    $sth->finish();
  }
  return \@pastloglist;
}


# ߋOJn
# resultsetLbVɕێ
sub beginPastlogSearch {
  my ($this, $logfile, $conditions, $bbsid) = @_;
  $logfile =~ s/\.dat$//;
  my $sql = "SELECT * FROM msglog_past WHERE logdate=$logfile";

  my ($searchexp, $rangeexp, @values);
  if (@{$conditions->{keyword}} or @{$conditions->{nkeyword}}) {
    my $andor = $conditions->{andor} eq 'o' ? ' OR ' : ' AND ';
    my @target;
    if ($conditions->{target} eq 'name'
     or $conditions->{target} eq 'title'
     or $conditions->{target} eq 'msg') {
      push @target, $conditions->{target};
    } else {
      @target = ('name', 'title', 'msg');
    }
    $sql .= " AND (";
    my $i = @{$conditions->{keyword}};
    if ($i) {
      $sql .= "(";
      for my $keyword (@{$conditions->{keyword}}) {
        $sql .= "(";
        my $j = 0;
        for my $target (@target) {
          $sql .= " OR " if ++$j > 1;
          $sql .= "$target REGEXP ?";
          push @values, quotemeta($keyword);
        }
        $sql .= ")";
        $sql .= $andor if --$i > 0;
      }
      $sql .= ")";
    }
    $i = @{$conditions->{nkeyword}};
    if ($i) {
      $sql .= $andor if @{$conditions->{keyword}};
      $sql .= "(";
      for my $keyword (@{$conditions->{nkeyword}}) {
        $sql .= "(";
        my $j = 0;
        for my $target (@target) {
          $sql .= " AND " if ++$j > 1;
          $sql .= "$target NOT REGEXP ?";
          push @values, quotemeta($keyword);
        }
        $sql .= ")";
        $sql .= $andor if --$i > 0;
      }
      $sql .= ")";
    }
    $sql .= ")";
  }

  if ($conditions->{range}) {
    $sql .= " AND msgtime BETWEEN '$conditions->{rangestart_iso}' AND '$conditions->{rangeend_iso}'";
  }

  if ($this->{c}->{debug} > 1) {
    use Kuzuha::Utility;
    dumpInComment($conditions, $sql, \@values);
  }
  my $sth = $this->{dbh}->prepare($sql);
  $sth->execute(@values);
  $this->{past_resultset} = $sth;
  $this->{past_hit} = 0;
  undef $this->{past_message};

  return 1;
}


# ߋOXbhJn
# resultsetLbVɕێ
sub beginPastlogSearchByThread {
  my ($this, $threadid, $logfile, $bbsid) = @_;
  $logfile =~ s/\.dat$//;
  my $sql = "SELECT * FROM msglog_past WHERE logdate=$logfile AND threadid=$threadid ORDER BY msgid ASC";
  my $sth = $this->{dbh}->prepare($sql);
  $sth->execute();
  $this->{past_resultset} = $sth;
  $this->{past_hit} = 0;
  undef $this->{past_message};
  # print "<pre><font color=#cccccc>$sql</font></pre>" if $this->{c}->{debug};

  return 1;
}


# ߋO
# resultseti߂ă}b`ɐ̂Ԃ
sub nextPastlogSearch {
  my ($this) = @_;
  if (my $ref = $this->{past_resultset}->fetchrow_hashref()) {
    $this->{past_hit}++;
    return $ref;
  }
  return undef;
}


# ߋOI
# resultset
sub endPastlogSearch {
  my ($this) = @_;
  $this->{past_resultset}->finish();
  delete $this->{past_resultset};
}


# ߋOqbg
sub getPastlogHit {
  my ($this) = @_;
  return $this->{past_hit};
}


# bZ[W폜
# deleteMessages(ArrayRef msgids)
sub deleteMessages {
  my ($this, $msgids, $bbsid) = @_;

  my $sql = "DELETE FROM msglog WHERE msgid=" . join (' OR msgid=', @$msgids);
  $this->{dbh}->do($sql) or $this->db_error($this->{dbh}->errstr);

  # ߋOTCYXV
  for my $msgid (@$msgids) {
    my $sth = $this->{dbh}->prepare(
    "SELECT logdate, LENGTH(msg)+LENGTH(pcode)+LENGTH(hostname)+LENGTH(useragent)+LENGTH(userattr)+LENGTH(title)"
    ." FROM msglog_past WHERE msgid=$msgid");
    $sth->execute() or $this->db_error($this->{dbh}->errstr);
    if (my $ref = $sth->fetchrow_arrayref()) {
      my $logdate = $ref->[0];
      my $delsize = $ref->[1];
      $sth->finish();
      $this->{dbh}->do("UPDATE msglog_past_info SET filesize=filesize-? WHERE logdate=?",
       undef, $delsize, $logdate) or $this->db_error($this->{dbh}->errstr);
    }
  }

  # ߋObZ[W폜
  $sql = "DELETE FROM msglog_past WHERE msgid=" . join (' OR msgid=', @$msgids);
  $this->{dbh}->do($sql) or $this->db_error($this->{dbh}->errstr);

  return 0;
}


#---------------------------------------------------------------
#   Œnh


# Œnh̔
sub isHandleName {
  my ($this, $candidate) = @_;

  my $hit = 0;
  my $sth = $this->{dbh}->prepare("SELECT name FROM handlename WHERE name=?");
  $sth->execute($candidate);
  if (my $ref = $sth->fetchrow_arrayref()) {
    $hit = 1;
  }
  $sth->finish();

  return $hit;
}

# ŒnhpX̔
sub getHandleNameByPass {
  my ($this, $candidate) = @_;

  my $name = undef;
  my $sth = $this->{dbh}->prepare("SELECT name FROM handlename WHERE pass=?");
  $sth->execute($candidate);
  if (my $ref = $sth->fetchrow_arrayref()) {
    $name = $ref->[0];
  }
  $sth->finish();

  return $name;
}

# Œnhꗗ
sub getHandleNames {
  my ($this) = @_;

  my @data;
  my $sth = $this->{dbh}->prepare("SELECT name, pass FROM handlename");
  $sth->execute();
  while (my @row = $sth->fetchrow_array()) {
    push @data, \@row;
  }
  $sth->finish();

  return \@data;
}


# Œnhǉ/pXҏW
sub insertHandleName {
  my ($this, $name, $pass) = @_;

  my $rv = $this->{dbh}->do("UPDATE handlename SET pass=? WHERE name=?", undef, $pass, $name);
  if ($rv eq '0E0') {
    $rv = $this->{dbh}->do("INSERT INTO handlename (pass, name) VALUES (?, ?)", undef, $pass, $name);
  }

  return 1;
}


# Œnh
sub deleteHandleName {
  my ($this, $name) = @_;

  $this->{dbh}->do("DELETE FROM handlename WHERE name=?", undef, $name);

  return 1;
}


#---------------------------------------------------------------
#   zXg


# zXgꗗ
sub getBanlist {
  my ($this, $matchtype) = @_;
  $matchtype ||= 0;

  my @data;
  my $sth = $this->{dbh}->prepare("SELECT id, hostname, nametype, bantype FROM banlist WHERE bantype >= $matchtype");
  $sth->execute();
  while (my @row = $sth->fetchrow_array()) {
    push @data, \@row;
  }
  $sth->finish();

  return \@data;
}


# zXgǉ
sub insertBanlist {
  my ($this, $hostname, $nametype, $bantype) = @_;
  my $id = 1;
  my $sth = $this->{dbh}->prepare("SELECT max(id) FROM banlist");
  $sth->execute();
  if (my $ref = $sth->fetchrow_arrayref()) {
    $id = $ref->[0] + 1;
  }
  $this->{dbh}->do("INSERT INTO banlist (id, hostname, nametype, bantype) VALUES (?, ?, ?, ?)",
   undef, $id, $hostname, $nametype, $bantype);
  return 1;
}


# zXgҏW
sub updateBanlist {
  my ($this, $id, $hostname, $nametype, $bantype) = @_;
  $this->{dbh}->do("UPDATE banlist SET hostname=?, nametype=?, bantype=? WHERE id=?",
   undef, $hostname, $nametype, $bantype, $id);
  return 1;
}


# zXg
sub deleteBanlist {
  my ($this, $id) = @_;
  $this->{dbh}->do("DELETE FROM banlist WHERE id=$id");
  return 1;
}


#---------------------------------------------------------------
#   e֎~


# e֎~
sub getNGWord {
  my ($this) = @_;

  my @data;
  my $sth = $this->{dbh}->prepare("SELECT ngword FROM ngword");
  $sth->execute();
  if (my $ref = $sth->fetchrow_arrayref()) {
    @data = split(/\n/, $ref->[0]);
  }
  $sth->finish();
  chomp @data;

  return \@data;
}

# e֎~ҏW
sub updateNGWord {
  my ($this, $ngword) = @_;
  my $rv = $this->{dbh}->do("UPDATE ngword SET ngword=?", undef, $ngword);
  if ($rv eq '0E0') {
    $rv = $this->{dbh}->do("INSERT INTO ngword (ngword) VALUES (?)", undef, $ngword);
  }
  return 1;
}


#---------------------------------------------------------------
#   JE^[


# JE^[
# int counter()
sub counter {
  my ($this, $bbsid) = @_;
  my $count = 0;

  my $sth = $this->{dbh}->prepare("SELECT counter FROM counter") or return -1;
  $sth->execute();
  if (my $ref = $sth->fetchrow_arrayref()) {
    $count = $ref->[0] + 1;
    $sth->finish();
    $this->{dbh}->do("UPDATE counter SET counter=counter+1") or return -1;
  }
  else {
    $sth->finish();
    $count = 1;
    $this->{dbh}->do("INSERT INTO counter (counter) values (1)") or return -1;
  }

  return $count;
}


# Q҃JEg
# int mbrcount()
sub mbrcount {
  my ($this, $timestamp, $hostaddr, $bbsid) = @_;
  my $ref;
  my $count = 0;

  my $ukey = 0;
  if ($hostaddr) {
    my @addrbin = split(/\./, $hostaddr);
    my $addrsum = 0;
    for my $i (0 .. 3) {
      $addrbin[$i] = vec(pack('C4', $addrbin[$i]), 0, 8);
      $addrsum += $addrbin[$i];
    }
    $ukey = $addrsum * ($addrbin[0] ^ $addrbin[1] & $addrbin[2] ^ $addrbin[3]);
  }

  my $result = 0;
  my $sth = $this->{dbh}->prepare("SELECT COUNT(mbrcode) FROM mbrcount where mbrcode=?") or return -1;
  $sth->execute($ukey);
  if ($ref = $sth->fetchrow_arrayref()) {
    $result = $ref->[0];
    $sth->finish();
    if ($result) {
      $this->{dbh}->do("UPDATE mbrcount SET mbrtime=?", undef,
       Kuzuha::Utility::convTimestampToISOTime($timestamp)) or return -1;
    }
  }
  else {
    $sth->finish();
  }

  unless ($result) {
    $this->{dbh}->do("INSERT INTO mbrcount (mbrcode, mbrtime) VALUES (?, ?)", undef,
     $ukey, Kuzuha::Utility::convTimestampToISOTime($timestamp)) or return -1;
  }
  $this->{dbh}->do("DELETE FROM mbrcount WHERE mbrtime < ?", undef,
   Kuzuha::Utility::convTimestampToISOTime($timestamp - $this->{c}->{cntlimit}));

  $sth = $this->{dbh}->prepare("SELECT COUNT(mbrcode) FROM mbrcount");
  $sth->execute();
  if ($ref = $sth->fetchrow_arrayref()) {
    $count =  $ref->[0];
  }

  return $count;
}


#---------------------------------------------------------------
#   Private Methods
#---------------------------------------------------------------


sub _splitDBURL {
  my ($this) = @_;
  if ($this->{dburl} =~ /^(.+;)user=(\w+);password=(\w+)$/) {
    return ($1, $2, $3);
  }
  else {
    return $this->{dburl};
  }
}


sub _lockDatabase {
  my ($this, $lockname, $timeout) = @_;

  my $sth_lock = $this->{dbh}->prepare("select GET_LOCK(?, ?)");
  $sth_lock->execute($lockname, $timeout);
  unless(my $ref = $sth_lock->fetchrow_arrayref()) {
    $sth_lock->finish();
    $this->db_error('db_lock_timeout');
  }
  $sth_lock->finish();
}


sub _unlockDatabase {
  my ($this, $lockname) = @_;

  my $sth_lock = $this->{dbh}->prepare("select RELEASE_LOCK(?)");
  $sth_lock->execute($lockname);
  $sth_lock->finish();
}


1;
