# HTML-TemplatẽbpHTTPwb_o͂Ȃ
package Kuzuha::Display;
use strict;

use HTML::Template;

# property index
use constant templatedir => 0;
use constant gzip => 1;
use constant use_compress_zlib => 2;
use constant cache => 3;
my $ext = '.tmpl';

# \z
# Kuzuha::Display new(String templatedir)
sub new {
  my ($class, $templatedir, $gzip) = @_;
  my $this = [
    $templatedir,
    $gzip,
    undef,
    {},
  ];
  bless $this, $class;

  # Compress::Zlib̌o
  if ($this->[gzip]) {
    eval { require Compress::Zlib; };
    $this->[use_compress_zlib] = !$@;
  }

  return $this;
}


# ev[g擾
# String getTemplate(String filename, HashRef data, HashRef options)
sub getTemplate {
  my ($this, $filename, $data, $options) = @_;
  my $tmpl;
  if ($this->[cache]->{$filename}) {
    $tmpl = $this->[cache]->{$filename};
    $tmpl->clear_params();
  } else {
    $tmpl = HTML::Template->new(
      die_on_bad_params => 0,
      filename => $this->[templatedir] . "/" . $filename . $ext,
    );
    $this->[cache]->{$filename} = $tmpl;
  }
  $tmpl->param(%$data);
  return $tmpl->output();
}

# ev[g\
# void prtTemplate(String filename, HashRef data, HashRef options)
sub prtTemplate {
  my ($this, @args) = @_;
  print $this->getTemplate(@args);
}


sub setCookie {
  my ($this, $name, $value, $timestamp) = @_;
  for (%$value) {
    s/(\W)/'%' . unpack('H2', $1)/eg;
  }
  $value = join '&', %$value;
  my $cookiestr = "Set-Cookie: $name=$value;";
  if ($timestamp) {
    my(@MON)=qw/Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec/;
    my(@WDAY) = qw/Sun Mon Tue Wed Thu Fri Sat/;
    my($sec,$min,$hour,$mday,$mon,$year,$wday) = gmtime($timestamp);
    $year += 1900;
    $cookiestr .= sprintf(" expires %s, %02d-%s-%04d %02d:%02d:%02d GMT;",
     $WDAY[$wday],$mday,$MON[$mon],$year,$hour,$min,$sec);
  }
  if ($ENV{SCRIPT_NAME} =~ /(^\/.+\/)[^\/]+$/) {
    $cookiestr .= " path=$1;"
  }
  print "$cookiestr\r\n";
}


sub disableGzip {
  my ($this) = @_;
  $this->[gzip] = 0;
}

sub enableGzip {
  my ($this) = @_;
  $this->[gzip] = 1;
}

# Content-Typeo(HTML)
# int prtHTTPHeader()
sub prtHTTPHeader {
  my ($this) = @_;

  print "Content-type: text/html; charset=Shift_JIS\r\n";
  my $gziped = $this->prtGzipHeader();
  return $gziped;
}

# Content-Typeo
sub prtContentType {
  my ($this, $content_type) = @_;
  print "Content-type: $content_type\r\n";
  my $gziped = $this->prtGzipHeader();
  return $gziped;
}


# Locationo
sub prtRedirectHeader {
  my ($this, $redirecturl) = @_;
  print "Location: $redirecturl\r\n";
  print "\r\n";
}

# Content-Dispositiono
sub prtContentDisposition {
  my ($this, $filename) = @_;
  $filename ||= 'bbs.html';
  #print "Content-Type: application/octet-stream\r\n";
  #print "Content-Disposition: attachment; filename=$filename\r\n";
  #print "Content-type: text/html; charset=Shift_JIS\r\n";
  print "Content-Type: application/x-gzip\r\n";
  print "Content-Disposition: attachment; filename=\"$filename\"\r\n";
  #print "\r\n";

  my $gziped = $this->prtGzipHeader();
  return $gziped;
}

# gzip]
# int prtGzipHeader()
sub prtGzipHeader {
  my ($this, $disablegzip) = @_;
  my $gziped = 0;
  if ($this->[gzip] and $ENV{'HTTP_ACCEPT_ENCODING'} =~ /gzip/
   and ($this->[use_compress_zlib] or -x $this->[gzip]) and !$disablegzip) {
    if ($this->[use_compress_zlib]) {
      $gziped = tie(*GZIP, "GzWrapper", \*STDOUT) ? 1 : 0;
    }
    else {
      open (GZIP, "| $this->[gzip] -cfnq");
      $gziped = 1;
    }
  }
  if ($gziped) {
    $| = 1;
    if ($ENV{'HTTP_ACCEPT_ENCODING'} =~ /x-gzip/) {
      print "Content-encoding: x-gzip\r\n";
    } else {
      print "Content-encoding: gzip\r\n";
    }
    print "\r\n";
    select (GZIP);
  }
  else {
    print "\r\n";
  }
  return $gziped;
}

1;

# gzip]Ή
{
  package GzWrapper;

  sub TIEHANDLE {
    my($class, $handle) = @_;
    return bless { handle => $handle }, $class;
  }
  sub PRINT {
    my $self = shift;
    if(!exists($self->{gz})) {
      # delayed open
      binmode($self->{handle});
      $self->{gz} = Compress::Zlib::gzopen($self->{handle}, "wb");
    }
    my $gz = $self->{gz} or return undef;
    for my $d (@_) {
      $self->{gz}->gzwrite($d);
    }
  }
  sub PRINTF {
    my $self = shift;
    $self->PRINT(sprintf(shift, @_));
  }
  sub DESTROY {
    my $self = shift;
    if($self->{gz}) {
      $self->{gz}->gzclose();
    }
  }
  1;
}

1;
