# p[^̏iHTTPNGXgAR}hCAϐj
package Kuzuha::Parameter;
use strict;

use CGI qw(:cgi);
use Kuzuha::Utility qw(base64_threebytehex twobytebase64_bin bin_twobytebase64);

# property index
use constant PARAMS => 0;
use constant CGIOBJ => 1;
use constant OPTIONS => 2;
use constant CONSTANTS => 3;

# \z
# Kuzuha::Parameter new(HashRef constants)
sub new {
  my ($class, $constants) = @_;
  my $this = [
    undef,
    undef,
    undef,
  ];
  bless $this, $class;

  $this->[CONSTANTS] = $constants;
  $this->[CGIOBJ] = CGI->new();
  $this->[PARAMS] = $this->[CGIOBJ]->Vars;
  $this->setOptions();

  return $this;
}


# tH[
# HashRef getParams()
sub getParams {
  my ($this) = @_;
  return $this->[PARAMS];
}

# CGI.pmIuWFNg
# CGI getCGI()
sub getCGI {
  my ($this) = @_;
  return $this->[CGIOBJ];
}

# Cookie
# HashRef getCookie(String cookiename)
sub getCookie {
  my ($this, $cookiename) = @_;
  return $this->[CGIOBJ]->cookie($cookiename);
}

# ͏ŗL̃ZbVf[^
# void setOptions()
sub setOptions {
  my ($this) = @_;
  my %options;
  $options{u} = $this->[PARAMS]->{u};
  $options{i} = $this->[PARAMS]->{i};
  $options{c} = $this->[PARAMS]->{c};

  # ݒCookie擾
  my %cookie = $this->[CGIOBJ]->cookie('c');
  if (%cookie) {
    unless (exists $this->[PARAMS]->{u}) {
      $options{u} = $cookie{u};
    }
    unless (exists $this->[PARAMS]->{i}) {
      $options{i} = $cookie{i};
    }
    unless (exists $this->[PARAMS]->{c}) {
      $options{c} = $cookie{c};
    }
  }
  # UNDO{^pCookie擾
  my %undocookie = $this->[CGIOBJ]->cookie('u');
  if (%undocookie) {
    $options{undo_p} = $undocookie{p};
    $options{undo_k} = $undocookie{k};
  }

  # ݒ
  $this->setCustomizedValues(\%options);

  unless ($options{cookie}) {
    $options{u} = $this->[PARAMS]->{u};
    $options{i} = $this->[PARAMS]->{i};
    delete $options{undo_p};
    delete $options{undo_k};
  }

  # ftHgNG
  $options{query} = "c=$options{c}";
  if ($this->[PARAMS]->{d}) {
    $options{query} .= ";d=$this->[PARAMS]->{d}";
  }
  if ($this->[PARAMS]->{p}) {
    $options{query} .= ";p=$this->[PARAMS]->{p}";
  }

  # ϐ
  $this->setHostEnv(\%options);

  $this->[OPTIONS] = \%options;
}

# HashRef options
sub options {
  my ($this) = @_;
  return $this->[OPTIONS];
}


# void setOption(String name, AnyData value)
sub setOption {
  my ($this, $name, $value) = @_;
  $this->[OPTIONS]->{$name} = $value;
}

# void setHostEnv(HashRef options)
sub setHostEnv {
  my ($this, $options) = @_;

  my $agent = $ENV{'HTTP_USER_AGENT'};
  my $addr = $ENV{'REMOTE_ADDR'};
  my $host = $ENV{'REMOTE_HOST'};
  if ( $addr eq $host || !$host ) {
    $host = gethostbyaddr ( pack ( 'C4', split ( /\./, $addr ) ), 2 ) || $addr;
  }

  $options->{useragent} = $agent;
  $options->{hostaddr} = $addr;
  $options->{hostname} = $host;
}

# void setHostEnvDetail(HashRef options)
sub setHostEnvDetail {
  my ($this, $options) = @_;

  my $agent = $ENV{'HTTP_USER_AGENT'};
  my $addr = $ENV{'REMOTE_ADDR'};
  my $host = $ENV{'REMOTE_HOST'};
  if ( $addr eq $host || !$host ) {
    $host = gethostbyaddr ( pack ( 'C4', split ( /\./, $addr ) ), 2 ) || $addr;
  }

  my $proxyflg = 0;

  if ( $ENV{'HTTP_CACHE_CONTROL'} )     { $proxyflg = 1; }
  if ( $ENV{'HTTP_CACHE_INFO'} )        { $proxyflg += 2; }
  if ( $ENV{'HTTP_CLIENT_IP'} )       { $proxyflg += 4; }
  if ( $ENV{'HTTP_FORWARDED'} )       { $proxyflg += 8; }
  if ( $ENV{'HTTP_FROM'} )          { $proxyflg += 16; }
  if ( $ENV{'HTTP_PROXY_AUTHORIZATION'} )   { $proxyflg += 32; }
  if ( $ENV{'HTTP_PROXY_CONNECTION'} )    { $proxyflg += 64; }
  if ( $ENV{'HTTP_SP_HOST'} )         { $proxyflg += 128; }
  if ( $ENV{'HTTP_VIA'} )           { $proxyflg += 256; }
  if ( $ENV{'HTTP_X_FORWARDED_FOR'} )     { $proxyflg += 512; }
  if ( $ENV{'HTTP_X_LOCKING'} )       { $proxyflg += 1024; }
  if ( $agent =~ /cache|delegate|gateway|httpd|proxy|squid|www|via/i ) {
    $proxyflg += 2048;
  }
  if ( $host =~ /cache|^dns|dummy|^ns|firewall|gate|keep|mail|^news|pop|proxy|smtp|w3|^web|www/i ) {
    $proxyflg += 4096;
  }
  if ( $host eq $addr ) {
    $proxyflg += 8192;
  }

  my $realaddr = '';
  my $realhost = '';
  if ( $proxyflg > 0 ) {

    if ( $ENV{'HTTP_X_FORWARDED_FOR'} =~
      s/^(\d+)\.(\d+)\.(\d+)\.(\d+).*/$1.$2.$3.$4/ ) {
      $realaddr = "$1.$2.$3.$4";
    } elsif ( $ENV{'HTTP_FORWARDED'} =~
      s/.*\s(\d+)\.(\d+)\.(\d+)\.(\d+)/$1.$2.$3.$4/ ) {
      $realaddr = "$1.$2.$3.$4";
    } elsif ( $ENV{'HTTP_VIA'} =~
      s/.*\s(\d+)\.(\d+)\.(\d+)\.(\d+)/$1.$2.$3.$4/ ) {
      $realaddr = "$1.$2.$3.$4";
    } elsif ( $ENV{'HTTP_CLIENT_IP'} =~
      s/(\d+)\.(\d+)\.(\d+)\.(\d+)/$1.$2.$3.$4/ ) {
      $realaddr = "$1.$2.$3.$4";
    } elsif ( $ENV{'HTTP_SP_HOST'} =~
      s/(\d+)\.(\d+)\.(\d+)\.(\d+)/$1.$2.$3.$4/ ) {
      $realaddr = "$1.$2.$3.$4";
    } elsif ( $ENV{'HTTP_FORWARDED'} =~ s/.*\sfor\s(.+)/$1/ ) {
      $realhost = "$1";
    } elsif ( $ENV{'HTTP_FROM'} =~ s/\-\@(.+)/$1/ ) {
      $realhost = "$1";
    }

    if ( !$realaddr && $realhost ) {
      my $realpackaddr = gethostbyname ( $realhost );
      my ( $a, $b, $c, $d ) = unpack ( 'C4', $realpackaddr );
      $realaddr = "$a.$b.$c.$d";
    }

  }

  $options->{useragent} = $agent;
  $options->{hostaddr} = $addr;
  $options->{hostname} = $host;
  $options->{proxyflg} = $proxyflg;
}


# ڂ̃NG擾ibbs.cgi/YYYYMMDD.html j
sub getPathInfo {
  if (@ARGV) {
    return join '', @ARGV;
  } else {
    return $ENV{PATH_INFO};
  }
}


# JX^}CYݒ̎擾
sub setCustomizedValues {
  my ($this, $options) = @_;

  $options ||= $this->[OPTIONS];

  $options->{linkoff} = 0 unless exists $options->{linkoff};
  $options->{hideform} = 0 unless exists $options->{hideform};
  $options->{reltype} = 0 unless exists $options->{reltype};
  $options->{showimg} = 0 unless exists $options->{showimg};

  my $flgcolorchanged = 0;

  my @colors = qw(c_background c_text c_a_color c_a_visited c_subj c_qmsg c_a_active c_a_hover);
  my @flags = qw(gzip reltype autolink followwin cookie linkoff hideform showimg autowrap); # 12܂

  # ݒ̃ftHgl
  for my $confname (@colors, @flags) {
    $options->{$confname} = $this->[CONSTANTS]->{$confname}
     if defined $this->[CONSTANTS]->{$confname} and (!exists $options->{$confname});
  }

  # ݒ蕶񂩂̍XV
  if (exists $this->[PARAMS]->{c}) {
    my $strflag = '';
    my $formc = $this->[PARAMS]->{c};
    if (length($formc) > 5) {
      my $formclen = length($formc);
      $strflag = substr($formc, 0, 2);
      my $currentpos = 2;
      for my $confname (@colors) {
        my $colorval = base64_threebytehex(substr($formc, $currentpos, 4));
        if (length($colorval) == 6 and $options->{$confname} !~ /^$colorval$/i) {
          $flgcolorchanged = 1;
          $options->{$confname} = $colorval;
        }
        $currentpos += 4;
        last if ($currentpos > $formclen);
      }
    }
    elsif (length($formc) == 2) {
      $strflag = $formc;
    }
    if ($strflag) {
      my $flagbin = twobytebase64_bin($strflag);
      my $currentpos = 0;
      for my $confname (@flags) {
        $options->{$confname}= substr($flagbin, $currentpos, 1);
        $currentpos++;
      }
    }
  }

  # ݒ̍XV
  if ($this->[PARAMS]->{m} eq 'p' or $this->[PARAMS]->{m} eq 'c') {
    $options->{autolink} = ($this->[PARAMS]->{a} ? 1 : 0);
    $options->{gzip} = ($this->[PARAMS]->{g} ? 1 : 0);
    $options->{linkoff} = ($this->[PARAMS]->{loff} ? 1 : 0);
    $options->{hideform} = ($this->[PARAMS]->{hide} ? 1 : 0);
    $options->{showimg} = ($this->[PARAMS]->{si} ? 1 : 0);
    $options->{autowrap} = ($this->[PARAMS]->{wrap} ? 1 : 0);
    if ($this->[PARAMS]->{m} eq 'c') {
      $options->{followwin} = ($this->[PARAMS]->{fw} ? 1 : 0);
      $options->{reltype} = ($this->[PARAMS]->{rt} ? 1 : 0);
      $options->{cookie} = ($this->[PARAMS]->{cookie} ? 1 : 0);
    }
  }

  # ʂȏiL[hɂtH[̕\j
  if ($options->{bbsmode_adminonly} != 0) {
    $options->{hideform} = ($this->[PARAMS]->{m} eq 'f' or ($this->[PARAMS]->{m} eq 'p' and $this->[PARAMS]->{write})) ? 0 : 1;
  }

  # ݒ蕶̍XV
  {
    my $flagbin = '';
    for my $confname (@flags) {
      $options->{$confname} ? ($flagbin .= '1') : ($flagbin .= '0');
    }
    my $flagvalue = bin_twobytebase64($flagbin);

    if ($flgcolorchanged) {
      $options->{c} = $flagvalue . substr($this->[PARAMS]->{c}, 2);
    }
    else {
      $options->{c} = $flagvalue;
    }
  }

}


1;
