# ZbVnf[^ƃIuWFNgQ̐AێNX
package Kuzuha::Session;
use strict;

use Kuzuha::Database;
use Kuzuha::Parameter;
use Kuzuha::Display;

# require Time::Local;
# my $timeoffset = Time::Local::timegm(0, 0, 0, 1, 0, 70); # tuning for MacOS
my $timeoffset = 0;

# \z
# Kuzuha::Session new()
sub new {
  my($class, @args) = @_;
  my $this = {
  };
  bless $this, $class;

  $this->{database} = $this->createDatabase(@args);
  $this->{parameter} = $this->createParameter();
  $this->{display} = $this->createDisplay();
  $this->{currenttime} = $timeoffset + time();
  $this->{cputime} = times();

  return $this;
}

# Kuzuha::Database createDatabase(String dbmode, String dburl)
sub createDatabase {
  my($this, $dbmode, $dburl) = @_;
  return Kuzuha::Database->new($dbmode, $dburl);
}

# Kuzuha::Parameter createParameter()
sub createParameter {
  my ($this) = @_;
  return Kuzuha::Parameter->new($this->{database}->getConstants());
}

# Kuzuha::Display createDisplay()
sub createDisplay {
  my ($this) = @_;
  return Kuzuha::Display->new($this->{database}->getConstants()->{templatedir}, $this->{database}->getConstants()->{gzip});
}

# Kuzuha::Database db
sub db { $_[0]->{database} }

# Kuzuha::Parameter parameter
sub parameter { $_[0]->{parameter} }

# Kuzuha::Display display
sub display { $_[0]->{display} }

# int getTime()
sub getTime { $_[0]->{currenttime} }

# float getCPUTime()
sub getCPUTime { $_[0]->{cputime} }

# void setVersion(String version)
sub setVersion {
  my ($this, $version) = @_;
  $this->{version} = $version;
}

# String getVersion()
sub getVersion { $_[0]->{version} }

# void setAdminpost(String adminpost)
sub setAdminpost {
  my ($this, $adminpost) = @_;
  $this->{adminpost} = $adminpost;
}

# String getAdminpost()
sub getAdminpost { $_[0]->{adminpost} }

# Ǘ҃tO
sub isAdmin {
  my ($this) = @_;
  return $this->{isadmin} if exists $this->{isadmin};
  $this->{isadmin} = 0;
  if ($this->{adminpost} and crypt($this->{parameter}->options->{u}, $this->{adminpost}) eq $this->{adminpost}) {
    $this->{isadmin} = 1;
  }
  return $this->{isadmin};
}



1;
