# [eBeB
package Kuzuha::Utility;
use strict;

use Time::Local;

require Exporter;
@Kuzuha::Utility::ISA = qw(Exporter);
use vars qw(@EXPORT @EXPORT_OK);

@EXPORT = qw(debugPrint dumpInComment);
@EXPORT_OK = qw(
  getFixednumber escapeHTML escapeURL addLink insertComma checkMBStringMatch
  genPcode verifyPcode base64_threebytehex threebytehex_base64 twobytebase64_bin bin_twobytebase64
  convTimestampToISOTime convISOTimeToTimeformat convTimestampToTimeformat getJpWeekday getWeekday addYYYYMMDD
  matchHostname getCPUTimeDiff
);



#---------------------------------------------------------------
# 񏈗n

# l̐l
# int getFixednumber(String numberstr)
sub getFixednumber {
  my ($numberstr) = @_;
  $numberstr =~ s/[\s\r\n]+//g;
  my @twobytenumstr = ('O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', );
  for my $number (0 .. 9) {
    $numberstr =~ s/$twobytenumstr[$number]/$number/;
  }
  if ($numberstr =~ /^-?\d+$/) {
    return $numberstr;
  } else {
    return undef;
  }
}

# HTMLGXP[v
sub escapeHTML {
  my ($text, $delreturn) = @_;
  if (ref($text)) {
    $$text =~ s/\&/&amp;/g;
    $$text =~ s/</&lt;/g;
    $$text =~ s/>/&gt;/g;
    $$text =~ s/\"/&quot;/g;
    if ($delreturn) {
      $$text =~ tr/\r\n//d;
    }
  }
  else {
    $text =~ s/\&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    $text =~ s/\"/&quot;/g;
    if ($delreturn) {
      $text =~ tr/\r\n//d;
    }
    return $text;
  }
}

# URLGXP[v
sub escapeURL {
  my ($text) = @_;
  $text =~ s/(\W)/'%' . unpack('H2', $1)/eg;
  return $text;
}

# URLNǉ
sub addLink {
  my ($text) = @_;
  if (ref($text)) {
    $$text =~ s/(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<a href=\"$1\">$1<\/a>/g;
  } else {
    $text =~ s/(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<a href=\"$1\">$1<\/a>/g;
    return $text;
  }
}

# 3Ƃcomme͂ݍ
sub insertComma {
  my ($text) = @_;
  1 while $text =~ s/(.*\d)(\d\d\d)/$1,$2/;
  return $text;
}

# Q̃}`oCg}b`O
# UnicodeɂxɑΉ\
sub checkMBStringMatch {
  my ($string1, $string2) = @_;
  my $matched = 0;
  if ($string1 eq $string2) {
    $matched = 1;
  }
  return $matched;
}


#---------------------------------------------------------------
# encoding

# veNgR[h
# String genPcode(int timestamp, String seed, String hostaddr)
sub genPcode {
  my ($timestamp, $seed, $hostaddr) = @_;
  my $ukey = 0;
  if ($hostaddr) {
    my @addrbin = split(/\./, $hostaddr);
    my $addrsum = 0;
    for my $i (0 .. 3) {
      $addrbin[$i] = vec(pack('C4', $addrbin[$i]), 0, 8);
      $addrsum += $addrbin[$i];
    }
    $ukey = $addrsum * ($addrbin[0] ^ $addrbin[1] & $addrbin[2] ^ $addrbin[3]);
  }
  my $basecode =  sprintf("%X", $timestamp + $ukey);
  my $cryptcode = crypt($basecode . $seed, $seed . $basecode);
  $cryptcode =~ s/\W//g;
  $cryptcode = substr($cryptcode, -4);
  my $pcode = sprintf("%X", $timestamp) . $cryptcode;
  return $pcode;
}

# veNgR[hƍ
# String verifyPcode(String pcode, String seed, String hostaddr)
sub verifyPcode {
  my ($pcode, $seed, $hostaddr) = @_;
  my $timestamp = hex(substr($pcode, 0, 8));
  my $checkedcode = genPcode($timestamp, $seed, $hostaddr);
  if ($pcode ne $checkedcode) {
    return undef;
  } else {
    return $timestamp;
  }
}

sub base64_threebytehex {
  my ($str) = @_;
  if (length($str) != 4) {
    return '';
  }
  my $basestr = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_';
  my $decval =
   262144 * rindex($basestr, substr($str, 0, 1))
   + 4096 * rindex($basestr, substr($str, 1, 1))
   + 64 * rindex($basestr, substr($str, 2, 1))
   + rindex($basestr, substr($str, 3, 1));
  my $hexval = sprintf("%06lx", $decval);
  return $hexval;
}

sub threebytehex_base64 {
  my ($inputhex) = @_;
  my $inputdec = hex($inputhex);

  my $a = int($inputdec / 262144);
  my $tmp_a = $inputdec - 262144 * $a;
  my $b = int($tmp_a / 4096);
  my $tmp_b = $tmp_a - 4096 * $b;
  my $c = int($tmp_b / 64);
  my $d = $tmp_b - 64 * $c;

  my @basestr = split(//, '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_');
  my $base64val = $basestr[$a] . $basestr[$b] . $basestr[$c] . $basestr[$d];
  return $base64val;
}

sub twobytebase64_bin {
  my ($str) = @_;
  if (length($str) != 2) {
    return '';
  }
  my $basestr = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_';
  my $binstr = substr(unpack("b8", pack("C", rindex($basestr, substr($str, 0, 1)))), 0, 6)
   . substr(unpack("b8", pack("C", rindex($basestr, substr($str, 1, 1)))), 0, 6);
  return $binstr;
}

sub bin_twobytebase64 {
  my ($str) = @_;
  my $basestr = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_';
  my $base64str = substr($basestr, unpack("C", pack("b8", substr($str, 0, 6))), 1)
   . substr($basestr, unpack("C", pack("b8", substr($str, 6))), 1);
  return $base64str;
}


#---------------------------------------------------------------
# tԏn

# ISO-8601`̓tԕɕϊ
# String convTimestampToISOTime(int timestamp)
sub convTimestampToISOTime {
  my ($timestamp) = @_;
  my ($sec, $min, $hours, $mday, $mon, $year) = localtime($timestamp);
  $year += 1900;
  $mon++;
  return sprintf('%04d-%02d-%02d %02d:%02d:%02d', $year, $mon, $mday, $hours, $min, $sec);
}

# ISO-8601`̓tԕ񂩂wtH[}bgɕϊ
# String convISOTimeToTimeformat(String isotime, String timeformat)
sub convISOTimeToTimeformat {
  my ($isotime, $timeformat) = @_;
  my ($sec, $min, $hours, $mday, $mon, $year, $wday);
  my $timestr = $timeformat;
  if ($isotime =~ /^(\d+)-(\d+)-(\d+)/) {
    $year = sprintf('%04d', $1); $mon = sprintf('%02d', $2); $mday = sprintf('%02d', $3);
  }
  if ($isotime =~ /(\d+):(\d+):(\d+)$/) {
    $hours = sprintf('%02d', $1); $min = sprintf('%02d', $2); $sec = sprintf('%02d', $3);
  }
  $timestr =~ s/<year>/$year/;
  $timestr =~ s/<mon>/$mon/;
  $timestr =~ s/<mday>/$mday/;
  $timestr =~ s/<hours>/$hours/;
  $timestr =~ s/<min>/$min/;
  $timestr =~ s/<sec>/$sec/;
  if ($timestr =~ /<jwday>/) {
    my $jwday = getJpWeekday($year, $mon, $mday);
    $timestr =~ s/<jwday>/$jwday/;
  }
  return $timestr;
}

# ^CX^vwtH[}bgɕϊ
# String convTimestampToTimeformat(int timestamp, String timeformat)
sub convTimestampToTimeformat {
  my ($timestamp, $timeformat) = @_;
  my $timestr = $timeformat;
  my ($sec, $min, $hours, $mday, $mon, $year, $wday) = localtime($timestamp);
  $year += 1900;
  $mon++;

  $year = sprintf('%04d', $year);
  $mon = sprintf('%02d', $mon);
  $mday = sprintf('%02d', $mday);
  $hours = sprintf('%02d', $hours);
  $min = sprintf('%02d', $min);
  $sec = sprintf('%02d', $sec);

  $timestr =~ s/<year>/$year/;
  $timestr =~ s/<mon>/$mon/;
  $timestr =~ s/<mday>/$mday/;
  $timestr =~ s/<hours>/$hours/;
  $timestr =~ s/<min>/$min/;
  $timestr =~ s/<sec>/$sec/;
  if ($timestr =~ /<jwday>/) {
    my $jwday = ('', '', '', '', '', '', 'y')[$wday];
    $timestr =~ s/<jwday>/$jwday/;
  }
  return $timestr;
}

# (YYYY, MM, DD)jԂ
# String getJpWeekday(int pyear, int pmonth, int pmday);
sub getJpWeekday {
  my ($pyear, $pmonth, $pmday) = @_;
  return ('', '', '', '', '', '', 'y')[getWeekday($pyear, $pmonth, $pmday)];
}
sub getWeekday {
  my ($pyear, $pmonth, $pmday) = @_;

  # cF[̌
  if ($pmonth < 3) {--$pyear; $pmonth+=12;}
  my $wday = ($pyear+int($pyear/4)
  -int($pyear/100)
  +int($pyear/400)
  +int((13*$pmonth+8)/5)
  +$pmday) % 7;

  return $wday;
}

# YYYYMMDD̎w̓tYYYYMMDDŕԂi}CiXj
# String addYYYYMMDD(String yyyymmdd, int days)
sub addYYYYMMDD {
  my ($yyyymmdd, $days) = @_;
  $yyyymmdd =~ /^(\d\d\d\d)(\d\d)(\d\d)$/ or return undef;
  my ($year_base, $mon_base, $mday_base) = ($1, $2, $3);
  my $timestamp = timelocal(0, 0, 0, $mday_base, $mon_base-1, $year_base) + (86400 * $days);
  my ($sec, $min, $hours, $mday, $mon, $year) = localtime($timestamp);
  $year += 1900;
  $mon++;
  return sprintf("%04d%02d%02d", $year, $mon, $mday);
}

#---------------------------------------------------------------
# misc

# zXgXgƂ̏ƍ
# bool matchHostname(String hostname, ArrayRef hostpatterns)
sub matchHostname {
  my ($hostname, $hostpatterns, $matchtype) = @_;
  for my $hostpattern (@$hostpatterns) {
    # IPAhX
    if ($hostpattern->[2]) {
      $hostpattern->[1] =~ s/\./\\\./g;
      $hostpattern->[1] =~ s/\*/\\d\+/g;
      if ($hostname =~ /$hostpattern->[1]/) {
        return 1;
      }
    }
    # zXg
    else {
      $hostpattern->[1] = quotemeta($hostpattern->[1]);
      $hostpattern->[1] =~ s/\\\*/\\\.\+/g;
      if ($hostname =~ /$hostpattern->[1]/) {
        return 1;
      }
    }
  }
  return 0;
}

sub getCPUTimeDiff {
  my ($start, $end) = @_;
  return sprintf("%.2f", $end - $start);
}

sub debugPrint {
  my ($debugmessage) = @_;
  open (DEBUG, ">> debug.txt");
  print DEBUG "$debugmessage\n";
  close DEBUG;
}

sub dumpInComment {
  use Data::Dumper qw(Dumper);
  print "<!--\n".Dumper(@_)."\n-->";
}

1;
