
package Kuzuha::Session;

=head1 O

Kuzuha::Session - O[of[^W[

=head1 Tv

use Kuzuha::Session;

my $session = Kuzuha::Session->new($dbmode, $dburl);
my $constants = $session->getConstants();
my $form = $session->getForm();
my $db = $session->getDB();


=head1 v

=head1 

ȉ̃O[oɎgpf[^̐
Eݒ
EtH[
ECGIIuWFNg
EDBRlNV
ECookie(TODO)

=head1 EXPORTED FUNCTIONS

=cut

use strict;

use base 'Exporter';
use vars qw($VERSION @EXPORT);

@EXPORT = qw(
  setConstants
  getConstants
  setForm
  getForm
  setCGI
  getCGI
  setDB
  getDB
  hasError
);

# staticȓnbVϐ
#   ݒ: $session{constants}
#   tH[: $session{form}
#   CGIIuWFNg: $session{cgi}
#   DBRlNV: $session{db}
my %session;



#-- RXgN^
sub new {
  my($class, $dbmode, $dburl) = @_;

  my $self = bless {
    dbmode => $dbmode,
    dburl => $dburl,
  }, $class;
  $self->_initialize();
  return $self;
}


#-- 
sub _initialize {
  my $self = shift;
  
  undef %session;
  $self->setDB($self->{dbmode}, $self->{dburl});
  $self->setConstants();
  $self->setCGI();
  $self->setForm();
}


#-- ݒsetter
sub setConstants {
  my $self = shift;
  
  # DBRlNV쐬
  if (!(exists $session{db})) {
    $self->setDB();
  }
  
  # DB̐ݒ擾
  my $constants = $session{db}->getDBConstants();
  
  # mod_perl(TODO)
  if (exists $ENV{'GATEWAY_INTERFACE'}
   and ($constants->{mod_perl} = $ENV{'GATEWAY_INTERFACE'} =~ /^CGI-Perl\//)) {
    $| = 1;
    require Apache;
  }
  
  $session{constants} = $constants;
}


#-- ݒgetter
sub getConstants {
  my $self = shift;
  
  if (!(exists $session{constants})) {
    $self->setConstants();
  }
  
  return $session{constants};
}


#-- tH[setter
sub setForm {
  my $self = shift;

  if (!(exists $session{cgi})) {
    $self->setCGI();
  }
  
  $session{form} = $session{cgi}->Vars;
}


#-- tH[getter
sub getForm {
  my $self = shift;

  if (!(exists $session{form})) {
    $self->setForm();
  }
  
  return $session{form};
}


#-- CGIIuWFNgsetter
# CGI.pm̃IuWFNgB
# ႦΈȉ̂悤ɂăAbv[ht@C̃t@Cnh擾łB
#   $fh = $session{cgi}->upload('t@CtB[h');
# Iɂ͓ƎW[Kuzuha::Utility::CGI쐬B
sub setCGI {
  my $self = shift;

  use CGI;
  my $q = CGI->new();
  $session{cgi} = $q;
}


#-- CGIIuWFNggetter
sub getCGI {
  my $self = shift;

  if (!(exists $session{cgi})) {
    $self->setCGI();
  }
  
  return $session{cgi};
}


#-- DBRlNVsetter
sub setDB {
  my($self, $dbmode, $dburl) = @_;

  $dbmode ||= $self->{dbmode};
  $dburl ||= $self->{dburl};

  use Kuzuha::DB;
  my $db = Kuzuha::DB->new($dbmode, $dburl);
  $session{db} = $db;
}


#-- DBRlNVgetter
sub getDB {
  my $self = shift;

  if (!(exists $session{db})) {
    $self->setDB();
  }
  
  return $session{db};
}


#-- G[
sub hasError {
  return 0;
}


# W[̏I
1;
